package logging;
import java.io.ByteArrayInputStream;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;

/**
 * Allows to store logs in Amazon S3 bucket
 * @author Bogumil Kaminski & Przemyslaw Szufel
 */

public class StoreLogAmazonS3 implements StoreLog {
	
	private final AmazonS3 s3Client;
	private final Bucket bucket;
	private final  String folder;

	
	public StoreLogAmazonS3 (AmazonS3 s3Client, String bucket, String folder, String region) {
		this.s3Client = s3Client;
		this.folder = folder;
		this.bucket = s3Client.createBucket(bucket);
	}

	@Override
	public void store(String fileName, byte[] log) {
		ByteArrayInputStream bas = new ByteArrayInputStream(log);		
		ObjectMetadata objectMetadata = new ObjectMetadata();
		objectMetadata.setContentLength(log.length);
		PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket.getName(), folder+"/"+fileName, bas, objectMetadata);
		s3Client.putObject(putObjectRequest);
	}
	
	


}
