package clustersim;

import java.util.ArrayList;

import org.apache.commons.math3.distribution.NormalDistribution;

import simtools.RandomStream;


/**
 * Represents a R&S point Y.
 * @author Bogumil Kaminski & Przemyslaw Szufel
 */

public class RSpoint {
    double u; //mi uknown
    double sig;  //sigma uknown

	int s = 0; //number of running calculations
	
	ArrayList<Double> ys;
	NormalDistribution normalD;
	private RandomStream rs;
	public final int i;
	
	public double ys_sum;
	/**
	 * @return the mean for values simulated so far or zero if nothing is known about that point
	 */
	public double getMeanY() {		
		if (ys.size()==0) return 0.0;
		return ys_sum/ys.size();
	}
	
	public RSpoint (RandomStream rs, int i) {		
		this.rs=rs;
		this.i=i;		
		//this.ys=new ArrayList<>();
		//parameterization following Frazier i Powell (2009) 
		// The knowledge gradient policy for offline learning with independent normal rewards 
		u = new NormalDistribution(0, 1).inverseCumulativeProbability(rs.random());
		sig = 1;
		normalD = new NormalDistribution(u, sig);
		ys = new ArrayList<>();
		ys_sum = 0.0;
		//System.out.println("R&S point "+i+" u="+u+" sig="+sig+" randomStream="+rs.id());
	}
	
	private double y;
	/**
	 * @return evaluates a new point - this method may be only evaluated by the main loop
	 */
	double get_y(CompClusterEmulator cluster) {
		y = normalD.inverseCumulativeProbability(rs.random());
		//ys.add(y);
		ys.add(y);		
		ys_sum +=y;
		//System.out.println(this);
		return y;
	}
	
	public String toString() {
		return "R&S point "+i+"/c="+ys.size()+" real u="+u+" sig="+sig+" current u="+getMeanY();
	}	
	/**
	 * @return s - the number of currently running calculations for this point
	 */
	public int getS () {
		return s;
	}
}
