/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;
import sim.util.Bag;
import sim.util.IntBag;
import sim.util.gui.ColorWell;
import sim.util.gui.NumberTextField;
import sim.util.media.chart.ChartGenerator;
import sim.util.media.chart.DataCuller;
import sim.util.media.chart.SeriesAttributes;
import sim.util.media.chart.TimeSeriesChartGenerator;

public class TimeSeriesAttributes
extends SeriesAttributes {
    static final float DASH = 6.0f;
    static final float DOT = 1.0f;
    static final float SPACE = 3.0f;
    static final float SKIP = 6.0f;
    static final float[][] dashPatterns = new float[][]{{6.0f, 0.0f}, {12.0f, 6.0f}, {6.0f, 6.0f}, {6.0f, 3.0f}, {6.0f, 3.0f, 6.0f, 3.0f, 1.0f, 3.0f}, {6.0f, 3.0f, 1.0f, 3.0f}, {6.0f, 3.0f, 1.0f, 3.0f, 1.0f, 3.0f}, {1.0f, 3.0f}, {1.0f, 6.0f}};
    float stretch;
    NumberTextField stretchField;
    float thickness;
    NumberTextField thicknessField;
    int dashPattern;
    JComboBox dashPatternList;
    Color strokeColor;
    ColorWell strokeColorWell;
    XYSeries series;
    static Bag tmpBag = new Bag();

    public void setThickness(double value) {
        this.thicknessField.setValue(this.thicknessField.newValue(value));
    }

    public double getThickness() {
        return this.thicknessField.getValue();
    }

    public void setStretch(double value) {
        this.stretchField.setValue(this.stretchField.newValue(value));
    }

    public double getStretch() {
        return this.stretchField.getValue();
    }

    public void setDashPattern(int value) {
        if (value >= 0 && value < dashPatterns.length) {
            this.dashPatternList.setSelectedIndex(value);
            this.dashPattern = value;
        }
    }

    public int getDashPattern() {
        return this.dashPatternList.getSelectedIndex();
    }

    public void setStrokeColor(Color value) {
        this.strokeColor = value;
        this.strokeColorWell.setColor(this.strokeColor);
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    @Override
    public void setSeriesName(String val) {
        this.series.setKey((Comparable)((Object)val));
    }

    @Override
    public String getSeriesName() {
        return "" + this.series.getKey();
    }

    public TimeSeriesAttributes(ChartGenerator generator, XYSeries series, int index, SeriesChangeListener stoppable) {
        super(generator, "" + series.getKey(), index, stoppable);
        this.series = series;
    }

    @Override
    public void rebuildGraphicsDefinitions() {
        float[] newDashPattern = new float[dashPatterns[this.dashPattern].length];
        int x = 0;
        while (x < newDashPattern.length) {
            if (this.stretch * this.thickness > 0.0f) {
                newDashPattern[x] = dashPatterns[this.dashPattern][x] * this.stretch * this.thickness;
            }
            ++x;
        }
        XYItemRenderer renderer = this.getRenderer();
        renderer.setSeriesStroke(this.getSeriesIndex(), (Stroke)(this.dashPattern == 0 ? new BasicStroke(this.thickness, 1, 1, 0.0f) : new BasicStroke(this.thickness, 1, 1, 0.0f, newDashPattern, 0.0f)));
        renderer.setSeriesPaint(this.getSeriesIndex(), (Paint)this.strokeColor);
        this.repaint();
    }

    @Override
    public void buildAttributes() {
        this.dashPattern = 0;
        this.stretch = 1.0f;
        this.thickness = 2.0f;
        XYItemRenderer renderer = this.getRenderer();
        Paint paint = renderer.getItemPaint(this.getSeriesIndex(), -1);
        this.strokeColor = (Color)paint;
        this.strokeColorWell = new ColorWell(this.strokeColor){

            @Override
            public Color changeColor(Color c) {
                TimeSeriesAttributes.this.strokeColor = c;
                TimeSeriesAttributes.this.rebuildGraphicsDefinitions();
                return c;
            }
        };
        this.addLabelled("Color", this.strokeColorWell);
        this.thicknessField = new NumberTextField(2.0, true){

            @Override
            public double newValue(double newValue) {
                if (newValue < 0.0) {
                    newValue = this.currentValue;
                }
                TimeSeriesAttributes.this.thickness = (float)newValue;
                TimeSeriesAttributes.this.rebuildGraphicsDefinitions();
                return newValue;
            }
        };
        this.addLabelled("Width", this.thicknessField);
        this.dashPatternList = new JComboBox();
        this.dashPatternList.setEditable(false);
        this.dashPatternList.setModel(new DefaultComboBoxModel<String>(new Vector<String>(Arrays.asList("Solid", "__  __  __", "_  _  _  _", "_ _ _ _ _", "_ _ . _ _ .", "_ . _ . _ .", "_ . . _ . .", ". . . . . . .", ".  .  .  .  ."))));
        this.dashPatternList.setSelectedIndex(0);
        this.dashPatternList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeSeriesAttributes.this.dashPattern = TimeSeriesAttributes.this.dashPatternList.getSelectedIndex();
                TimeSeriesAttributes.this.rebuildGraphicsDefinitions();
            }
        });
        this.addLabelled("Dash", this.dashPatternList);
        this.stretchField = new NumberTextField(1.0, true){

            @Override
            public double newValue(double newValue) {
                if (newValue < 0.0) {
                    newValue = this.currentValue;
                }
                TimeSeriesAttributes.this.stretch = (float)newValue;
                TimeSeriesAttributes.this.rebuildGraphicsDefinitions();
                return newValue;
            }
        };
        this.addLabelled("Stretch", this.stretchField);
    }

    public boolean possiblyCull() {
        DataCuller dataCuller = ((TimeSeriesChartGenerator)this.generator).getDataCuller();
        if (dataCuller != null && dataCuller.tooManyPoints(this.series.getItemCount())) {
            this.deleteItems(dataCuller.cull(this.getXValues(), true));
            return true;
        }
        return false;
    }

    void deleteItems(IntBag items) {
        if (items.numObjs == 0) {
            return;
        }
        tmpBag.clear();
        int currentTabooIndex = 0;
        int currentTaboo = items.objs[0];
        Iterator iter = this.series.getItems().iterator();
        int index = 0;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (index == currentTaboo) {
                currentTaboo = currentTabooIndex < items.numObjs - 1 ? items.objs[++currentTabooIndex] : -1;
            } else {
                tmpBag.add(o);
            }
            ++index;
        }
        this.series.clear();
        int i = 0;
        while (i < TimeSeriesAttributes.tmpBag.numObjs) {
            this.series.add((XYDataItem)TimeSeriesAttributes.tmpBag.objs[i], false);
            ++i;
        }
        tmpBag.clear();
        this.series.fireSeriesChanged();
    }

    double[] getXValues() {
        double[] xValues = new double[this.series.getItemCount()];
        int i = 0;
        while (i < xValues.length) {
            xValues[i] = this.series.getX(i).doubleValue();
            ++i;
        }
        return xValues;
    }
}

