/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media.chart;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.general.SeriesChangeListener;
import sim.util.gui.LabelledList;
import sim.util.gui.PropertyField;
import sim.util.media.chart.ChartGenerator;

public abstract class SeriesAttributes
extends LabelledList {
    SeriesChangeListener stoppable;
    int seriesIndex;
    ChartGenerator generator;
    String seriesName;
    public static final ImageIcon I_DOWN = SeriesAttributes.iconFor("DownArrow.png");
    public static final ImageIcon I_DOWN_PRESSED = SeriesAttributes.iconFor("DownArrowPressed.png");
    public static final ImageIcon I_CLOSE = SeriesAttributes.iconFor("CloseBox.png");
    public static final ImageIcon I_CLOSE_PRESSED = SeriesAttributes.iconFor("CloseBoxPressed.png");
    public static final ImageIcon I_UP = SeriesAttributes.iconFor("UpArrow.png");
    public static final ImageIcon I_UP_PRESSED = SeriesAttributes.iconFor("UpArrowPressed.png");
    Box manipulators;
    boolean plotVisible = true;

    public SeriesChangeListener getStoppable() {
        return this.stoppable;
    }

    public void setStoppable(SeriesChangeListener obj) {
        this.stoppable = obj;
    }

    @Override
    public void setName(String val) {
        super.setName(val);
    }

    public void setSeriesName(String val) {
        this.seriesName = val;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    public String getSeriesName() {
        return this.seriesName;
    }

    public abstract void rebuildGraphicsDefinitions();

    public abstract void buildAttributes();

    public Color reviseColor(Color c, double opacity) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(opacity * 255.0));
    }

    public Plot getPlot() {
        return this.generator.getChartPanel().getChart().getPlot();
    }

    public ChartGenerator getGenerator() {
        return this.generator;
    }

    public int getSeriesIndex() {
        return this.seriesIndex;
    }

    public void setSeriesIndex(int val) {
        this.seriesIndex = val;
    }

    public XYItemRenderer getRenderer() {
        return ((XYPlot)this.getPlot()).getRenderer();
    }

    static ImageIcon iconFor(String name) {
        return new ImageIcon(SeriesAttributes.class.getResource(name));
    }

    void buildManipulators() {
        JButton removeButton = new JButton(I_CLOSE);
        removeButton.setPressedIcon(I_CLOSE_PRESSED);
        removeButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        removeButton.setBorderPainted(false);
        removeButton.setContentAreaFilled(false);
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JOptionPane.showOptionDialog(null, "Remove the Series " + SeriesAttributes.this.getSeriesName() + "?", "Confirm", 0, 3, null, new Object[]{"Remove", "Cancel"}, null) == 0) {
                    SeriesAttributes.this.getGenerator().removeSeries(SeriesAttributes.this.getSeriesIndex());
                }
            }
        });
        removeButton.setToolTipText("Remove this series");
        JButton upButton = new JButton(I_UP);
        upButton.setPressedIcon(I_UP_PRESSED);
        upButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        upButton.setBorderPainted(false);
        upButton.setContentAreaFilled(false);
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeriesAttributes.this.getGenerator().moveSeries(SeriesAttributes.this.getSeriesIndex(), true);
            }
        });
        upButton.setToolTipText("Draw this series higher in the series order");
        JButton downButton = new JButton(I_DOWN);
        downButton.setPressedIcon(I_DOWN_PRESSED);
        downButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        downButton.setBorderPainted(false);
        downButton.setContentAreaFilled(false);
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeriesAttributes.this.getGenerator().moveSeries(SeriesAttributes.this.getSeriesIndex(), false);
            }
        });
        downButton.setToolTipText("Draw this series lower in the series order");
        this.manipulators.add(removeButton);
        this.manipulators.add(upButton);
        this.manipulators.add(downButton);
    }

    public void setPlotVisible(boolean val) {
        this.plotVisible = val;
        this.getRenderer().setSeriesVisible(this.seriesIndex, new Boolean(val));
    }

    public boolean isPlotVisible() {
        return this.plotVisible;
    }

    public SeriesAttributes(ChartGenerator generator, String name, int index, SeriesChangeListener stoppable) {
        super(name);
        this.setStoppable(stoppable);
        this.generator = generator;
        this.seriesIndex = index;
        final JCheckBox check = new JCheckBox();
        check.setSelected(true);
        check.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeriesAttributes.this.setPlotVisible(check.isSelected());
            }
        });
        this.manipulators = new Box(0);
        this.buildManipulators();
        JLabel spacer = new JLabel("");
        spacer.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        Box b = new Box(0);
        b.add(check);
        b.add(spacer);
        b.add(this.manipulators);
        b.add(Box.createGlue());
        this.addLabelled("Show", b);
        PropertyField nameF = new PropertyField(name){

            @Override
            public String newValue(String newValue) {
                SeriesAttributes.this.setSeriesName(newValue);
                SeriesAttributes.this.getGenerator().getChartPanel().repaint();
                return newValue;
            }
        };
        this.addLabelled("Series", nameF);
        this.buildAttributes();
        this.rebuildGraphicsDefinitions();
    }
}

