/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.general.SeriesChangeListener;
import sim.util.gui.ColorWell;
import sim.util.gui.NumberTextField;
import sim.util.media.chart.ChartGenerator;
import sim.util.media.chart.HistogramGenerator;
import sim.util.media.chart.SeriesAttributes;

public class HistogramSeriesAttributes
extends SeriesAttributes {
    double[] values;
    float thickness;
    NumberTextField thicknessField;
    Color fillColor;
    ColorWell fillColorWell;
    Color strokeColor;
    ColorWell strokeColorWell;
    double fillOpacity;
    NumberTextField fillOpacityField;
    double lineOpacity;
    NumberTextField lineOpacityField;
    NumberTextField numBinsField;
    int numBins;
    static final int DEFAULT_BINS = 8;

    double[] getValues() {
        return this.values;
    }

    void setValues(double[] vals) {
        this.values = vals;
    }

    public void setFillOpacity(double value) {
        this.fillOpacityField.setValue(this.fillOpacityField.newValue(value));
    }

    public double getFillOpacity() {
        return this.fillOpacityField.getValue();
    }

    public void setStrokeOpacity(double value) {
        this.lineOpacityField.setValue(this.lineOpacityField.newValue(value));
    }

    public double getStrokeOpacity() {
        return this.lineOpacityField.getValue();
    }

    public void setThickness(double value) {
        this.thicknessField.setValue(this.thicknessField.newValue(value));
    }

    public double getThickness() {
        return this.thicknessField.getValue();
    }

    public void setNumBins(int value) {
        this.numBinsField.setValue(this.numBinsField.newValue(value));
        this.numBins = (int)this.numBinsField.getValue();
    }

    public int getNumBins() {
        return this.numBins;
    }

    public void setFillColor(Color value) {
        this.fillColor = value;
        this.fillColorWell.setColor(this.fillColor);
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setStrokeColor(Color value) {
        this.strokeColor = value;
        this.strokeColorWell.setColor(this.strokeColor);
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public HistogramSeriesAttributes(ChartGenerator generator, String name, int index, double[] values, int bins, SeriesChangeListener stoppable) {
        super(generator, name, index, stoppable);
        this.setValues(values);
        super.setSeriesName(name);
        this.numBins = bins;
        this.numBinsField.setValue(bins);
        this.numBinsField.setInitialValue(bins);
    }

    @Override
    public void setSeriesName(String val) {
        super.setSeriesName(val);
        ((HistogramGenerator)this.generator).update();
    }

    @Override
    public void rebuildGraphicsDefinitions() {
        XYBarRenderer renderer = (XYBarRenderer)this.getRenderer();
        if ((double)this.thickness == 0.0) {
            renderer.setDrawBarOutline(false);
        } else {
            renderer.setSeriesOutlineStroke(this.getSeriesIndex(), (Stroke)new BasicStroke(this.thickness));
            renderer.setDrawBarOutline(true);
        }
        renderer.setSeriesPaint(this.getSeriesIndex(), (Paint)this.reviseColor(this.fillColor, this.fillOpacity));
        renderer.setSeriesOutlinePaint(this.getSeriesIndex(), (Paint)this.reviseColor(this.strokeColor, this.lineOpacity));
        this.repaint();
    }

    @Override
    public void buildAttributes() {
        this.thickness = 2.0f;
        this.fillOpacity = 1.0;
        this.lineOpacity = 1.0;
        this.numBinsField = new NumberTextField("", 8.0, true){

            @Override
            public double newValue(double newValue) {
                if ((newValue = (double)((int)newValue)) < 1.0) {
                    newValue = this.currentValue;
                }
                HistogramSeriesAttributes.this.numBins = (int)newValue;
                ((HistogramGenerator)HistogramSeriesAttributes.this.generator).update();
                return newValue;
            }
        };
        this.addLabelled("Bins", this.numBinsField);
        this.fillColor = (Color)this.getRenderer().getItemPaint(this.getSeriesIndex(), -1);
        this.fillColor = (Color)this.getRenderer().getSeriesPaint(this.getSeriesIndex());
        this.fillColorWell = new ColorWell(this.fillColor){

            @Override
            public Color changeColor(Color c) {
                HistogramSeriesAttributes.this.fillColor = c;
                HistogramSeriesAttributes.this.rebuildGraphicsDefinitions();
                return c;
            }
        };
        this.addLabelled("Fill", this.fillColorWell);
        this.fillOpacityField = new NumberTextField("Opacity ", this.fillOpacity, 1.0, 0.125){

            @Override
            public double newValue(double newValue) {
                if (newValue < 0.0 || newValue > 1.0) {
                    newValue = this.currentValue;
                }
                HistogramSeriesAttributes.this.fillOpacity = (float)newValue;
                HistogramSeriesAttributes.this.rebuildGraphicsDefinitions();
                return newValue;
            }
        };
        this.addLabelled("", this.fillOpacityField);
        this.strokeColor = Color.black;
        this.strokeColorWell = new ColorWell(this.strokeColor){

            @Override
            public Color changeColor(Color c) {
                HistogramSeriesAttributes.this.strokeColor = c;
                HistogramSeriesAttributes.this.rebuildGraphicsDefinitions();
                return c;
            }
        };
        this.addLabelled("Line", this.strokeColorWell);
        this.lineOpacityField = new NumberTextField("Opacity ", this.lineOpacity, 1.0, 0.125){

            @Override
            public double newValue(double newValue) {
                if (newValue < 0.0 || newValue > 1.0) {
                    newValue = this.currentValue;
                }
                HistogramSeriesAttributes.this.lineOpacity = (float)newValue;
                HistogramSeriesAttributes.this.rebuildGraphicsDefinitions();
                return newValue;
            }
        };
        this.addLabelled("", this.lineOpacityField);
        this.thicknessField = new NumberTextField((double)this.thickness, false){

            @Override
            public double newValue(double newValue) {
                if (newValue < 0.0) {
                    newValue = this.currentValue;
                }
                HistogramSeriesAttributes.this.thickness = (float)newValue;
                HistogramSeriesAttributes.this.rebuildGraphicsDefinitions();
                return newValue;
            }
        };
        this.addLabelled("Width", this.thicknessField);
    }
}

