/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media;

import java.awt.Image;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullBufferStream;
import javax.media.util.ImageToBuffer;

class MovieEncoderDataStream
implements PullBufferStream {
    Buffer buffer = null;
    Format format;
    boolean ended = false;
    boolean endAcknowledged = false;
    float frameRate;

    MovieEncoderDataStream(Format format, float frameRate) {
        this.frameRate = frameRate;
        this.format = format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finish() {
        MovieEncoderDataStream movieEncoderDataStream = this;
        synchronized (movieEncoderDataStream) {
            this.ended = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(Image i) {
        Buffer b = ImageToBuffer.createBuffer((Image)i, (float)this.frameRate);
        while (this.checkWriteBlock()) {
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
        MovieEncoderDataStream movieEncoderDataStream = this;
        synchronized (movieEncoderDataStream) {
            this.buffer = b;
        }
    }

    synchronized boolean checkWriteBlock() {
        return this.buffer != null;
    }

    synchronized boolean checkReadBlock() {
        return this.buffer == null && !this.ended;
    }

    public boolean willReadBlock() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Buffer buf) throws IOException {
        while (this.checkReadBlock()) {
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        MovieEncoderDataStream movieEncoderDataStream = this;
        synchronized (movieEncoderDataStream) {
            if (this.buffer != null) {
                buf.setData(this.buffer.getData());
                buf.setLength(this.buffer.getLength());
                buf.setOffset(0);
                buf.setFormat(this.format);
                buf.setFlags(buf.getFlags() | 0x10 | 0x20);
            }
            this.buffer = null;
            if (this.ended) {
                buf.setEOM(true);
                buf.setOffset(0);
                buf.setLength(0);
                this.endAcknowledged = true;
            }
        }
    }

    public Format getFormat() {
        return this.format;
    }

    public ContentDescriptor getContentDescriptor() {
        return new ContentDescriptor("raw");
    }

    public long getContentLength() {
        return 0L;
    }

    public boolean endOfStream() {
        return this.ended;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String type) {
        return null;
    }
}

