/*
 * Decompiled with CFR 0.152.
 */
package sim.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class DisclosurePanel
extends JPanel {
    JToggleButton disclosureToggle = new JToggleButton();
    Component abridgedComponent;
    Component disclosedComponent;
    boolean disclosed = false;

    public DisclosurePanel(String abridgedText, Component disclosedComponent) {
        this(abridgedText, disclosedComponent, null);
    }

    public DisclosurePanel(String abridgedText, Component disclosedComponent, String borderLabel) {
        this(new JButton(abridgedText), disclosedComponent);
        JButton button = (JButton)this.abridgedComponent;
        button.setContentAreaFilled(false);
        button.setFocusPainted(false);
        button.setRequestFocusEnabled(false);
        button.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        button.setHorizontalAlignment(2);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DisclosurePanel.this.disclosureToggle.doClick();
            }
        });
    }

    public DisclosurePanel(Component abridgedComponent, Component disclosedComponent) {
        this(abridgedComponent, disclosedComponent, null);
    }

    public DisclosurePanel(Component abridgedComponent, Component disclosedComponent, String borderLabel) {
        this.disclosureToggle.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.disclosureToggle.setContentAreaFilled(false);
        this.disclosureToggle.setFocusPainted(false);
        this.disclosureToggle.setRequestFocusEnabled(false);
        this.disclosureToggle.setIcon(UIManager.getIcon("Tree.collapsedIcon"));
        this.disclosureToggle.setSelectedIcon(UIManager.getIcon("Tree.expandedIcon"));
        this.abridgedComponent = abridgedComponent;
        this.disclosedComponent = disclosedComponent;
        this.setLayout(new BorderLayout());
        JPanel b = new JPanel();
        b.setLayout(new BorderLayout());
        b.add((Component)this.disclosureToggle, "North");
        this.add((Component)b, "West");
        this.add(abridgedComponent, "Center");
        if (borderLabel != null) {
            this.setBorder(new TitledBorder(borderLabel));
        }
        this.disclosureToggle.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DisclosurePanel.this.setDisclosed(DisclosurePanel.this.disclosureToggle.isSelected());
            }
        });
    }

    public void setDisclosed(boolean disclosed) {
        this.disclosed = disclosed;
        if (disclosed) {
            this.remove(this.abridgedComponent);
            this.add(this.disclosedComponent, "Center");
            this.revalidate();
        } else {
            this.remove(this.disclosedComponent);
            this.add(this.abridgedComponent, "Center");
            this.revalidate();
        }
        this.disclosureToggle.setSelected(disclosed);
    }

    public boolean isDisclosed() {
        return this.disclosed;
    }

    public Component getAbridgedComponent() {
        return this.abridgedComponent;
    }

    public Component getDisclosedComponent() {
        return this.disclosedComponent;
    }

    public void setAbridgedComponent(Component abridgedComponent) {
        if (!this.disclosureToggle.isSelected()) {
            this.remove(this.abridgedComponent);
            this.add(abridgedComponent, "Center");
            this.revalidate();
        }
        this.abridgedComponent = abridgedComponent;
    }

    public void setDisclosedComponent(Component disclosedComponent) {
        if (this.disclosureToggle.isSelected()) {
            this.remove(this.disclosedComponent);
            this.add(disclosedComponent, "Center");
            this.revalidate();
        }
        this.disclosedComponent = disclosedComponent;
    }
}

