/*
 * Decompiled with CFR 0.152.
 */
package sim.util.distribution;

import ec.util.MersenneTwisterFast;
import sim.util.distribution.AbstractDiscreteDistribution;
import sim.util.distribution.Arithmetic;
import sim.util.distribution.Gamma;
import sim.util.distribution.Poisson;
import sim.util.distribution.Probability;

public class NegativeBinomial
extends AbstractDiscreteDistribution {
    private static final long serialVersionUID = 1L;
    protected int n;
    protected double p;
    protected Gamma gamma;
    protected Poisson poisson;

    public NegativeBinomial(int n, double p, MersenneTwisterFast randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setNandP(n, p);
        this.gamma = new Gamma(n, 1.0, randomGenerator);
        this.poisson = new Poisson(0.0, randomGenerator);
    }

    public double cdf(int k) {
        return Probability.negativeBinomial(k, this.n, this.p);
    }

    @Override
    public int nextInt() {
        return this.nextInt(this.n, this.p);
    }

    public int nextInt(int n, double p) {
        double x = p / (1.0 - p);
        double p1 = p;
        double y = x * this.gamma.nextDouble(n, 1.0);
        return this.poisson.nextInt(y);
    }

    public double pdf(int k) {
        if (k > this.n) {
            throw new IllegalArgumentException();
        }
        return Arithmetic.binomial(this.n, (long)k) * Math.pow(this.p, k) * Math.pow(1.0 - this.p, this.n - k);
    }

    public void setNandP(int n, double p) {
        this.n = n;
        this.p = p;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.n + "," + this.p + ")";
    }
}

