/*
 * Decompiled with CFR 0.152.
 */
package sim.util.distribution;

import ec.util.MersenneTwisterFast;
import sim.util.distribution.BreitWigner;
import sim.util.distribution.Uniform;

public class BreitWignerMeanSquare
extends BreitWigner {
    private static final long serialVersionUID = 1L;
    protected Uniform uniform;

    public BreitWignerMeanSquare(double mean, double gamma, double cut, MersenneTwisterFast randomGenerator) {
        super(mean, gamma, cut, randomGenerator);
        this.uniform = new Uniform(randomGenerator);
    }

    @Override
    public double nextDouble(double mean, double gamma, double cut) {
        if (gamma == 0.0) {
            return mean;
        }
        if (cut == Double.NEGATIVE_INFINITY) {
            double val = Math.atan(-mean / gamma);
            double rval = this.uniform.nextDoubleFromTo(val, 1.5707963267948966);
            double displ = gamma * Math.tan(rval);
            return Math.sqrt(mean * mean + mean * displ);
        }
        double tmp = Math.max(0.0, mean - cut);
        double lower = Math.atan((tmp * tmp - mean * mean) / (mean * gamma));
        double upper = Math.atan(((mean + cut) * (mean + cut) - mean * mean) / (mean * gamma));
        double rval = this.uniform.nextDoubleFromTo(lower, upper);
        double displ = gamma * Math.tan(rval);
        return Math.sqrt(Math.max(0.0, mean * mean + mean * displ));
    }
}

