/*
 * Decompiled with CFR 0.152.
 */
package sim.util.distribution;

import ec.util.MersenneTwisterFast;
import sim.util.distribution.AbstractContinousDistribution;

public class BreitWigner
extends AbstractContinousDistribution {
    private static final long serialVersionUID = 1L;
    protected double mean;
    protected double gamma;
    protected double cut;

    public BreitWigner(double mean, double gamma, double cut, MersenneTwisterFast randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(mean, gamma, cut);
    }

    @Override
    public double nextDouble() {
        return this.nextDouble(this.mean, this.gamma, this.cut);
    }

    public double nextDouble(double mean, double gamma, double cut) {
        if (gamma == 0.0) {
            return mean;
        }
        if (cut == Double.NEGATIVE_INFINITY) {
            double rval = 2.0 * this.randomGenerator.nextDouble() - 1.0;
            double displ = 0.5 * gamma * Math.tan(rval * 1.5707963267948966);
            return mean + displ;
        }
        double val = Math.atan(2.0 * cut / gamma);
        double rval = 2.0 * this.randomGenerator.nextDouble() - 1.0;
        double displ = 0.5 * gamma * Math.tan(rval * val);
        return mean + displ;
    }

    public void setState(double mean, double gamma, double cut) {
        this.mean = mean;
        this.gamma = gamma;
        this.cut = cut;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.mean + "," + this.gamma + "," + this.cut + ")";
    }
}

