/*
 * Decompiled with CFR 0.152.
 */
package sim.util;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Scanner;
import javax.swing.ImageIcon;
import sun.awt.image.ToolkitImage;

public class TableLoader {
    static String tokenizeString(InputStream stream) throws IOException {
        return TableLoader.tokenizeString(stream, false);
    }

    static String tokenizeString(InputStream stream, boolean oneChar) throws IOException {
        int c;
        int EOF = -1;
        StringBuilder b = new StringBuilder();
        boolean inComment = false;
        while (true) {
            if ((c = stream.read()) == -1) {
                throw new IOException("Stream ended prematurely, before table reading was completed.");
            }
            if (inComment) {
                if (c != 13 && c != 10) continue;
                inComment = false;
                continue;
            }
            if (Character.isWhitespace((char)c)) continue;
            if (c != 35) break;
            inComment = true;
        }
        b.append((char)c);
        if (oneChar) {
            return b.toString();
        }
        while ((c = stream.read()) != -1) {
            if (c == 35) {
                while ((c = stream.read()) != -1 && c != 13 && c != 10) {
                }
                continue;
            }
            if (Character.isWhitespace((char)c)) break;
            b.append((char)c);
        }
        return b.toString();
    }

    static int tokenizeInt(InputStream stream) throws IOException {
        return Integer.parseInt(TableLoader.tokenizeString(stream));
    }

    public static int[][] loadPNMFile(InputStream str, boolean flipY) throws IOException {
        int[][] vals = TableLoader.loadPNMFile(str);
        if (flipY) {
            int i = 0;
            while (i < vals.length) {
                int height = vals[i].length;
                int j = 0;
                while (j < height / 2) {
                    int temp = vals[i][j];
                    vals[i][j] = vals[i][height - j + 1];
                    vals[i][height - j + 1] = temp;
                    ++j;
                }
                ++i;
            }
        }
        return vals;
    }

    public static int[][] loadPNMFile(InputStream str) throws IOException {
        BufferedInputStream stream = new BufferedInputStream(str);
        String type = TableLoader.tokenizeString(stream);
        if (type.equals("P1")) {
            return TableLoader.loadPlainPBM(stream);
        }
        if (type.equals("P2")) {
            return TableLoader.loadPlainPGM(stream);
        }
        if (type.equals("P4")) {
            return TableLoader.loadRawPBM(stream);
        }
        if (type.equals("P5")) {
            return TableLoader.loadRawPGM(stream);
        }
        throw new IOException("Not a viable PBM or PGM stream");
    }

    static int[][] loadPlainPGM(InputStream stream) throws IOException {
        int width = TableLoader.tokenizeInt(stream);
        int height = TableLoader.tokenizeInt(stream);
        int maxGray = TableLoader.tokenizeInt(stream);
        if (width < 0) {
            throw new IOException("Invalid width in PGM: " + width);
        }
        if (height < 0) {
            throw new IOException("Invalid height in PGM: " + height);
        }
        if (maxGray <= 0) {
            throw new IOException("Invalid maximum value in PGM: " + maxGray);
        }
        int[][] field = new int[width][height];
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                field[j][i] = TableLoader.tokenizeInt(stream);
                ++j;
            }
            ++i;
        }
        return field;
    }

    static int[][] loadRawPGM(InputStream stream) throws IOException {
        int width = TableLoader.tokenizeInt(stream);
        int height = TableLoader.tokenizeInt(stream);
        int maxVal = TableLoader.tokenizeInt(stream);
        if (width < 0) {
            throw new IOException("Invalid width: " + width);
        }
        if (height < 0) {
            throw new IOException("Invalid height: " + height);
        }
        if (maxVal <= 0) {
            throw new IOException("Invalid maximum value: " + maxVal);
        }
        int[][] field = new int[width][height];
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                field[j][i] = maxVal < 256 ? stream.read() : (maxVal < 65536 ? stream.read() << 8 & stream.read() : (maxVal < 0x1000000 ? stream.read() << 16 & stream.read() << 8 & stream.read() : stream.read() << 24 & stream.read() << 16 & stream.read() << 8 & stream.read()));
                ++j;
            }
            ++i;
        }
        return field;
    }

    static int[][] loadPlainPBM(InputStream stream) throws IOException {
        int width = TableLoader.tokenizeInt(stream);
        int height = TableLoader.tokenizeInt(stream);
        if (width < 0) {
            throw new IOException("Invalid width in PBM: " + width);
        }
        if (height < 0) {
            throw new IOException("Invalid height in PBM: " + height);
        }
        int[][] field = new int[width][height];
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                String s = TableLoader.tokenizeString(stream, true);
                if (s.equals("0")) {
                    field[j][i] = 0;
                } else if (s.equals("1")) {
                    field[j][i] = 1;
                } else {
                    throw new IOException("Invalid byte data in PBM");
                }
                ++j;
            }
            ++i;
        }
        return field;
    }

    static int[][] loadRawPBM(InputStream stream) throws IOException {
        int width = TableLoader.tokenizeInt(stream);
        int height = TableLoader.tokenizeInt(stream);
        if (width < 0) {
            throw new IOException("Invalid width in PBM: " + width);
        }
        if (height < 0) {
            throw new IOException("Invalid height in PBM: " + height);
        }
        int[][] field = new int[width][height];
        int i = 0;
        while (i < height) {
            int data = 0;
            int count = 0;
            int j = 0;
            while (j < width) {
                if (count == 0) {
                    data = stream.read();
                    count = 8;
                }
                field[j][i] = data >> --count & 1;
                ++j;
            }
            ++i;
        }
        return field;
    }

    public static double[][] loadTextFile(InputStream str, boolean flipY) throws RuntimeException, IOException {
        double[][] vals = TableLoader.loadTextFile(str);
        if (flipY) {
            int i = 0;
            while (i < vals.length) {
                int height = vals[i].length;
                int j = 0;
                while (j < height / 2) {
                    double temp = vals[i][j];
                    vals[i][j] = vals[i][height - j + 1];
                    vals[i][height - j + 1] = temp;
                    ++j;
                }
                ++i;
            }
        }
        return vals;
    }

    public static double[][] loadTextFile(InputStream stream) throws IOException {
        Scanner scan = new Scanner(stream);
        ArrayList<double[]> rows = new ArrayList<double[]>();
        int width = -1;
        while (scan.hasNextLine()) {
            Scanner rowScan;
            String srow = scan.nextLine().trim();
            if (srow.length() <= 0) continue;
            int w = 0;
            if (width == -1) {
                ArrayList<Double> firstRow = new ArrayList<Double>();
                rowScan = new Scanner(new StringReader(srow));
                while (rowScan.hasNextDouble()) {
                    firstRow.add(new Double(rowScan.nextDouble()));
                    ++w;
                }
                width = w;
                double[] row = new double[width];
                int i = 0;
                while (i < width) {
                    row[i] = (Double)firstRow.get(i);
                    ++i;
                }
                rows.add(row);
                continue;
            }
            double[] row = new double[width];
            rowScan = new Scanner(new StringReader(srow));
            while (rowScan.hasNextDouble()) {
                if (w == width) {
                    throw new IOException("Row lengths do not match in text file");
                }
                row[w] = rowScan.nextDouble();
                ++w;
            }
            if (w < width) {
                throw new IOException("Row lengths do not match in text file");
            }
            rows.add(row);
        }
        if (width == -1) {
            return new double[0][0];
        }
        double[][] fieldTransposed = new double[rows.size()][];
        int i = 0;
        while (i < rows.size()) {
            fieldTransposed[i] = (double[])rows.get(i);
            ++i;
        }
        double[][] field = new double[width][fieldTransposed.length];
        int i2 = 0;
        while (i2 < field.length) {
            int j = 0;
            while (j < field[i2].length) {
                field[i2][j] = fieldTransposed[j][i2];
                ++j;
            }
            ++i2;
        }
        return field;
    }

    public static int[][] loadGIFFile(InputStream str, boolean flipY) throws IOException {
        return TableLoader.loadPNGFile(str, flipY);
    }

    public static int[][] loadGIFFile(InputStream str) throws IOException {
        return TableLoader.loadPNGFile(str);
    }

    public static int[][] loadPNGFile(InputStream str, boolean flipY) throws IOException {
        int[][] vals = TableLoader.loadPNGFile(str);
        if (flipY) {
            int i = 0;
            while (i < vals.length) {
                int height = vals[i].length;
                int j = 0;
                while (j < height / 2) {
                    int temp = vals[i][j];
                    vals[i][j] = vals[i][height - j + 1];
                    vals[i][height - j + 1] = temp;
                    ++j;
                }
                ++i;
            }
        }
        return vals;
    }

    public static int[][] loadPNGFile(InputStream str) throws IOException {
        byte[] buffer;
        int len;
        BufferedInputStream stream = new BufferedInputStream(str);
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        int count = 0;
        while ((len = stream.read(buffer = new byte[262144])) > 0) {
            if (len < buffer.length) {
                byte[] buf2 = new byte[len];
                System.arraycopy(buffer, 0, buf2, 0, len);
                buffer = buf2;
            }
            count += len;
            list.add(buffer);
        }
        byte[] data = new byte[count];
        int cur = 0;
        int i = 0;
        while (i < list.size()) {
            byte[] b = (byte[])list.get(i);
            System.arraycopy(b, 0, data, cur, b.length);
            cur += b.length;
            ++i;
        }
        BufferedImage image = ((ToolkitImage)new ImageIcon(data).getImage()).getBufferedImage();
        int type = image.getType();
        if (type == 12 || type == 10) {
            int w = image.getWidth();
            int h = image.getHeight();
            int[][] result = new int[w][h];
            int i2 = 0;
            while (i2 < w) {
                int j = 0;
                while (j < h) {
                    result[i2][j] = image.getRGB(i2, j) & 0xFF;
                    ++j;
                }
                ++i2;
            }
            return result;
        }
        if (type == 13) {
            WritableRaster raster = image.getRaster();
            if (raster.getTransferType() != 0) {
                throw new IOException("Input Stream must contain an image with byte data if indexed.");
            }
            byte[] pixel = new byte[1];
            int w = image.getWidth();
            int h = image.getHeight();
            int[][] result = new int[w][h];
            int i3 = 0;
            while (i3 < w) {
                int j = 0;
                while (j < h) {
                    result[i3][j] = ((byte[])raster.getDataElements(i3, j, pixel))[0];
                    if (result[i3][j] < 0) {
                        int[] nArray = result[i3];
                        int n = j;
                        nArray[n] = nArray[n] + 256;
                    }
                    ++j;
                }
                ++i3;
            }
            return result;
        }
        throw new IOException("Input Stream must contain a binary, byte-sized grayscale, or byte-sized indexed color scheme: " + image);
    }

    public static int[][] convertToIntArray(double[][] vals) {
        int[][] ret = new int[vals.length][];
        int i = 0;
        while (i < vals.length) {
            double[] valsi = vals[i];
            ret[i] = new int[valsi.length];
            int[] reti = ret[i];
            int j = 0;
            while (j < valsi.length) {
                int a = (int)valsi[j];
                if ((double)a != valsi[j]) {
                    return null;
                }
                reti[j] = a;
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static double[][] convertToDoubleArray(int[][] vals) {
        double[][] ret = new double[vals.length][];
        int i = 0;
        while (i < vals.length) {
            int[] valsi = vals[i];
            ret[i] = new double[valsi.length];
            double[] reti = ret[i];
            int j = 0;
            while (j < valsi.length) {
                reti[j] = valsi[j];
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static long[][] convertToLongArray(double[][] vals) {
        long[][] ret = new long[vals.length][];
        int i = 0;
        while (i < vals.length) {
            double[] valsi = vals[i];
            ret[i] = new long[valsi.length];
            long[] reti = ret[i];
            int j = 0;
            while (j < valsi.length) {
                long a = (long)valsi[j];
                if ((double)a != valsi[j]) {
                    return null;
                }
                reti[j] = a;
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static long[][] convertToLongArray(int[][] vals) {
        long[][] ret = new long[vals.length][];
        int i = 0;
        while (i < vals.length) {
            int[] valsi = vals[i];
            ret[i] = new long[valsi.length];
            long[] reti = ret[i];
            int j = 0;
            while (j < valsi.length) {
                reti[j] = valsi[j];
                ++j;
            }
            ++i;
        }
        return ret;
    }
}

