/*
 * Decompiled with CFR 0.152.
 */
package sim.util;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.Serializable;
import sim.util.Double2D;
import sim.util.MutableDouble2D;
import sim.util.MutableInt2D;

public final class Int2D
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final int x;
    public final int y;

    public Int2D() {
        this.x = 0;
        this.y = 0;
    }

    public Int2D(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Int2D(MutableInt2D p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Int2D(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public Point2D.Double toPoint2D() {
        return new Point2D.Double(this.x, this.y);
    }

    public Point toPoint() {
        return new Point(this.x, this.y);
    }

    public String toString() {
        return "Int2D[" + this.x + "," + this.y + "]";
    }

    public String toCoordinates() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public final int hashCode() {
        int y = this.y;
        y += ~(y << 15);
        y ^= y >>> 10;
        y += y << 3;
        y ^= y >>> 6;
        y += ~(y << 11);
        y ^= y >>> 16;
        return this.x ^ y;
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Int2D) {
            Int2D other = (Int2D)obj;
            return other.x == this.x && other.y == this.y;
        }
        if (obj instanceof MutableInt2D) {
            MutableInt2D other = (MutableInt2D)obj;
            return other.x == this.x && other.y == this.y;
        }
        if (obj instanceof Double2D) {
            Double2D other = (Double2D)obj;
            return other.x == (double)this.x && other.y == (double)this.y;
        }
        if (obj instanceof MutableDouble2D) {
            MutableDouble2D other = (MutableDouble2D)obj;
            return other.x == (double)this.x && other.y == (double)this.y;
        }
        return false;
    }

    public double distance(double x, double y) {
        double dx = (double)this.x - x;
        double dy = (double)this.y - y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distance(Double2D p) {
        double dx = (double)this.x - p.x;
        double dy = (double)this.y - p.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distance(MutableInt2D p) {
        double dx = (double)this.x - (double)p.x;
        double dy = (double)this.y - (double)p.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distance(Int2D p) {
        double dx = (double)this.x - (double)p.x;
        double dy = (double)this.y - (double)p.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distance(Point2D p) {
        double dx = (double)this.x - p.getX();
        double dy = (double)this.y - p.getY();
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distanceSq(double x, double y) {
        double dx = (double)this.x - x;
        double dy = (double)this.y - y;
        return dx * dx + dy * dy;
    }

    public double distanceSq(Double2D p) {
        double dx = (double)this.x - p.x;
        double dy = (double)this.y - p.y;
        return dx * dx + dy * dy;
    }

    public double distanceSq(Point2D p) {
        double dx = (double)this.x - p.getX();
        double dy = (double)this.y - p.getY();
        return dx * dx + dy * dy;
    }

    public double distanceSq(MutableInt2D p) {
        double dx = (double)this.x - (double)p.x;
        double dy = (double)this.y - (double)p.y;
        return dx * dx + dy * dy;
    }

    public double distanceSq(Int2D p) {
        double dx = (double)this.x - (double)p.x;
        double dy = (double)this.y - (double)p.y;
        return dx * dx + dy * dy;
    }

    public long manhattanDistance(int x, int y) {
        return Math.abs((long)this.x - (long)x) + Math.abs((long)this.y - (long)y);
    }

    public long manhattanDistance(MutableInt2D p) {
        return Math.abs((long)this.x - (long)p.x) + Math.abs((long)this.y - (long)p.y);
    }

    public long manhattanDistance(Int2D p) {
        return Math.abs((long)this.x - (long)p.x) + Math.abs((long)this.y - (long)p.y);
    }

    public long manhattanDistance(Point p) {
        return Math.abs((long)this.x - (long)p.x) + Math.abs((long)this.y - (long)p.y);
    }
}

