/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.simple;

import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3d;
import sim.display.GUIState;
import sim.display3d.Display3D;
import sim.portrayal.Inspector;
import sim.portrayal.LocationWrapper;
import sim.portrayal3d.FieldPortrayal3D;
import sim.portrayal3d.SimplePortrayal3D;

public class TransformedPortrayal3D
extends SimplePortrayal3D {
    SimplePortrayal3D child;
    Transform3D internalTransform;
    boolean updateInternalTransform = false;

    public TransformedPortrayal3D(SimplePortrayal3D child, Transform3D transform) {
        this.child = child;
        this.setTransform(transform);
    }

    public TransformedPortrayal3D(SimplePortrayal3D child) {
        this(child, null);
    }

    @Override
    public PolygonAttributes polygonAttributes() {
        return this.child.polygonAttributes();
    }

    @Override
    public Inspector getInspector(LocationWrapper wrapper, GUIState state) {
        return this.child.getInspector(wrapper, state);
    }

    @Override
    public String getName(LocationWrapper wrapper) {
        return this.child.getName(wrapper);
    }

    @Override
    public void setCurrentDisplay(Display3D display) {
        super.setCurrentDisplay(display);
        this.child.setCurrentDisplay(display);
    }

    @Override
    public void setCurrentFieldPortrayal(FieldPortrayal3D p) {
        super.setCurrentFieldPortrayal(p);
        this.child.setCurrentFieldPortrayal(p);
    }

    @Override
    public boolean setSelected(LocationWrapper wrapper, boolean selected) {
        return this.child.setSelected(wrapper, selected);
    }

    public SimplePortrayal3D getChild(Object object) {
        if (this.child != null) {
            return this.child;
        }
        if (!(object instanceof SimplePortrayal3D)) {
            throw new RuntimeException("Object provided to TransformedPortrayal3D is not a SimplePortrayal3D: " + object);
        }
        return (SimplePortrayal3D)object;
    }

    @Override
    public TransformGroup getModel(Object obj, TransformGroup previousTransformGroup) {
        TransformGroup internalTransformGroup;
        if (previousTransformGroup == null) {
            internalTransformGroup = this.getChild(obj).getModel(obj, null);
            internalTransformGroup.setCapability(18);
            internalTransformGroup.setCapability(12);
            internalTransformGroup.setCapability(13);
            internalTransformGroup.clearCapabilityIsFrequent(12);
            internalTransformGroup.clearCapabilityIsFrequent(13);
            this.updateInternalTransform = true;
            previousTransformGroup = new TransformGroup();
            previousTransformGroup.setCapability(12);
            previousTransformGroup.clearCapabilityIsFrequent(12);
            previousTransformGroup.addChild((Node)internalTransformGroup);
        } else {
            internalTransformGroup = (TransformGroup)previousTransformGroup.getChild(0);
            this.getChild(obj).getModel(obj, internalTransformGroup);
        }
        if (this.updateInternalTransform) {
            internalTransformGroup.setTransform(this.internalTransform);
        }
        return previousTransformGroup;
    }

    public void setTransform(Transform3D transform) {
        this.internalTransform = transform == null ? this.getDefaultTransform() : new Transform3D(transform);
        this.updateInternalTransform = true;
    }

    public Transform3D getDefaultTransform() {
        return new Transform3D();
    }

    public Transform3D getTransform() {
        return new Transform3D(this.internalTransform);
    }

    public void transform(Transform3D transform) {
        Transform3D current = this.getTransform();
        current.mul(transform, current);
        this.setTransform(current);
    }

    public void resetTransform() {
        this.setTransform(this.getDefaultTransform());
    }

    public void rotateX(double degrees) {
        Transform3D other = new Transform3D();
        other.rotX(degrees * Math.PI / 180.0);
        this.transform(other);
    }

    public void rotateY(double degrees) {
        Transform3D other = new Transform3D();
        other.rotY(degrees * Math.PI / 180.0);
        this.transform(other);
    }

    public void rotateZ(double degrees) {
        Transform3D other = new Transform3D();
        other.rotZ(degrees * Math.PI / 180.0);
        this.transform(other);
    }

    public void translate(double dx, double dy, double dz) {
        Transform3D other = new Transform3D();
        other.setTranslation(new Vector3d(dx, dy, dz));
        this.transform(other);
    }

    public void scale(double value) {
        Transform3D other = new Transform3D();
        other.setScale(value);
        this.transform(other);
    }

    public void scale(double sx, double sy, double sz) {
        Transform3D other = new Transform3D();
        other.setScale(new Vector3d(sx, sy, sz));
        this.transform(other);
    }
}

