/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.simple;

import java.awt.Color;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Light;
import javax.media.j3d.Node;
import javax.media.j3d.PointLight;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import sim.portrayal3d.SimplePortrayal3D;
import sim.util.Double3D;

public class LightPortrayal3D
extends SimplePortrayal3D {
    Light light;

    Vector3f double3DToVector3f(Double3D d) {
        Vector3f v = new Vector3f();
        v.x = (float)d.x;
        v.y = (float)d.y;
        v.z = (float)d.z;
        return v;
    }

    public LightPortrayal3D(Color color, Double3D direction) {
        this.light = new DirectionalLight(new Color3f(color), this.double3DToVector3f(direction));
        this.light.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.POSITIVE_INFINITY));
    }

    public LightPortrayal3D(Color color) {
        this.light = new AmbientLight(new Color3f(color));
        this.light.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.POSITIVE_INFINITY));
    }

    public LightPortrayal3D(Color color, Double3D position, float constantAttenuation, float linearAttenuation, float quadraticAttenuation) {
        PointLight p = new PointLight();
        p.setAttenuation(constantAttenuation, linearAttenuation, quadraticAttenuation);
        p.setPosition((float)position.x, (float)position.y, (float)position.z);
        this.light = p;
        this.light.setColor(new Color3f(color));
        this.light.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.POSITIVE_INFINITY));
    }

    public LightPortrayal3D(Light light) {
        this.light = light;
    }

    @Override
    public TransformGroup getModel(Object obj, TransformGroup j3dModel) {
        if (j3dModel == null) {
            j3dModel = new TransformGroup();
            j3dModel.setCapability(12);
            Light l = (Light)this.light.cloneTree(false);
            LightPortrayal3D.clearPickableFlags((Node)l);
            j3dModel.addChild((Node)l);
        }
        return j3dModel;
    }
}

