/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.simple;

import com.sun.j3d.loaders.lw3d.Lw3dLoader;
import com.sun.j3d.loaders.objectfile.ObjectFile;
import com.sun.j3d.utils.picking.PickTool;
import java.io.FileNotFoundException;
import java.net.URL;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.CompressedGeometry;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import sim.portrayal.LocationWrapper;
import sim.portrayal3d.simple.PrimitivePortrayal3D;

public class BranchGroupPortrayal3D
extends PrimitivePortrayal3D {
    public static BranchGroup getBranchGroupForResource(Class c, String resourceName) throws IllegalArgumentException, FileNotFoundException {
        return BranchGroupPortrayal3D.getBranchGroupForURL(c.getResource(resourceName));
    }

    public static BranchGroup getBranchGroupForURL(URL url) throws IllegalArgumentException, FileNotFoundException {
        String s = url.getPath().trim();
        if ((s = s.substring(s.length() - 4)).equalsIgnoreCase(".obj")) {
            return new ObjectFile().load(url).getSceneGroup();
        }
        if (s.equalsIgnoreCase(".lws") || s.equalsIgnoreCase(".lwo")) {
            return new Lw3dLoader().load(url).getSceneGroup();
        }
        throw new IllegalArgumentException("Invalid extension to file name in url (" + url + "), MASON requires '.obj' or '.lws' at present time.");
    }

    public static BranchGroup getBranchGroupForFile(String filename) throws IllegalArgumentException, FileNotFoundException {
        String s = filename.trim();
        if ((s = s.substring(s.length() - 4)).equalsIgnoreCase(".obj")) {
            return new ObjectFile().load(filename).getSceneGroup();
        }
        if (s.equalsIgnoreCase(".lws")) {
            return new Lw3dLoader().load(filename).getSceneGroup();
        }
        throw new IllegalArgumentException("Invalid extension to file name (" + filename + "), MASON requires '.obj' or '.lws' at present time.");
    }

    public BranchGroupPortrayal3D(BranchGroup scene) {
        this(scene, 1.0, null);
    }

    public BranchGroupPortrayal3D(BranchGroup scene, double scale) {
        this(scene, scale, null);
    }

    public BranchGroupPortrayal3D(BranchGroup scene, Transform3D transform) {
        this(scene, transform, null);
    }

    public BranchGroupPortrayal3D(BranchGroup scene, Appearance a) {
        this(scene, 1.0, a);
    }

    public BranchGroupPortrayal3D(BranchGroup scene, double scale, Appearance a) {
        this.setScale(null, scale);
        this.traverseForAttributes((Node)scene);
        this.group = scene;
        this.appearance = a;
    }

    public BranchGroupPortrayal3D(BranchGroup scene, Transform3D transform, Appearance a) {
        this.setTransform(null, transform);
        this.traverseForAttributes((Node)scene);
        this.group = scene;
        this.appearance = a;
    }

    void traverseForAttributes(Node n) {
        block4: {
            block2: {
                Geometry g;
                block3: {
                    if (!(n instanceof Shape3D)) break block2;
                    Shape3D s = (Shape3D)n;
                    BranchGroupPortrayal3D.setShape3DFlags(s);
                    BranchGroupPortrayal3D.setPickableFlags(s);
                    PickTool.setCapabilities((Node)s, (int)4100);
                    g = s.getGeometry();
                    if (!(g instanceof CompressedGeometry)) break block3;
                    ((CompressedGeometry)g).setCapability(2);
                    break block4;
                }
                if (!(g instanceof GeometryArray)) break block4;
                ((GeometryArray)g).setCapability(8);
                ((GeometryArray)g).setCapability(17);
                break block4;
            }
            if (n instanceof Group) {
                Group g = (Group)n;
                int i = 0;
                while (i < g.numChildren()) {
                    this.traverseForAttributes(g.getChild(i));
                    ++i;
                }
            }
        }
    }

    void traverseForUserDataAndAppearance(Node n, LocationWrapper wrapper) {
        if (n instanceof Shape3D) {
            Shape3D s = (Shape3D)n;
            s.setUserData((Object)wrapper);
            if (this.appearance != null) {
                s.setAppearance(this.appearance);
            }
        } else if (n instanceof Group) {
            Group g = (Group)n;
            int i = 0;
            while (i < g.numChildren()) {
                this.traverseForUserDataAndAppearance(g.getChild(i), wrapper);
                ++i;
            }
        }
    }

    @Override
    public TransformGroup getModel(Object obj, TransformGroup j3dModel) {
        if (j3dModel == null) {
            j3dModel = new TransformGroup();
            j3dModel.setCapability(12);
            LocationWrapper pickI = new LocationWrapper(obj, null, this.getCurrentFieldPortrayal());
            Node g = this.group.cloneTree(true);
            if (this.transform != null) {
                TransformGroup tg = new TransformGroup();
                tg.setTransform(this.transform);
                tg.setCapability(17);
                tg.setCapability(18);
                tg.setCapability(12);
                tg.addChild(g);
                g = tg;
            }
            j3dModel.addChild(g);
            this.traverseForUserDataAndAppearance((Node)j3dModel, pickI);
        }
        return j3dModel;
    }

    @Override
    protected int numShapes() {
        return 0;
    }
}

