/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.network;

import sim.field.SparseField2D;
import sim.field.SparseField3D;
import sim.field.continuous.Continuous3D;
import sim.field.grid.SparseGrid3D;
import sim.field.network.Network;
import sim.util.Double3D;

public class SpatialNetwork3D {
    Object field;
    Object field2;
    Network network;

    public SpatialNetwork3D(SparseField3D field, Network network) {
        this.field = field;
        if (field == null) {
            throw new RuntimeException("Null SparseField3D.");
        }
        this.network = network;
        if (network == null) {
            throw new RuntimeException("Null Network.");
        }
    }

    public SpatialNetwork3D(SparseField2D grid, Network network) {
        this.field = grid;
        if (this.field == null) {
            throw new RuntimeException("Null SparseField2D.");
        }
        this.network = network;
        if (network == null) {
            throw new RuntimeException("Null Network.");
        }
    }

    public void setAuxiliaryField(SparseField3D f) {
        this.field2 = f;
    }

    public void setAuxiliaryField(SparseField2D f) {
        this.field2 = f;
    }

    public void setAuxillaryField(Continuous3D f) {
        this.setAuxiliaryField(f);
    }

    public void setAuxillaryField(SparseGrid3D f) {
        this.setAuxiliaryField(f);
    }

    public Double3D getObjectLocation(Object node) {
        Double3D loc = this.field instanceof SparseField3D ? ((SparseField3D)this.field).getObjectLocationAsDouble3D(node) : new Double3D(((SparseField2D)this.field).getObjectLocationAsDouble2D(node));
        if (loc == null && this.field2 != null) {
            loc = this.field2 instanceof SparseField3D ? ((SparseField3D)this.field2).getObjectLocationAsDouble3D(node) : new Double3D(((SparseField2D)this.field2).getObjectLocationAsDouble2D(node));
        }
        return loc;
    }

    public Double3D getDimensions() {
        if (this.field instanceof SparseField3D) {
            return ((SparseField3D)this.field).getDimensions();
        }
        return new Double3D(((SparseField2D)this.field).getDimensions());
    }
}

