/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.inspector;

import sim.field.SparseField;
import sim.field.grid.SparseGrid2D;
import sim.field.grid.SparseGrid3D;
import sim.portrayal.inspector.StableLocation;
import sim.util.Int2D;
import sim.util.Int3D;

public class StableInt3D
implements StableLocation {
    public int x = 0;
    public int y = 0;
    public int z = 0;
    public boolean exists = false;
    public SparseField field;
    public Object object;

    @Override
    public String toString() {
        this.update();
        if (!this.exists) {
            return "Gone";
        }
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public StableInt3D(SparseGrid2D field, Object object) {
        this.field = field;
        this.object = object;
    }

    public StableInt3D(SparseGrid3D field, Object object) {
        this.field = field;
        this.object = object;
    }

    void update() {
        Int3D pos = null;
        if (this.field == null) {
            return;
        }
        pos = this.field instanceof SparseGrid2D ? new Int3D(((SparseGrid2D)this.field).getObjectLocation(this.object)) : ((SparseGrid3D)this.field).getObjectLocation(this.object);
        if (pos == null) {
            this.exists = false;
        } else {
            this.x = pos.x;
            this.y = pos.y;
            this.z = pos.z;
            this.exists = true;
        }
    }

    public int getX() {
        this.update();
        return this.x;
    }

    public int getY() {
        this.update();
        return this.y;
    }

    public int getZ() {
        this.update();
        return this.z;
    }

    public boolean getExists() {
        this.update();
        return this.exists;
    }

    public void setX(int val) {
        if (this.field == null) {
            return;
        }
        if (this.field instanceof SparseGrid2D) {
            ((SparseGrid2D)this.field).setObjectLocation(this.object, new Int2D(val, this.getY()));
            this.z = 0;
        } else {
            ((SparseGrid3D)this.field).setObjectLocation(this.object, new Int3D(val, this.getY(), this.getZ()));
        }
        this.x = val;
        this.exists = true;
    }

    public void setY(int val) {
        if (this.field == null) {
            return;
        }
        if (this.field instanceof SparseGrid2D) {
            ((SparseGrid2D)this.field).setObjectLocation(this.object, new Int2D(this.getX(), val));
            this.z = 0;
        } else {
            ((SparseGrid3D)this.field).setObjectLocation(this.object, new Int3D(this.getX(), val, this.getZ()));
        }
        this.y = val;
        this.exists = true;
    }

    public void setZ(int val) {
        if (this.field == null) {
            return;
        }
        if (this.field instanceof SparseGrid2D) {
            this.z = 0;
            return;
        }
        ((SparseGrid3D)this.field).setObjectLocation(this.object, new Int3D(this.getX(), this.getY(), val));
        this.z = val;
        this.exists = true;
    }
}

