/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.grid;

import com.sun.j3d.utils.picking.PickIntersection;
import com.sun.j3d.utils.picking.PickResult;
import java.util.HashMap;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3d;
import sim.field.grid.ObjectGrid2D;
import sim.field.grid.ObjectGrid3D;
import sim.portrayal.LocationWrapper;
import sim.portrayal.Portrayal;
import sim.portrayal.grid.ObjectGridPortrayal2D;
import sim.portrayal3d.FieldPortrayal3D;
import sim.portrayal3d.SimplePortrayal3D;
import sim.util.Bag;
import sim.util.Int2D;
import sim.util.Int3D;
import sim.util.IntBag;

public class ObjectGridPortrayal3D
extends FieldPortrayal3D {
    final int SEARCH_DISTANCE = 2;
    final int bagsize = 125;
    IntBag xPos = new IntBag(125);
    IntBag yPos = new IntBag(125);
    IntBag zPos = new IntBag(125);
    final ObjectGridPortrayal2D.Message unknown = new ObjectGridPortrayal2D.Message("It's too costly to figure out where the object went.");

    @Override
    protected TransformGroup createModel() {
        TransformGroup globalTG = new TransformGroup();
        globalTG.setCapability(12);
        Group global = new Group();
        global.setCapability(12);
        global.setCapability(13);
        global.setCapability(14);
        global.setUserData((Object)this);
        global.setCapability(1);
        globalTG.addChild((Node)global);
        if (this.field == null) {
            return globalTG;
        }
        Transform3D tmpLocalT = new Transform3D();
        if (this.field instanceof ObjectGrid2D) {
            Object[][] grid = ((ObjectGrid2D)this.field).field;
            int x = 0;
            while (x < grid.length) {
                Object[] gridx = grid[x];
                int y = 0;
                while (y < gridx.length) {
                    Object o = gridx[y];
                    Portrayal p = this.getPortrayalForObject(o);
                    if (!(p instanceof SimplePortrayal3D)) {
                        throw new RuntimeException("Unexpected Portrayal " + p + " for object " + o + " -- expecting a SimplePortrayal3D");
                    }
                    SimplePortrayal3D p3d = (SimplePortrayal3D)p;
                    p3d.setCurrentFieldPortrayal(this);
                    TransformGroup newTransformGroup = p3d.getModel(o, null);
                    newTransformGroup.setCapability(12);
                    newTransformGroup.setCapability(18);
                    newTransformGroup.setCapability(17);
                    newTransformGroup.setCapability(1);
                    tmpLocalT.setTranslation(new Vector3d((double)x, (double)y, 0.0));
                    newTransformGroup.setTransform(tmpLocalT);
                    newTransformGroup.setUserData((Object)new Int2D(x, y));
                    BranchGroup bg = new BranchGroup();
                    bg.setCapability(12);
                    bg.setCapability(17);
                    bg.setCapability(1);
                    bg.addChild((Node)newTransformGroup);
                    bg.setUserData(o);
                    global.addChild((Node)bg);
                    ++y;
                }
                ++x;
            }
        } else {
            Object[][][] grid = ((ObjectGrid3D)this.field).field;
            int x = 0;
            while (x < grid.length) {
                Object[][] gridx = grid[x];
                int y = 0;
                while (y < gridx.length) {
                    Object[] gridy = gridx[y];
                    int z = 0;
                    while (z < gridy.length) {
                        Object o = gridy[z];
                        Portrayal p = this.getPortrayalForObject(o);
                        if (!(p instanceof SimplePortrayal3D)) {
                            throw new RuntimeException("Unexpected Portrayal " + p + " for object " + o + " -- expecting a SimplePortrayal3D");
                        }
                        SimplePortrayal3D p3d = (SimplePortrayal3D)p;
                        p3d.setCurrentFieldPortrayal(this);
                        TransformGroup newTransformGroup = p3d.getModel(o, null);
                        newTransformGroup.setCapability(12);
                        newTransformGroup.setCapability(18);
                        newTransformGroup.setCapability(17);
                        newTransformGroup.setCapability(1);
                        tmpLocalT.setTranslation(new Vector3d((double)x, (double)y, (double)z));
                        newTransformGroup.setUserData((Object)new Int3D(x, y, z));
                        newTransformGroup.setTransform(tmpLocalT);
                        BranchGroup bg = new BranchGroup();
                        bg.setCapability(12);
                        bg.setCapability(17);
                        bg.setCapability(1);
                        bg.addChild((Node)newTransformGroup);
                        bg.setUserData(o);
                        global.addChild((Node)bg);
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
        return globalTG;
    }

    @Override
    protected void updateModel(TransformGroup globalTG) {
        Group global = (Group)globalTG.getChild(0);
        if (this.field == null) {
            return;
        }
        int count = 0;
        HashMap<Object, Bag> models = new HashMap<Object, Bag>();
        Transform3D tmpLocalT = new Transform3D();
        count = 0;
        if (this.field instanceof ObjectGrid2D) {
            Object[][] grid = ((ObjectGrid2D)this.field).field;
            int x = 0;
            while (x < grid.length) {
                Object[] gridx = grid[x];
                int y = 0;
                while (y < gridx.length) {
                    Object o = gridx[y];
                    Portrayal p = this.getPortrayalForObject(o);
                    if (!(p instanceof SimplePortrayal3D)) {
                        throw new RuntimeException("Unexpected Portrayal " + p + " for object " + o + " -- expecting a SimplePortrayal3D");
                    }
                    SimplePortrayal3D p3d = (SimplePortrayal3D)p;
                    p3d.setCurrentFieldPortrayal(this);
                    BranchGroup bg = (BranchGroup)global.getChild(count++);
                    TransformGroup originalTransformGroup = null;
                    if (bg.numChildren() > 0) {
                        originalTransformGroup = (TransformGroup)bg.getChild(0);
                    }
                    TransformGroup newTransformGroup = null;
                    Object originalData = bg.getUserData();
                    if (originalData == o) {
                        newTransformGroup = p3d.getModel(o, originalTransformGroup);
                    } else {
                        Bag b = (Bag)models.get(o);
                        if (b != null && b.numObjs > 0) {
                            BranchGroup replacementBranchGroup = (BranchGroup)b.remove(0);
                            originalTransformGroup = (TransformGroup)replacementBranchGroup.getChild(0);
                            newTransformGroup = p3d.getModel(o, originalTransformGroup);
                            if (newTransformGroup == originalTransformGroup) {
                                global.setChild((Node)replacementBranchGroup, count - 1);
                            }
                        } else {
                            newTransformGroup = p3d.getModel(o, null);
                        }
                    }
                    if (newTransformGroup != originalTransformGroup) {
                        newTransformGroup.setCapability(12);
                        newTransformGroup.setCapability(18);
                        newTransformGroup.setCapability(17);
                        newTransformGroup.setCapability(1);
                        BranchGroup bg2 = new BranchGroup();
                        bg2.setCapability(12);
                        bg2.setCapability(17);
                        bg2.setCapability(1);
                        tmpLocalT.setTranslation(new Vector3d((double)x, (double)y, 0.0));
                        newTransformGroup.setTransform(tmpLocalT);
                        newTransformGroup.setUserData((Object)new Int2D(x, y));
                        bg2.addChild((Node)newTransformGroup);
                        bg2.setUserData(o);
                        global.setChild((Node)bg2, count - 1);
                        Bag b = (Bag)models.get(originalData);
                        if (b == null) {
                            b = new Bag();
                            models.put(originalData, b);
                        }
                        b.add(bg);
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            Object[][][] grid = ((ObjectGrid3D)this.field).field;
            int x = 0;
            while (x < grid.length) {
                Object[][] gridx = grid[x];
                int y = 0;
                while (y < gridx.length) {
                    Object[] gridy = gridx[y];
                    int z = 0;
                    while (z < gridy.length) {
                        Object o = gridy[z];
                        Portrayal p = this.getPortrayalForObject(o);
                        if (!(p instanceof SimplePortrayal3D)) {
                            throw new RuntimeException("Unexpected Portrayal " + p + " for object " + o + " -- expecting a SimplePortrayal3D");
                        }
                        SimplePortrayal3D p3d = (SimplePortrayal3D)p;
                        p3d.setCurrentFieldPortrayal(this);
                        BranchGroup bg = (BranchGroup)global.getChild(count++);
                        TransformGroup originalTransformGroup = null;
                        if (bg.numChildren() > 0) {
                            originalTransformGroup = (TransformGroup)bg.getChild(0);
                        }
                        TransformGroup newTransformGroup = null;
                        Object originalData = bg.getUserData();
                        if (originalData == o) {
                            newTransformGroup = p3d.getModel(o, originalTransformGroup);
                        } else {
                            Bag b = (Bag)models.get(o);
                            if (b != null && b.numObjs > 0) {
                                BranchGroup replacementBranchGroup = (BranchGroup)b.remove(0);
                                originalTransformGroup = (TransformGroup)replacementBranchGroup.getChild(0);
                                newTransformGroup = p3d.getModel(o, originalTransformGroup);
                                if (newTransformGroup == originalTransformGroup) {
                                    global.setChild((Node)replacementBranchGroup, count - 1);
                                }
                            } else {
                                newTransformGroup = p3d.getModel(o, null);
                            }
                        }
                        if (newTransformGroup != originalTransformGroup) {
                            newTransformGroup.setCapability(12);
                            newTransformGroup.setCapability(18);
                            newTransformGroup.setCapability(17);
                            newTransformGroup.setCapability(1);
                            BranchGroup bg2 = new BranchGroup();
                            bg2.setCapability(12);
                            bg2.setCapability(17);
                            bg2.setCapability(1);
                            tmpLocalT.setTranslation(new Vector3d((double)x, (double)y, (double)z));
                            newTransformGroup.setTransform(tmpLocalT);
                            newTransformGroup.setUserData((Object)new Int3D(x, y, z));
                            bg2.addChild((Node)newTransformGroup);
                            bg2.setUserData(o);
                            global.setChild((Node)bg2, count - 1);
                            Bag b = (Bag)models.get(originalData);
                            if (b == null) {
                                b = new Bag();
                                models.put(originalData, b);
                            }
                            b.add(bg);
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
    }

    @Override
    public void setField(Object field) {
        if (!(field instanceof ObjectGrid3D) && !(field instanceof ObjectGrid2D)) {
            throw new RuntimeException("Invalid field for ObjectGridPortrayal3D: " + field);
        }
        super.setField(field);
    }

    Int3D searchForObject(Object object, Int3D loc) {
        ObjectGrid3D field = (ObjectGrid3D)this.field;
        Object[][][] grid = field.field;
        if (grid[loc.x][loc.y][loc.z] == object) {
            return new Int3D(loc.x, loc.y, loc.z);
        }
        field.getMooreLocations(loc.x, loc.y, loc.z, 2, 2, true, this.xPos, this.yPos, this.yPos);
        int i = 0;
        while (i < this.xPos.numObjs) {
            if (grid[this.xPos.get(i)][this.yPos.get(i)][this.zPos.get(i)] == object) {
                return new Int3D(this.xPos.get(i), this.yPos.get(i), this.zPos.get(i));
            }
            ++i;
        }
        return null;
    }

    @Override
    public LocationWrapper completedWrapper(LocationWrapper w, PickIntersection pi, PickResult pr) {
        SceneGraphPath path = pr.getSceneGraphPath();
        int len = path.nodeCount();
        boolean found = false;
        int i = 0;
        i = 0;
        while (i < len) {
            Node node = path.getNode(i);
            Object userdata = path.getNode(i).getUserData();
            if (userdata == this && node instanceof Group) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            throw new RuntimeException("Internal error: ObjectGridPortrayal3D.completedWrapper() couldn't find the root transform group.  This shouldn't happen.");
        }
        Object location = path.getNode(i + 2).getUserData();
        final ObjectGrid3D field = (ObjectGrid3D)this.field;
        return new LocationWrapper(w.getObject(), location, this){

            @Override
            public Object getLocation() {
                Int3D loc = (Int3D)super.getLocation();
                if (field.field[loc.x][loc.y][loc.z] == this.getObject()) {
                    return loc;
                }
                Int3D result = ObjectGridPortrayal3D.this.searchForObject(this.object, loc);
                if (result != null) {
                    this.location = result;
                    return result;
                }
                return ObjectGridPortrayal3D.this.unknown;
            }

            @Override
            public String getLocationName() {
                Object loc = this.getLocation();
                if (loc instanceof Int3D) {
                    return ((Int3D)this.location).toCoordinates();
                }
                return "Location Unknown";
            }
        };
    }
}

