/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.inspector;

import java.awt.Frame;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;
import sim.display.GUIState;
import sim.engine.Stoppable;
import sim.portrayal.inspector.ChartingPropertyInspector;
import sim.util.Properties;
import sim.util.Valuable;
import sim.util.media.chart.ChartGenerator;
import sim.util.media.chart.TimeSeriesAttributes;
import sim.util.media.chart.TimeSeriesChartGenerator;
import sim.util.media.chart.XYChartGenerator;

public class TimeSeriesChartingPropertyInspector
extends ChartingPropertyInspector {
    XYSeries chartSeries = null;
    XYSeries aggregateSeries = new XYSeries((Comparable)((Object)"ChartingPropertyInspector.temp"), false);

    @Override
    protected boolean validChartGenerator(ChartGenerator generator) {
        return generator instanceof TimeSeriesChartGenerator;
    }

    public static String name() {
        return "Chart";
    }

    public static Class[] types() {
        return new Class[]{Number.class, Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Valuable.class};
    }

    public TimeSeriesChartingPropertyInspector(Properties properties, int index, Frame parent, GUIState simulation) {
        super(properties, index, parent, simulation);
        this.setupSeriesAttributes(properties, index);
    }

    public TimeSeriesChartingPropertyInspector(Properties properties, int index, GUIState simulation, ChartGenerator generator) {
        super(properties, index, simulation, generator);
        this.setupSeriesAttributes(properties, index);
    }

    private void setupSeriesAttributes(Properties properties, int index) {
        if (this.isValidInspector()) {
            if (this.getGenerator().getNumSeriesAttributes() == 0) {
                this.getGenerator().setTitle(properties.getName(index) + " of " + properties.getObject());
                ((XYChartGenerator)this.getGenerator()).setYAxisLabel(properties.getName(index));
                ((XYChartGenerator)this.getGenerator()).setXAxisLabel("Time");
            }
            this.chartSeries = new XYSeries((Comparable)((Object)properties.getName(index)), false);
            this.seriesAttributes = ((TimeSeriesChartGenerator)this.generator).addSeries(this.chartSeries, new SeriesChangeListener(){

                public void seriesChanged(SeriesChangeEvent event) {
                    TimeSeriesChartingPropertyInspector.this.getStopper().stop();
                }
            });
        }
    }

    @Override
    protected ChartGenerator createNewGenerator() {
        return new TimeSeriesChartGenerator(){

            @Override
            public void quit() {
                super.quit();
                Stoppable stopper = TimeSeriesChartingPropertyInspector.this.getStopper();
                if (stopper != null) {
                    stopper.stop();
                }
                TimeSeriesChartingPropertyInspector.this.getCharts(TimeSeriesChartingPropertyInspector.this.simulation).remove(this);
            }
        };
    }

    protected double valueFor(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof Valuable) {
            return ((Valuable)o).doubleValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1 : 0;
        }
        return Double.NaN;
    }

    void addToMainSeries(double x, double y, boolean notify) {
        this.chartSeries.add(x, y, false);
        TimeSeriesAttributes attributes = (TimeSeriesAttributes)this.seriesAttributes;
        if (!attributes.possiblyCull() && notify) {
            this.chartSeries.fireSeriesChanged();
        }
    }

    @Override
    protected void updateSeries(double time, double lastTime) {
        double d = 0.0;
        ChartingPropertyInspector.GlobalAttributes globalAttributes = this.getGlobalAttributes();
        d = this.valueFor(this.properties.getValue(this.index));
        this.aggregateSeries.add(time, d, false);
        int len = this.aggregateSeries.getItemCount();
        long interval = globalAttributes.interval;
        double intervalMark = time % (double)interval;
        if (intervalMark != 0.0 && !(time - lastTime >= (double)interval) && !(lastTime % (double)interval > intervalMark)) {
            return;
        }
        double y = 0.0;
        switch (globalAttributes.aggregationMethod) {
            case 0: {
                this.addToMainSeries(time, d, false);
                break;
            }
            case 1: {
                double maxX = 0.0;
                int i = 0;
                while (i < len) {
                    XYDataItem item = this.aggregateSeries.getDataItem(i);
                    y = item.getY().doubleValue();
                    double temp = item.getX().doubleValue();
                    if (maxX < temp || i == 0) {
                        maxX = temp;
                    }
                    ++i;
                }
                this.addToMainSeries(maxX, y, false);
                break;
            }
            case 2: {
                double minX = 0.0;
                int i = 0;
                while (i < len) {
                    XYDataItem item = this.aggregateSeries.getDataItem(i);
                    y = item.getY().doubleValue();
                    double temp = item.getX().doubleValue();
                    if (minX > temp || i == 0) {
                        minX = temp;
                    }
                    ++i;
                }
                this.addToMainSeries(minX, y, false);
                break;
            }
            case 3: {
                double sumX = 0.0;
                int n = 0;
                int i = 0;
                while (i < len) {
                    XYDataItem item = this.aggregateSeries.getDataItem(i);
                    y = item.getY().doubleValue();
                    sumX += item.getX().doubleValue();
                    ++n;
                    ++i;
                }
                if (n == 0) break;
                this.addToMainSeries(sumX / (double)n, y, false);
                break;
            }
            default: {
                throw new RuntimeException("No valid aggregation method provided");
            }
        }
        this.aggregateSeries.clear();
    }
}

