/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import sim.display.GUIState;
import sim.engine.Schedule;
import sim.engine.Stoppable;
import sim.portrayal.inspector.PropertyInspector;
import sim.util.Properties;
import sim.util.gui.NumberTextField;
import sim.util.gui.Utilities;

public class StreamingPropertyInspector
extends PropertyInspector {
    PrintWriter out;
    boolean shouldCloseOnStop = true;
    int streamingTo;
    int interval = 1;
    static final int CUSTOM = -1;
    static final int FILE = 0;
    static final int WINDOW = 1;
    static final int STDOUT = 2;
    JTextArea area;
    JScrollPane pane;
    JFrame frame;
    double lastTime = -1.0;

    public static String name() {
        return "Stream";
    }

    public static Class[] types() {
        return null;
    }

    public StreamingPropertyInspector(Properties properties, int index, Frame parent, GUIState simulation, PrintWriter stream, String streamName) {
        super(properties, index, parent, simulation);
        this.out = stream;
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel("Streaming to..."), "North");
        this.add((Component)new JLabel(streamName), "Center");
        this.streamingTo = -1;
        this.setValidInspector(true);
    }

    public StreamingPropertyInspector(final Properties properties, final int index, Frame parent, final GUIState simulation) {
        super(properties, index, parent, simulation);
        Object[] possibilities = new Object[]{"A file (overwriting)", "A file (appending)", "A window", "Standard Out"};
        String s = (String)JOptionPane.showInputDialog(parent, "Stream the property to:", "Stream", -1, null, possibilities, possibilities[0]);
        if (s != null) {
            NumberTextField skipField = new NumberTextField("Skip: ", 1.0, false){

                @Override
                public double newValue(double newValue) {
                    int val = (int)newValue;
                    if (val < 1) {
                        val = (int)this.currentValue;
                    }
                    StreamingPropertyInspector.this.interval = val;
                    return val;
                }
            };
            skipField.setToolTipText("Specify the number of steps between stream fetches");
            skipField.setBorder(BorderFactory.createEmptyBorder(2, 2, 0, 2));
            if (s.equals(possibilities[0]) || s.equals(possibilities[1])) {
                this.streamingTo = 0;
                FileDialog fd = new FileDialog(parent, "Stream the Property " + (s.equals(possibilities[1]) ? "(appending) " : "") + "\"" + properties.getName(index) + "\" to File...", 1);
                fd.setFile(String.valueOf(properties.getName(index)) + ".out");
                fd.setVisible(true);
                if (fd.getFile() != null) {
                    try {
                        File file = new File(fd.getDirectory(), Utilities.ensureFileEndsWith(fd.getFile(), ".out"));
                        this.out = new PrintWriter(new BufferedWriter(new FileWriter(file.getCanonicalPath(), s.equals(possibilities[1]))));
                        this.setLayout(new BorderLayout());
                        Box b = new Box(1);
                        b.add(skipField);
                        b.add(new JLabel("Streaming to" + (s.equals(possibilities[1]) ? " (appending)" : "") + "..."));
                        b.add(new JLabel(file.getPath()));
                        b.add(new JLabel("Format: \"timestamp: value\""));
                        b.add(Box.createGlue());
                        this.add((Component)b, "North");
                        this.setValidInspector(true);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else if (s.equals(possibilities[2])) {
                this.streamingTo = 1;
                this.area = new JTextArea();
                this.pane = new JScrollPane(this.area);
                this.setLayout(new BorderLayout());
                this.add((Component)this.pane, "Center");
                this.add((Component)skipField, "North");
                Box box = new Box(0);
                JButton saveButton = new JButton("Save Contents");
                box.add(saveButton);
                saveButton.addActionListener(new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Schedule schedule = simulation.state.schedule;
                        synchronized (schedule) {
                            FileDialog fd = new FileDialog((Frame)StreamingPropertyInspector.this.frame, "Save the (Present) Contents to File...", 1);
                            fd.setFile(String.valueOf(properties.getName(index)) + ".out");
                            fd.setVisible(true);
                            if (fd.getFile() != null) {
                                try {
                                    File file = new File(fd.getDirectory(), Utilities.ensureFileEndsWith(fd.getFile(), ".out"));
                                    PrintWriter p = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                                    p.println(StreamingPropertyInspector.this.area.getText());
                                    p.close();
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }
                    }
                });
                box.add(new JLabel("Format: \"timestamp: value\""));
                box.add(Box.createGlue());
                this.add((Component)box, "South");
                this.setValidInspector(true);
            } else {
                this.streamingTo = 2;
                this.shouldCloseOnStop = false;
                this.setLayout(new BorderLayout());
                Box b = new Box(1);
                b.add(skipField);
                b.add((Component)new JLabel("Streaming to Standard Out"), "Center");
                b.add(new JLabel("Format: \"timestamp/object/property: value\""));
                b.add(Box.createGlue());
                this.add((Component)b, "North");
                this.setValidInspector(true);
            }
        }
    }

    @Override
    public void updateInspector() {
        double time = this.simulation.state.schedule.getTime();
        if (time >= 0.0 && time < Double.POSITIVE_INFINITY && this.lastTime <= time - (double)this.interval) {
            this.lastTime = time;
            switch (this.streamingTo) {
                case -1: 
                case 0: {
                    if (this.out == null) break;
                    this.out.println(String.valueOf(time) + ": " + this.properties.getValue(this.index));
                    break;
                }
                case 1: {
                    this.area.append(String.valueOf(time) + ": " + this.properties.getValue(this.index) + "\n");
                    break;
                }
                case 2: {
                    System.out.println(this.properties.getObject() + "/" + this.properties.getName(this.index) + "/" + time + ": " + this.properties.getValue(this.index));
                }
            }
        }
    }

    @Override
    public Stoppable reviseStopper(Stoppable stopper) {
        final Stoppable newStopper = super.reviseStopper(stopper);
        return new Stoppable(){

            @Override
            public void stop() {
                if (newStopper != null) {
                    newStopper.stop();
                }
                if (StreamingPropertyInspector.this.out != null) {
                    if (StreamingPropertyInspector.this.streamingTo == 2) {
                        StreamingPropertyInspector.this.out.flush();
                    } else if (StreamingPropertyInspector.this.streamingTo == 0 || StreamingPropertyInspector.this.streamingTo == -1) {
                        StreamingPropertyInspector.this.out.close();
                    }
                }
                StreamingPropertyInspector.this.out = null;
            }
        };
    }

    @Override
    public JFrame createFrame(Stoppable stopper) {
        this.frame = super.createFrame(stopper);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().removeAll();
        this.frame.getContentPane().add((Component)this, "Center");
        if (this.pane != null) {
            this.frame.setSize(400, 300);
        } else {
            this.frame.pack();
        }
        return this.frame;
    }
}

