/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.inspector;

import java.awt.Frame;
import java.io.Serializable;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.general.SeriesChangeListener;
import sim.display.GUIState;
import sim.engine.Stoppable;
import sim.portrayal.inspector.ChartingPropertyInspector;
import sim.util.Double2D;
import sim.util.Int2D;
import sim.util.Properties;
import sim.util.media.chart.ChartGenerator;
import sim.util.media.chart.ScatterPlotGenerator;
import sim.util.media.chart.XYChartGenerator;

public class ScatterPlotChartingPropertyInspector
extends ChartingPropertyInspector {
    double[][] previousValues = new double[2][0];

    @Override
    protected boolean validChartGenerator(ChartGenerator generator) {
        return generator instanceof ScatterPlotGenerator;
    }

    @Override
    protected boolean includeAggregationMethodAttributes() {
        return false;
    }

    public static String name() {
        return "Make Scatter Plot";
    }

    public static Class[] types() {
        return new Class[]{new Double2D[0].getClass(), new Int2D[0].getClass()};
    }

    public ScatterPlotChartingPropertyInspector(Properties properties, int index, Frame parent, GUIState simulation) {
        super(properties, index, parent, simulation);
        this.setupSeriesAttributes(properties, index);
    }

    public ScatterPlotChartingPropertyInspector(Properties properties, int index, GUIState simulation, ChartGenerator generator) {
        super(properties, index, simulation, generator);
        this.setupSeriesAttributes(properties, index);
    }

    private void setupSeriesAttributes(Properties properties, int index) {
        if (this.isValidInspector()) {
            if (this.getGenerator().getNumSeriesAttributes() == 0) {
                this.getGenerator().setTitle(properties.getName(index) + " of " + properties.getObject());
                ((XYChartGenerator)this.getGenerator()).setYAxisLabel("Y " + properties.getName(index));
                ((XYChartGenerator)this.getGenerator()).setXAxisLabel("X " + properties.getName(index));
            }
            this.seriesAttributes = ((ScatterPlotGenerator)this.generator).addSeries(this.previousValues, properties.getName(index), new SeriesChangeListener(){

                public void seriesChanged(SeriesChangeEvent event) {
                    ScatterPlotChartingPropertyInspector.this.getStopper().stop();
                }
            });
        }
    }

    @Override
    protected ChartGenerator createNewGenerator() {
        return new ScatterPlotGenerator(){

            @Override
            public void quit() {
                super.quit();
                Stoppable stopper = ScatterPlotChartingPropertyInspector.this.getStopper();
                if (stopper != null) {
                    stopper.stop();
                }
                ScatterPlotChartingPropertyInspector.this.getCharts(ScatterPlotChartingPropertyInspector.this.simulation).remove(this);
            }
        };
    }

    @Override
    public void updateSeries(double time, double lastTime) {
        Object obj = this.properties.getValue(this.index);
        if (obj == null) {
            return;
        }
        Class<?> cls = obj.getClass();
        double[][] vals = this.previousValues;
        if (cls.isArray()) {
            int i;
            Serializable[] array;
            Class<?> comp = cls.getComponentType();
            if (comp.equals(Double2D.class)) {
                array = (Double2D[])obj;
                vals = new double[2][array.length];
                i = 0;
                while (i < array.length) {
                    vals[0][i] = ((Double2D)array[i]).x;
                    vals[1][i] = ((Double2D)array[i]).y;
                    ++i;
                }
            } else if (comp.equals(Int2D.class)) {
                array = (Int2D[])obj;
                vals = new double[2][array.length];
                i = 0;
                while (i < array.length) {
                    vals[0][i] = ((Int2D)array[i]).x;
                    vals[1][i] = ((Int2D)array[i]).y;
                    ++i;
                }
            }
        }
        boolean same = true;
        if (this.previousValues != null && vals.length == this.previousValues.length) {
            int i = 0;
            while (i < vals.length) {
                if (vals[i] != this.previousValues[i]) {
                    same = false;
                    break;
                }
                ++i;
            }
        } else {
            same = false;
        }
        if (same) {
            return;
        }
        this.previousValues = vals;
        ((ScatterPlotGenerator)this.generator).updateSeries(this.seriesAttributes.getSeriesIndex(), vals);
    }
}

