/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.inspector;

import java.awt.Frame;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.general.SeriesChangeListener;
import sim.display.GUIState;
import sim.engine.Stoppable;
import sim.portrayal.inspector.ChartingPropertyInspector;
import sim.util.DoubleBag;
import sim.util.Indexed;
import sim.util.IntBag;
import sim.util.Properties;
import sim.util.Valuable;
import sim.util.media.chart.ChartGenerator;
import sim.util.media.chart.HistogramGenerator;
import sim.util.media.chart.XYChartGenerator;

public class HistogramChartingPropertyInspector
extends ChartingPropertyInspector {
    public static final int DEFAULT_BINS = 8;
    double[] previousValues = new double[]{0.0};

    @Override
    protected boolean validChartGenerator(ChartGenerator generator) {
        return generator instanceof HistogramGenerator;
    }

    @Override
    protected boolean includeAggregationMethodAttributes() {
        return false;
    }

    public static String name() {
        return "Make Histogram";
    }

    public static Class[] types() {
        return new Class[]{new byte[0].getClass(), new short[0].getClass(), new int[0].getClass(), new long[0].getClass(), new float[0].getClass(), new double[0].getClass(), new boolean[0].getClass(), new Valuable[0].getClass(), new Number[0].getClass(), IntBag.class, DoubleBag.class};
    }

    public HistogramChartingPropertyInspector(Properties properties, int index, Frame parent, GUIState simulation) {
        super(properties, index, parent, simulation);
        this.setupSeriesAttributes(properties, index);
    }

    public HistogramChartingPropertyInspector(Properties properties, int index, GUIState simulation, ChartGenerator generator) {
        super(properties, index, simulation, generator);
        this.setupSeriesAttributes(properties, index);
    }

    private void setupSeriesAttributes(Properties properties, int index) {
        if (this.isValidInspector()) {
            if (this.getGenerator().getNumSeriesAttributes() == 0) {
                this.getGenerator().setTitle(properties.getName(index) + " of " + properties.getObject());
                ((XYChartGenerator)this.getGenerator()).setYAxisLabel("Frequency");
                ((XYChartGenerator)this.getGenerator()).setXAxisLabel(properties.getName(index));
            }
            this.seriesAttributes = ((HistogramGenerator)this.generator).addSeries(this.previousValues, 8, properties.getName(index), new SeriesChangeListener(){

                public void seriesChanged(SeriesChangeEvent event) {
                    HistogramChartingPropertyInspector.this.getStopper().stop();
                }
            });
        }
    }

    @Override
    protected ChartGenerator createNewGenerator() {
        return new HistogramGenerator(){

            @Override
            public void quit() {
                super.quit();
                Stoppable stopper = HistogramChartingPropertyInspector.this.getStopper();
                if (stopper != null) {
                    stopper.stop();
                }
                HistogramChartingPropertyInspector.this.getCharts(HistogramChartingPropertyInspector.this.simulation).remove(this);
            }
        };
    }

    @Override
    public void updateSeries(double time, double lastTime) {
        Indexed bag;
        Object obj = this.properties.getValue(this.index);
        if (obj == null) {
            return;
        }
        Class<?> cls = obj.getClass();
        double[] vals = this.previousValues;
        if (cls.isArray()) {
            int i;
            Class<?> comp = cls.getComponentType();
            if (comp.equals(Byte.TYPE)) {
                byte[] array = (byte[])obj;
                vals = new double[array.length];
                i = 0;
                while (i < array.length) {
                    vals[i] = array[i];
                    ++i;
                }
            } else if (comp.equals(Short.TYPE)) {
                short[] array = (short[])obj;
                vals = new double[array.length];
                i = 0;
                while (i < array.length) {
                    vals[i] = array[i];
                    ++i;
                }
            } else if (comp.equals(Integer.TYPE)) {
                int[] array = (int[])obj;
                vals = new double[array.length];
                i = 0;
                while (i < array.length) {
                    vals[i] = array[i];
                    ++i;
                }
            } else if (comp.equals(Long.TYPE)) {
                long[] array = (long[])obj;
                vals = new double[array.length];
                i = 0;
                while (i < array.length) {
                    vals[i] = array[i];
                    ++i;
                }
            } else if (comp.equals(Float.TYPE)) {
                float[] array = (float[])obj;
                vals = new double[array.length];
                i = 0;
                while (i < array.length) {
                    vals[i] = array[i];
                    ++i;
                }
            } else if (comp.equals(Double.TYPE)) {
                double[] array = (double[])obj;
                vals = new double[array.length];
                i = 0;
                while (i < array.length) {
                    vals[i] = array[i];
                    ++i;
                }
            } else if (comp.equals(Boolean.TYPE)) {
                boolean[] array = (boolean[])obj;
                vals = new double[array.length];
                i = 0;
                while (i < array.length) {
                    vals[i] = array[i] ? 1 : 0;
                    ++i;
                }
            } else if (comp.equals(Valuable.class)) {
                Valuable[] array = (Valuable[])obj;
                vals = new double[array.length];
                i = 0;
                while (i < array.length) {
                    vals[i] = array[i].doubleValue();
                    ++i;
                }
            } else if (comp.equals(Number.class)) {
                Number[] array = (Number[])obj;
                vals = new double[array.length];
                i = 0;
                while (i < array.length) {
                    vals[i] = array[i].doubleValue();
                    ++i;
                }
            }
        } else if (obj instanceof IntBag) {
            bag = (IntBag)obj;
            vals = new double[bag.numObjs];
            int i = 0;
            while (i < bag.numObjs) {
                vals[i] = bag.objs[i];
                ++i;
            }
        } else if (obj instanceof DoubleBag) {
            bag = (DoubleBag)obj;
            vals = new double[((DoubleBag)bag).numObjs];
            int i = 0;
            while (i < ((DoubleBag)bag).numObjs) {
                vals[i] = ((DoubleBag)bag).objs[i];
                ++i;
            }
        }
        boolean same = true;
        if (this.previousValues != null && vals.length == this.previousValues.length) {
            int i = 0;
            while (i < vals.length) {
                if (vals[i] != this.previousValues[i]) {
                    same = false;
                    break;
                }
                ++i;
            }
        } else {
            same = false;
        }
        if (same) {
            return;
        }
        this.previousValues = vals;
        ((HistogramGenerator)this.generator).updateSeries(this.seriesAttributes.getSeriesIndex(), vals);
    }
}

