/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.grid;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import sim.display.GUIState;
import sim.engine.Schedule;
import sim.field.grid.Grid2D;
import sim.field.grid.SparseGrid2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.FieldPortrayal2D;
import sim.portrayal.Fixed2D;
import sim.portrayal.LocationWrapper;
import sim.portrayal.Portrayal;
import sim.portrayal.SimplePortrayal2D;
import sim.portrayal.grid.DrawPolicy;
import sim.portrayal.inspector.StableInt2D;
import sim.portrayal.simple.OvalPortrayal2D;
import sim.util.Bag;
import sim.util.Double2D;
import sim.util.Int2D;

public class SparseGridPortrayal2D
extends FieldPortrayal2D {
    public DrawPolicy policy;
    SimplePortrayal2D defaultPortrayal = new OvalPortrayal2D();
    HashMap selectedWrappers = new HashMap();

    public SparseGridPortrayal2D() {
    }

    public SparseGridPortrayal2D(DrawPolicy policy) {
        this.policy = policy;
    }

    public void setDrawPolicy(DrawPolicy policy) {
        this.policy = policy;
    }

    public DrawPolicy getDrawPolicy() {
        return this.policy;
    }

    @Override
    public Portrayal getDefaultPortrayal() {
        return this.defaultPortrayal;
    }

    @Override
    public void setField(Object field) {
        if (!(field instanceof SparseGrid2D)) {
            throw new RuntimeException("Invalid field for Sparse2DPortrayal: " + field);
        }
        super.setField(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double2D getScale(DrawInfo2D info) {
        Schedule schedule = info.gui.state.schedule;
        synchronized (schedule) {
            Grid2D field;
            block4: {
                field = (Grid2D)this.field;
                if (field != null) break block4;
                return null;
            }
            int maxX = field.getWidth();
            int maxY = field.getHeight();
            double xScale = info.draw.width / (double)maxX;
            double yScale = info.draw.height / (double)maxY;
            return new Double2D(xScale, yScale);
        }
    }

    @Override
    public Object getPositionLocation(Point2D.Double position, DrawInfo2D info) {
        Double2D scale = this.getScale(info);
        double xScale = scale.x;
        double yScale = scale.y;
        int startx = (int)Math.floor((position.getX() - info.draw.x) / xScale);
        int starty = (int)Math.floor((position.getY() - info.draw.y) / yScale);
        return new Int2D(startx, starty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObjectPosition(Object object, Point2D.Double position, DrawInfo2D fieldPortrayalInfo) {
        Schedule schedule = fieldPortrayalInfo.gui.state.schedule;
        synchronized (schedule) {
            SparseGrid2D field = (SparseGrid2D)this.field;
            if (field == null) {
                return;
            }
            if (field.getObjectLocation(object) == null) {
                return;
            }
            Int2D location = (Int2D)this.getPositionLocation(position, fieldPortrayalInfo);
            if (location != null) {
                if (object instanceof Fixed2D && !((Fixed2D)object).maySetLocation(field, location)) {
                    return;
                }
                if (location != null) {
                    field.setObjectLocation(object, location);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectLocation(Object object, GUIState gui) {
        Schedule schedule = gui.state.schedule;
        synchronized (schedule) {
            SparseGrid2D field;
            block4: {
                field = (SparseGrid2D)this.field;
                if (field != null) break block4;
                return null;
            }
            return field.getObjectLocation(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point2D.Double getLocationPosition(Object location, DrawInfo2D info) {
        Schedule schedule = info.gui.state.schedule;
        synchronized (schedule) {
            Int2D loc;
            DrawInfo2D newinfo;
            double yScale;
            double xScale;
            block6: {
                Grid2D field;
                block5: {
                    field = (Grid2D)this.field;
                    if (field != null) break block5;
                    return null;
                }
                int maxX = field.getWidth();
                int maxY = field.getHeight();
                xScale = info.draw.width / (double)maxX;
                yScale = info.draw.height / (double)maxY;
                newinfo = new DrawInfo2D(info.gui, info.fieldPortrayal, new Rectangle2D.Double(0.0, 0.0, xScale, yScale), info.clip);
                newinfo.precise = info.precise;
                loc = (Int2D)location;
                if (loc != null) break block6;
                return null;
            }
            newinfo.draw.x = (int)Math.floor(info.draw.x + xScale * (double)loc.x);
            newinfo.draw.y = (int)Math.floor(info.draw.y + yScale * (double)loc.y);
            newinfo.draw.width = (double)((int)Math.floor(info.draw.x + xScale * (double)(loc.x + 1))) - newinfo.draw.x;
            newinfo.draw.height = (double)((int)Math.floor(info.draw.y + yScale * (double)(loc.y + 1))) - newinfo.draw.y;
            newinfo.draw.x += newinfo.draw.width / 2.0;
            newinfo.draw.y += newinfo.draw.height / 2.0;
            return new Point2D.Double(newinfo.draw.x, newinfo.draw.y);
        }
    }

    @Override
    protected void hitOrDraw(Graphics2D graphics, DrawInfo2D info, Bag putInHere) {
        SparseGrid2D field = (SparseGrid2D)this.field;
        if (field == null) {
            return;
        }
        boolean objectSelected = !this.selectedWrappers.isEmpty();
        int maxX = field.getWidth();
        int maxY = field.getHeight();
        double xScale = info.draw.width / (double)maxX;
        double yScale = info.draw.height / (double)maxY;
        int startx = (int)Math.floor((info.clip.x - info.draw.x) / xScale);
        int starty = (int)Math.floor((info.clip.y - info.draw.y) / yScale);
        int endx = (int)Math.floor((info.clip.x - info.draw.x + info.clip.width) / xScale) + 1;
        int endy = (int)Math.floor((info.clip.y - info.draw.y + info.clip.height) / yScale) + 1;
        Rectangle clip = graphics == null ? null : graphics.getClipBounds();
        DrawInfo2D newinfo = new DrawInfo2D(info.gui, info.fieldPortrayal, new Rectangle2D.Double(0.0, 0.0, xScale, yScale), info.clip);
        newinfo.precise = info.precise;
        newinfo.fieldPortrayal = this;
        if (this.policy != null && graphics != null) {
            Bag policyBag = new Bag();
            Iterator iterator = field.locationBagIterator();
            while (iterator.hasNext()) {
                Bag objects = (Bag)iterator.next();
                if (objects == null) continue;
                policyBag.clear();
                if (this.policy.objectToDraw(objects, policyBag)) {
                    objects = policyBag;
                }
                int x = 0;
                while (x < objects.numObjs) {
                    Object portrayedObject = objects.objs[x];
                    Int2D loc = field.getObjectLocation(portrayedObject);
                    if (loc.x >= startx - 2 && loc.x < endx + 4 && loc.y >= starty - 2 && loc.y < endy + 4) {
                        Portrayal p = this.getPortrayalForObject(portrayedObject);
                        if (!(p instanceof SimplePortrayal2D)) {
                            throw new RuntimeException("Unexpected Portrayal " + p + " for object " + portrayedObject + " -- expected a SimplePortrayal2D");
                        }
                        SimplePortrayal2D portrayal = (SimplePortrayal2D)p;
                        newinfo.draw.x = (int)Math.floor(info.draw.x + xScale * (double)loc.x);
                        newinfo.draw.y = (int)Math.floor(info.draw.y + yScale * (double)loc.y);
                        newinfo.draw.width = (double)((int)Math.floor(info.draw.x + xScale * (double)(loc.x + 1))) - newinfo.draw.x;
                        newinfo.draw.height = (double)((int)Math.floor(info.draw.y + yScale * (double)(loc.y + 1))) - newinfo.draw.y;
                        newinfo.draw.x += newinfo.draw.width / 2.0;
                        newinfo.draw.y += newinfo.draw.height / 2.0;
                        newinfo.location = loc;
                        newinfo.selected = objectSelected && this.selectedWrappers.get(portrayedObject) != null;
                        portrayal.draw(portrayedObject, graphics, newinfo);
                    }
                    ++x;
                }
            }
        } else {
            Bag objects = field.getAllObjects();
            int x = 0;
            while (x < objects.numObjs) {
                Object portrayedObject = objects.objs[x];
                Int2D loc = field.getObjectLocation(portrayedObject);
                if (loc.x >= startx - 2 && loc.x < endx + 4 && loc.y >= starty - 2 && loc.y < endy + 4) {
                    Portrayal p = this.getPortrayalForObject(portrayedObject);
                    if (!(p instanceof SimplePortrayal2D)) {
                        throw new RuntimeException("Unexpected Portrayal " + p + " for object " + portrayedObject + " -- expected a SimplePortrayal2D");
                    }
                    SimplePortrayal2D portrayal = (SimplePortrayal2D)p;
                    newinfo.draw.x = (int)Math.floor(info.draw.x + xScale * (double)loc.x);
                    newinfo.draw.y = (int)Math.floor(info.draw.y + yScale * (double)loc.y);
                    newinfo.draw.width = (double)((int)Math.floor(info.draw.x + xScale * (double)(loc.x + 1))) - newinfo.draw.x;
                    newinfo.draw.height = (double)((int)Math.floor(info.draw.y + yScale * (double)(loc.y + 1))) - newinfo.draw.y;
                    newinfo.draw.x += newinfo.draw.width / 2.0;
                    newinfo.draw.y += newinfo.draw.height / 2.0;
                    if (graphics == null) {
                        if (portrayal.hitObject(portrayedObject, newinfo)) {
                            putInHere.add(this.getWrapper(portrayedObject));
                        }
                    } else {
                        newinfo.selected = objectSelected && this.selectedWrappers.get(portrayedObject) != null;
                        portrayal.draw(portrayedObject, graphics, newinfo);
                    }
                }
                ++x;
            }
        }
    }

    public LocationWrapper getWrapper(Object object) {
        SparseGrid2D field = (SparseGrid2D)this.field;
        final StableInt2D w = new StableInt2D(field, object);
        return new LocationWrapper(object, null, this){

            @Override
            public Object getLocation() {
                return w;
            }

            @Override
            public String getLocationName() {
                return w.toString();
            }
        };
    }

    @Override
    public boolean setSelected(LocationWrapper wrapper, boolean selected) {
        if (wrapper == null) {
            return true;
        }
        if (wrapper.getFieldPortrayal() != this) {
            return true;
        }
        Object obj = wrapper.getObject();
        boolean b = this.getPortrayalForObject(obj).setSelected(wrapper, selected);
        if (selected) {
            if (!b) {
                return false;
            }
            this.selectedWrappers.put(obj, wrapper);
        } else {
            this.selectedWrappers.remove(obj);
        }
        return true;
    }
}

