/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.grid;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import sim.display.GUIState;
import sim.engine.Schedule;
import sim.field.grid.Grid2D;
import sim.field.grid.ObjectGrid2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.FieldPortrayal2D;
import sim.portrayal.LocationWrapper;
import sim.portrayal.Portrayal;
import sim.portrayal.SimplePortrayal2D;
import sim.portrayal.simple.OvalPortrayal2D;
import sim.util.Bag;
import sim.util.Double2D;
import sim.util.Int2D;
import sim.util.IntBag;
import sim.util.MutableInt2D;

public class ObjectGridPortrayal2D
extends FieldPortrayal2D {
    SimplePortrayal2D defaultPortrayal = new OvalPortrayal2D();
    SimplePortrayal2D defaultNullPortrayal = new SimplePortrayal2D();
    protected final MutableInt2D locationToPass = new MutableInt2D(0, 0);
    final int SEARCH_DISTANCE = 3;
    IntBag xPos = new IntBag(49);
    IntBag yPos = new IntBag(49);
    final Message unknown = new Message("It's too costly to figure out where the object went.");
    LocationWrapper selectedWrapper = null;
    HashMap selectedWrappers = new HashMap();

    @Override
    public void setField(Object field) {
        if (!(field instanceof ObjectGrid2D)) {
            throw new RuntimeException("Invalid field for ObjectGridPortrayal2D: " + field);
        }
        super.setField(field);
    }

    @Override
    public Portrayal getDefaultPortrayal() {
        return this.defaultPortrayal;
    }

    @Override
    public Portrayal getDefaultNullPortrayal() {
        return this.defaultNullPortrayal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double2D getScale(DrawInfo2D info) {
        Schedule schedule = info.gui.state.schedule;
        synchronized (schedule) {
            Grid2D field;
            block4: {
                field = (Grid2D)this.field;
                if (field != null) break block4;
                return null;
            }
            int maxX = field.getWidth();
            int maxY = field.getHeight();
            double xScale = info.draw.width / (double)maxX;
            double yScale = info.draw.height / (double)maxY;
            return new Double2D(xScale, yScale);
        }
    }

    @Override
    public Object getPositionLocation(Point2D.Double position, DrawInfo2D info) {
        Double2D scale = this.getScale(info);
        double xScale = scale.x;
        double yScale = scale.y;
        int startx = (int)((position.getX() - info.draw.x) / xScale);
        int starty = (int)((position.getY() - info.draw.y) / yScale);
        return new Int2D(startx, starty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectLocation(Object object, GUIState gui) {
        Schedule schedule = gui.state.schedule;
        synchronized (schedule) {
            ObjectGrid2D field;
            block7: {
                field = (ObjectGrid2D)this.field;
                if (field != null) break block7;
                return null;
            }
            int maxX = field.getWidth();
            int maxY = field.getHeight();
            int x = 0;
            while (x < maxX) {
                Object[] fieldx = field.field[x];
                int y = 0;
                while (y < maxY) {
                    if (object == fieldx[y]) {
                        return new Int2D(x, y);
                    }
                    ++y;
                }
                ++x;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point2D.Double getLocationPosition(Object location, DrawInfo2D info) {
        Schedule schedule = info.gui.state.schedule;
        synchronized (schedule) {
            Int2D loc;
            DrawInfo2D newinfo;
            double yScale;
            double xScale;
            block8: {
                int maxY;
                int maxX;
                block7: {
                    Grid2D field;
                    block6: {
                        field = (Grid2D)this.field;
                        if (field != null) break block6;
                        return null;
                    }
                    maxX = field.getWidth();
                    maxY = field.getHeight();
                    if (maxX != 0 && maxY != 0) break block7;
                    return null;
                }
                xScale = info.draw.width / (double)maxX;
                yScale = info.draw.height / (double)maxY;
                newinfo = new DrawInfo2D(info.gui, info.fieldPortrayal, new Rectangle2D.Double(0.0, 0.0, xScale, yScale), info.clip);
                newinfo.precise = info.precise;
                loc = (Int2D)location;
                if (location != null) break block8;
                return null;
            }
            int x = loc.x;
            int y = loc.y;
            newinfo.draw.x = (int)(info.draw.x + xScale * (double)x);
            newinfo.draw.y = (int)(info.draw.y + yScale * (double)y);
            newinfo.draw.width = (double)((int)(info.draw.x + xScale * (double)(x + 1))) - newinfo.draw.x;
            newinfo.draw.height = (double)((int)(info.draw.y + yScale * (double)(y + 1))) - newinfo.draw.y;
            newinfo.draw.x += newinfo.draw.width / 2.0;
            newinfo.draw.y += newinfo.draw.height / 2.0;
            return new Point2D.Double(newinfo.draw.x, newinfo.draw.y);
        }
    }

    @Override
    protected void hitOrDraw(Graphics2D graphics, DrawInfo2D info, Bag putInHere) {
        ObjectGrid2D field = (ObjectGrid2D)this.field;
        if (field == null) {
            return;
        }
        boolean objectSelected = !this.selectedWrappers.isEmpty();
        Object selectedObject = this.selectedWrapper == null ? null : this.selectedWrapper.getObject();
        int maxX = field.getWidth();
        int maxY = field.getHeight();
        if (maxX == 0 || maxY == 0) {
            return;
        }
        double xScale = info.draw.width / (double)maxX;
        double yScale = info.draw.height / (double)maxY;
        int startx = (int)((info.clip.x - info.draw.x) / xScale);
        int starty = (int)((info.clip.y - info.draw.y) / yScale);
        int endx = (int)((info.clip.x - info.draw.x + info.clip.width) / xScale) + 1;
        int endy = (int)((info.clip.y - info.draw.y + info.clip.height) / yScale) + 1;
        DrawInfo2D newinfo = new DrawInfo2D(info.gui, info.fieldPortrayal, new Rectangle2D.Double(0.0, 0.0, xScale, yScale), info.clip);
        newinfo.precise = info.precise;
        newinfo.location = this.locationToPass;
        newinfo.fieldPortrayal = this;
        if (endx > maxX) {
            endx = maxX;
        }
        if (endy > maxY) {
            endy = maxY;
        }
        if (startx < 0) {
            startx = 0;
        }
        if (starty < 0) {
            starty = 0;
        }
        int x = startx;
        while (x < endx) {
            int y = starty;
            while (y < endy) {
                Object obj = field.field[x][y];
                Portrayal p = this.getPortrayalForObject(obj);
                if (!(p instanceof SimplePortrayal2D)) {
                    throw new RuntimeException("Unexpected Portrayal " + p + " for object " + obj + " -- expected a SimplePortrayal2D");
                }
                SimplePortrayal2D portrayal = (SimplePortrayal2D)p;
                newinfo.draw.x = (int)(info.draw.x + xScale * (double)x);
                newinfo.draw.y = (int)(info.draw.y + yScale * (double)y);
                newinfo.draw.width = (double)((int)(info.draw.x + xScale * (double)(x + 1))) - newinfo.draw.x;
                newinfo.draw.height = (double)((int)(info.draw.y + yScale * (double)(y + 1))) - newinfo.draw.y;
                newinfo.draw.x += newinfo.draw.width / 2.0;
                newinfo.draw.y += newinfo.draw.height / 2.0;
                this.locationToPass.x = x;
                this.locationToPass.y = y;
                if (graphics == null) {
                    if (obj != null && portrayal.hitObject(obj, newinfo)) {
                        putInHere.add(this.getWrapper(obj, new Int2D(x, y)));
                    }
                } else {
                    newinfo.selected = objectSelected && (selectedObject == obj || this.selectedWrappers.get(obj) != null);
                    portrayal.draw(obj, graphics, newinfo);
                }
                ++y;
            }
            ++x;
        }
    }

    Int2D searchForObject(Object object, Int2D loc) {
        ObjectGrid2D field = (ObjectGrid2D)this.field;
        Object[][] grid = field.field;
        if (grid[loc.x][loc.y] == object) {
            return new Int2D(loc.x, loc.y);
        }
        field.getMooreLocations(loc.x, loc.y, 3, 2, true, this.xPos, this.yPos);
        int i = 0;
        while (i < this.xPos.numObjs) {
            if (grid[this.xPos.get(i)][this.yPos.get(i)] == object) {
                return new Int2D(this.xPos.get(i), this.yPos.get(i));
            }
            ++i;
        }
        return null;
    }

    public LocationWrapper getWrapper(Object object, Int2D location) {
        final ObjectGrid2D field = (ObjectGrid2D)this.field;
        return new LocationWrapper(object, location, this){

            @Override
            public Object getLocation() {
                Int2D loc = (Int2D)super.getLocation();
                if (field.field[loc.x][loc.y] == this.getObject()) {
                    return loc;
                }
                Int2D result = ObjectGridPortrayal2D.this.searchForObject(this.object, loc);
                if (result != null) {
                    this.location = result;
                    return result;
                }
                return ObjectGridPortrayal2D.this.unknown;
            }

            @Override
            public String getLocationName() {
                Object loc = this.getLocation();
                if (loc instanceof Int2D) {
                    return ((Int2D)this.location).toCoordinates();
                }
                return "Location Unknown";
            }
        };
    }

    @Override
    public boolean setSelected(LocationWrapper wrapper, boolean selected) {
        if (wrapper == null) {
            return true;
        }
        if (wrapper.getFieldPortrayal() != this) {
            return true;
        }
        Object obj = wrapper.getObject();
        boolean b = this.getPortrayalForObject(obj).setSelected(wrapper, selected);
        if (selected) {
            if (!b) {
                return false;
            }
            this.selectedWrappers.put(obj, wrapper);
            this.selectedWrapper = wrapper;
        } else {
            this.selectedWrappers.remove(obj);
            this.selectedWrapper = null;
        }
        return true;
    }

    public static class Message {
        String message;

        public Message(String message) {
            this.message = message;
        }

        public String getSorry() {
            return this.message;
        }
    }
}

