/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.grid;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import sim.engine.Schedule;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.Grid2D;
import sim.field.grid.IntGrid2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.grid.ValueGridPortrayal2D;
import sim.util.Bag;
import sim.util.Double2D;
import sim.util.Int2D;

public class HexaValueGridPortrayal2D
extends ValueGridPortrayal2D {
    int[] xPoints = new int[6];
    int[] yPoints = new int[6];
    float[] xPointsf = new float[6];
    float[] yPointsf = new float[6];
    double[] xyC = new double[2];
    double[] xyC_ul = new double[2];
    double[] xyC_up = new double[2];
    double[] xyC_ur = new double[2];
    static final double HEXAGONAL_RATIO = 2.0 / Math.sqrt(3.0);
    GeneralPath generalPath = new GeneralPath();

    public HexaValueGridPortrayal2D() {
    }

    public HexaValueGridPortrayal2D(String valueName) {
        super(valueName);
    }

    static final void getxyC(int x, int y, double xScale, double yScale, double tx, double ty, double[] xyC) {
        xyC[0] = tx + xScale * (1.5 * (double)x + 1.0);
        xyC[1] = ty + yScale * (1.0 + 2.0 * (double)y + (double)(x < 0 ? -x % 2 : x % 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double2D getScale(DrawInfo2D info) {
        Schedule schedule = info.gui.state.schedule;
        synchronized (schedule) {
            int maxY;
            int maxX;
            block6: {
                Grid2D field;
                block5: {
                    field = (Grid2D)this.field;
                    if (field != null) break block5;
                    return null;
                }
                maxX = field.getWidth();
                maxY = field.getHeight();
                if (maxX != 0 && maxY != 0) break block6;
                return null;
            }
            double divideByX = maxX % 2 == 0 ? 3.0 * (double)maxX / 2.0 + 0.5 : 3.0 * (double)maxX / 2.0 + 2.0;
            double divideByY = 1.0 + 2.0 * (double)maxY;
            double xScale = info.draw.width / divideByX;
            double yScale = info.draw.height / divideByY;
            return new Double2D(xScale, yScale);
        }
    }

    @Override
    public Object getPositionLocation(Point2D.Double position, DrawInfo2D info) {
        Double2D scale = this.getScale(info);
        double xScale = scale.x;
        double yScale = scale.y;
        int startx = (int)(((position.getX() - info.draw.x) / xScale - 0.5) / 1.5);
        int starty = (int)((position.getY() - info.draw.y) / (yScale * 2.0));
        return new Int2D(startx, starty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point2D.Double getLocationPosition(Object location, DrawInfo2D info) {
        Schedule schedule = info.gui.state.schedule;
        synchronized (schedule) {
            Int2D loc;
            DrawInfo2D newinfo;
            double yScale;
            double xScale;
            Grid2D field;
            block8: {
                int maxY;
                int maxX;
                block7: {
                    block6: {
                        field = (Grid2D)this.field;
                        if (field != null) break block6;
                        return null;
                    }
                    maxX = field.getWidth();
                    maxY = field.getHeight();
                    if (maxX != 0 && maxY != 0) break block7;
                    return null;
                }
                double divideByX = maxX % 2 == 0 ? 3.0 * (double)maxX / 2.0 + 0.5 : 3.0 * (double)maxX / 2.0 + 2.0;
                double divideByY = 1.0 + 2.0 * (double)maxY;
                xScale = info.draw.width / divideByX;
                yScale = info.draw.height / divideByY;
                int startx = (int)(((info.clip.x - info.draw.x) / xScale - 0.5) / 1.5) - 2;
                int starty = (int)((info.clip.y - info.draw.y) / (yScale * 2.0)) - 2;
                int endx = (int)(((info.clip.x - info.draw.x + info.clip.width) / xScale - 0.5) / 1.5) + 4;
                int endy = (int)((info.clip.y - info.draw.y + info.clip.height) / (yScale * 2.0)) + 4;
                newinfo = new DrawInfo2D(info.gui, info.fieldPortrayal, new Rectangle2D.Double(0.0, 0.0, Math.ceil(info.draw.width / (HEXAGONAL_RATIO * ((double)(maxX - 1) * 3.0 / 4.0 + 1.0))), Math.ceil(info.draw.height / ((double)maxY + 0.5))), info.clip);
                newinfo.precise = info.precise;
                loc = (Int2D)location;
                if (loc != null) break block8;
                return null;
            }
            int x = loc.x;
            int y = loc.y;
            HexaValueGridPortrayal2D.getxyC(x, y, xScale, yScale, info.draw.x, info.draw.y, this.xyC);
            HexaValueGridPortrayal2D.getxyC(field.ulx(x, y), field.uly(x, y), xScale, yScale, info.draw.x, info.draw.y, this.xyC_ul);
            HexaValueGridPortrayal2D.getxyC(field.upx(x, y), field.upy(x, y), xScale, yScale, info.draw.x, info.draw.y, this.xyC_up);
            HexaValueGridPortrayal2D.getxyC(field.urx(x, y), field.ury(x, y), xScale, yScale, info.draw.x, info.draw.y, this.xyC_ur);
            this.xPoints[0] = (int)(this.xyC_ur[0] - 0.5 * xScale);
            this.yPoints[1] = (int)(this.xyC_up[1] + yScale);
            this.xPoints[3] = (int)(this.xyC_ul[0] + 0.5 * xScale);
            this.yPoints[4] = (int)(this.xyC[1] + yScale);
            newinfo.draw.x = this.xPoints[3];
            newinfo.draw.y = this.yPoints[1];
            newinfo.draw.x += (double)(this.xPoints[0] - this.xPoints[3]) / 2.0;
            newinfo.draw.y += (double)(this.yPoints[4] - this.yPoints[1]) / 2.0;
            return new Point2D.Double(newinfo.draw.x, newinfo.draw.y);
        }
    }

    @Override
    protected void hitOrDraw(Graphics2D graphics, DrawInfo2D info, Bag putInHere) {
        int[][] intField;
        Grid2D field = (Grid2D)this.field;
        if (field == null) {
            return;
        }
        int maxX = field.getWidth();
        int maxY = field.getHeight();
        if (maxX == 0 || maxY == 0) {
            return;
        }
        double divideByX = maxX % 2 == 0 ? 3.0 * (double)maxX / 2.0 + 0.5 : 3.0 * (double)maxX / 2.0 + 2.0;
        double divideByY = 1.0 + 2.0 * (double)maxY;
        double xScale = info.draw.width / divideByX;
        double yScale = info.draw.height / divideByY;
        int startx = (int)(((info.clip.x - info.draw.x) / xScale - 0.5) / 1.5) - 2;
        int starty = (int)((info.clip.y - info.draw.y) / (yScale * 2.0)) - 2;
        int endx = (int)(((info.clip.x - info.draw.x + info.clip.width) / xScale - 0.5) / 1.5) + 4;
        int endy = (int)((info.clip.y - info.draw.y + info.clip.height) / (yScale * 2.0)) + 4;
        boolean isDoubleGrid2D = field instanceof DoubleGrid2D;
        double[][] doubleField = isDoubleGrid2D ? ((DoubleGrid2D)field).field : null;
        int[][] nArray = intField = isDoubleGrid2D ? null : ((IntGrid2D)field).field;
        if (startx < 0) {
            startx = 0;
        }
        if (starty < 0) {
            starty = 0;
        }
        if (endx > maxX) {
            endx = maxX;
        }
        if (endy > maxY) {
            endy = maxY;
        }
        int y = starty;
        while (y < endy) {
            int x = startx;
            while (x < endx) {
                Color c;
                double x0 = x;
                double y0 = y;
                double tx = info.draw.x;
                double ty = info.draw.y;
                double xyC_x = tx + xScale * (1.5 * x0 + 1.0);
                double xyC_y = ty + yScale * (1.0 + 2.0 * y0 + (x0 < 0.0 ? -x0 % 2.0 : x0 % 2.0));
                x0 = field.ulx(x, y);
                y0 = field.uly(x, y);
                tx = info.draw.x;
                ty = info.draw.y;
                double xyC_ulx = tx + xScale * (1.5 * x0 + 1.0);
                double xyC_uly = ty + yScale * (1.0 + 2.0 * y0 + (x0 < 0.0 ? -x0 % 2.0 : x0 % 2.0));
                x0 = field.upx(x, y);
                y0 = field.upy(x, y);
                tx = info.draw.x;
                ty = info.draw.y;
                double xyC_upx = tx + xScale * (1.5 * x0 + 1.0);
                double xyC_upy = ty + yScale * (1.0 + 2.0 * y0 + (x0 < 0.0 ? -x0 % 2.0 : x0 % 2.0));
                x0 = field.urx(x, y);
                y0 = field.ury(x, y);
                tx = info.draw.x;
                ty = info.draw.y;
                double xyC_urx = tx + xScale * (1.5 * x0 + 1.0);
                double xyC_ury = ty + yScale * (1.0 + 2.0 * y0 + (x0 < 0.0 ? -x0 % 2.0 : x0 % 2.0));
                if (graphics == null) {
                    this.xPointsf[0] = (float)(xyC_urx - 0.5 * xScale);
                    this.yPointsf[0] = (float)(xyC_ury + yScale);
                    this.xPointsf[1] = (float)(xyC_upx + 0.5 * xScale);
                    this.yPointsf[1] = (float)(xyC_upy + yScale);
                    this.xPointsf[2] = (float)(xyC_upx - 0.5 * xScale);
                    this.yPointsf[2] = (float)(xyC_upy + yScale);
                    this.xPointsf[3] = (float)(xyC_ulx + 0.5 * xScale);
                    this.yPointsf[3] = (float)(xyC_uly + yScale);
                    this.xPointsf[4] = (float)(xyC_x - 0.5 * xScale);
                    this.yPointsf[4] = (float)(xyC_y + yScale);
                    this.xPointsf[5] = (float)(xyC_x + 0.5 * xScale);
                    this.yPointsf[5] = (float)(xyC_y + yScale);
                    this.generalPath.reset();
                    this.generalPath.moveTo(this.xPointsf[0], this.yPointsf[0]);
                    int i = 1;
                    while (i < 6) {
                        this.generalPath.lineTo(this.xPointsf[i], this.yPointsf[i]);
                        ++i;
                    }
                    this.generalPath.closePath();
                    Area area = new Area(this.generalPath);
                    if (area.intersects(info.clip.x, info.clip.y, info.clip.width, info.clip.height)) {
                        this.valueToPass.val = isDoubleGrid2D ? doubleField[x][y] : (double)intField[x][y];
                        putInHere.add(this.getWrapper(this.valueToPass.val, new Int2D(x, y)));
                    }
                } else if (info.precise) {
                    this.xPointsf[0] = (float)(xyC_urx - 0.5 * xScale);
                    this.yPointsf[0] = (float)(xyC_ury + yScale);
                    this.xPointsf[1] = (float)(xyC_upx + 0.5 * xScale);
                    this.yPointsf[1] = (float)(xyC_upy + yScale);
                    this.xPointsf[2] = (float)(xyC_upx - 0.5 * xScale);
                    this.yPointsf[2] = (float)(xyC_upy + yScale);
                    this.xPointsf[3] = (float)(xyC_ulx + 0.5 * xScale);
                    this.yPointsf[3] = (float)(xyC_uly + yScale);
                    this.xPointsf[4] = (float)(xyC_x - 0.5 * xScale);
                    this.yPointsf[4] = (float)(xyC_y + yScale);
                    this.xPointsf[5] = (float)(xyC_x + 0.5 * xScale);
                    this.yPointsf[5] = (float)(xyC_y + yScale);
                    c = this.map.getColor(isDoubleGrid2D ? doubleField[x][y] : (double)intField[x][y]);
                    if (c.getAlpha() != 0) {
                        graphics.setColor(c);
                        this.generalPath.reset();
                        this.generalPath.moveTo(this.xPointsf[0], this.yPointsf[0]);
                        int i = 1;
                        while (i < 6) {
                            this.generalPath.lineTo(this.xPointsf[i], this.yPointsf[i]);
                            ++i;
                        }
                        this.generalPath.closePath();
                        graphics.fill(this.generalPath);
                    }
                } else {
                    this.xPoints[0] = (int)(xyC_urx - 0.5 * xScale);
                    this.yPoints[0] = (int)(xyC_ury + yScale);
                    this.xPoints[1] = (int)(xyC_upx + 0.5 * xScale);
                    this.yPoints[1] = (int)(xyC_upy + yScale);
                    this.xPoints[2] = (int)(xyC_upx - 0.5 * xScale);
                    this.yPoints[2] = (int)(xyC_upy + yScale);
                    this.xPoints[3] = (int)(xyC_ulx + 0.5 * xScale);
                    this.yPoints[3] = (int)(xyC_uly + yScale);
                    this.xPoints[4] = (int)(xyC_x - 0.5 * xScale);
                    this.yPoints[4] = (int)(xyC_y + yScale);
                    this.xPoints[5] = (int)(xyC_x + 0.5 * xScale);
                    this.yPoints[5] = (int)(xyC_y + yScale);
                    c = this.map.getColor(isDoubleGrid2D ? doubleField[x][y] : (double)intField[x][y]);
                    if (c.getAlpha() != 0) {
                        graphics.setColor(c);
                        graphics.fillPolygon(this.xPoints, this.yPoints, 6);
                    }
                }
                ++x;
            }
            ++y;
        }
    }
}

