/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.grid;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import sim.display.Display2D;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.Grid2D;
import sim.field.grid.IntGrid2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.grid.ValueGridPortrayal2D;
import sim.util.gui.ColorMap;

public class FastValueGridPortrayal2D
extends ValueGridPortrayal2D {
    BufferedImage buffer;
    WritableRaster raster;
    int[] data = new int[0];

    public FastValueGridPortrayal2D(String valueName, boolean immutableField) {
        super(valueName);
        this.setImmutableField(immutableField);
    }

    public FastValueGridPortrayal2D(String valueName) {
        this(valueName, false);
    }

    public FastValueGridPortrayal2D(boolean immutableField) {
        this.setImmutableField(immutableField);
    }

    public FastValueGridPortrayal2D() {
        this(false);
    }

    boolean shouldBuffer(Graphics2D graphics) {
        int buffering = this.getBuffering();
        if (buffering == 1) {
            return true;
        }
        if (buffering == 2) {
            return false;
        }
        if (Display2D.isMacOSX) {
            return graphics.getDeviceConfiguration().getDevice().getType() != 2;
        }
        if (Display2D.isWindows) {
            return this.immutableField;
        }
        return graphics.getDeviceConfiguration().getDevice().getType() != 2;
    }

    @Override
    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        int[][] intField;
        Grid2D field = (Grid2D)this.field;
        if (field == null) {
            return;
        }
        int maxX = field.getWidth();
        int maxY = field.getHeight();
        if (maxX == 0 || maxY == 0) {
            return;
        }
        double xScale = info.draw.width / (double)maxX;
        double yScale = info.draw.height / (double)maxY;
        double startxd = (info.clip.x - info.draw.x) / xScale;
        double startyd = (info.clip.y - info.draw.y) / yScale;
        double endxd = (info.clip.x - info.draw.x + info.clip.width) / xScale;
        double endyd = (info.clip.y - info.draw.y + info.clip.height) / yScale;
        int startx = (int)startxd;
        int starty = (int)startyd;
        int endx = (int)endxd + 1;
        int endy = (int)endyd + 1;
        boolean isDoubleGrid2D = field instanceof DoubleGrid2D;
        double[][] doubleField = isDoubleGrid2D ? ((DoubleGrid2D)field).field : null;
        int[][] nArray = intField = isDoubleGrid2D ? null : ((IntGrid2D)field).field;
        if (this.shouldBuffer(graphics)) {
            boolean newBuffer = false;
            if (this.buffer == null || this.buffer.getWidth() != maxX || this.buffer.getHeight() != maxY) {
                if (this.buffer != null) {
                    this.buffer.flush();
                }
                this.buffer = new BufferedImage(maxX, maxY, 2);
                this.raster = this.buffer.getRaster();
                newBuffer = true;
            }
            if (newBuffer || !this.immutableField || this.isDirtyField()) {
                if (endx > maxX) {
                    endx = maxX;
                }
                if (endy > maxY) {
                    endy = maxY;
                }
                if (startx < 0) {
                    startx = 0;
                }
                if (starty < 0) {
                    starty = 0;
                }
                int ex = endx;
                int ey = endy;
                int sx = startx;
                int sy = starty;
                if (this.immutableField) {
                    startx = 0;
                    starty = 0;
                    endx = maxX;
                    endy = maxY;
                }
                ColorMap map = this.map;
                if (ex - sx > 0 && ey - sy > 0) {
                    int[] data = this.data;
                    if (data.length != (ex - sx) * (ey - sy)) {
                        data = this.data = new int[(ex - sx) * (ey - sy)];
                    }
                    int i = 0;
                    if (isDoubleGrid2D) {
                        int y = sy;
                        while (y < ey) {
                            int x = sx;
                            while (x < ex) {
                                data[i++] = map.getRGB(doubleField[x][y]);
                                ++x;
                            }
                            ++y;
                        }
                    } else {
                        int y = sy;
                        while (y < ey) {
                            int x = sx;
                            while (x < ex) {
                                data[i++] = map.getRGB(intField[x][y]);
                                ++x;
                            }
                            ++y;
                        }
                    }
                    this.raster.setDataElements(sx, sy, ex - sx, ey - sy, data);
                }
            }
            graphics.drawImage(this.buffer, (int)info.draw.x, (int)info.draw.y, (int)info.draw.width, (int)info.draw.height, null);
        } else if (!info.precise) {
            this.buffer = null;
            if (endx > maxX) {
                endx = maxX;
            }
            if (endy > maxY) {
                endy = maxY;
            }
            if (startx < 0) {
                startx = 0;
            }
            if (starty < 0) {
                starty = 0;
            }
            int ex = endx;
            int ey = endy;
            int sx = startx;
            int sy = starty;
            int _x = 0;
            int _y = 0;
            int _width = 0;
            int _height = 0;
            ColorMap map = this.map;
            double infodrawx = info.draw.x;
            double infodrawy = info.draw.y;
            if (isDoubleGrid2D) {
                int x = sx;
                while (x < ex) {
                    int y = sy;
                    while (y < ey) {
                        Color c = map.getColor(doubleField[x][y]);
                        if (c.getAlpha() != 0) {
                            graphics.setColor(c);
                            _x = (int)(infodrawx + xScale * (double)x);
                            _y = (int)(infodrawy + yScale * (double)y);
                            _width = (int)(infodrawx + xScale * (double)(x + 1)) - _x;
                            _height = (int)(infodrawy + yScale * (double)(y + 1)) - _y;
                            graphics.fillRect(_x, _y, _width, _height);
                        }
                        ++y;
                    }
                    ++x;
                }
            } else {
                int x = sx;
                while (x < ex) {
                    int y = sy;
                    while (y < ey) {
                        Color c = map.getColor(intField[x][y]);
                        if (c.getAlpha() != 0) {
                            graphics.setColor(c);
                            _x = (int)(infodrawx + xScale * (double)x);
                            _y = (int)(infodrawy + yScale * (double)y);
                            _width = (int)(infodrawx + xScale * (double)(x + 1)) - _x;
                            _height = (int)(infodrawy + yScale * (double)(y + 1)) - _y;
                            graphics.fillRect(_x, _y, _width, _height);
                        }
                        ++y;
                    }
                    ++x;
                }
            }
        } else {
            graphics.setStroke(new BasicStroke(0.0f));
            Rectangle2D.Double preciseRectangle = new Rectangle2D.Double();
            this.buffer = null;
            if (endxd > (double)maxX) {
                endxd = maxX;
            }
            if (endyd > (double)maxY) {
                endyd = maxY;
            }
            if (startxd < 0.0) {
                startxd = 0.0;
            }
            if (startyd < 0.0) {
                startyd = 0.0;
            }
            double _x = 0.0;
            double _y = 0.0;
            double _width = 0.0;
            double _height = 0.0;
            ColorMap map = this.map;
            double infodrawx = info.draw.x;
            double infodrawy = info.draw.y;
            if (isDoubleGrid2D) {
                double x = startxd;
                while (x < endxd) {
                    double y = startyd;
                    while (y < endyd) {
                        Color c = map.getColor(doubleField[(int)x][(int)y]);
                        if (c.getAlpha() != 0) {
                            graphics.setColor(c);
                            _x = infodrawx + xScale * x;
                            _y = infodrawy + yScale * y;
                            _width = infodrawx + xScale * (x + 1.0) - _x;
                            _height = infodrawy + yScale * (y + 1.0) - _y;
                            preciseRectangle.setFrame(_x, _y, _width, _height);
                            graphics.fill(preciseRectangle);
                            graphics.draw(preciseRectangle);
                        }
                        y += 1.0;
                    }
                    x += 1.0;
                }
            } else {
                double x = startxd;
                while (x < endxd) {
                    double y = startyd;
                    while (y < endyd) {
                        Color c = map.getColor(intField[(int)x][(int)y]);
                        if (c.getAlpha() != 0) {
                            graphics.setColor(c);
                            _x = infodrawx + xScale * x;
                            _y = infodrawy + yScale * y;
                            _width = infodrawx + xScale * (x + 1.0) - _x;
                            _height = infodrawy + yScale * (y + 1.0) - _y;
                            preciseRectangle.setFrame(_x, _y, _width, _height);
                            graphics.fill(preciseRectangle);
                            graphics.draw(preciseRectangle);
                        }
                        y += 1.0;
                    }
                    x += 1.0;
                }
            }
        }
        if (graphics != null) {
            this.setDirtyField(false);
        }
    }
}

