/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.continuous;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import sim.display.GUIState;
import sim.engine.Schedule;
import sim.field.continuous.Continuous2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.FieldPortrayal2D;
import sim.portrayal.Fixed2D;
import sim.portrayal.LocationWrapper;
import sim.portrayal.Portrayal;
import sim.portrayal.SimplePortrayal2D;
import sim.portrayal.inspector.StableDouble2D;
import sim.portrayal.simple.OvalPortrayal2D;
import sim.util.Bag;
import sim.util.Double2D;

public class ContinuousPortrayal2D
extends FieldPortrayal2D {
    SimplePortrayal2D defaultPortrayal = new OvalPortrayal2D();
    Paint frame = null;
    Paint axes = null;
    boolean drawsFrameAndAxesInFront = true;
    static final int[] toroidalX;
    static final int[] toroidalY;
    boolean displayingToroidally = false;
    HashMap selectedWrappers = new HashMap();

    static {
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[2] = -1;
        nArray[4] = 1;
        nArray[5] = -1;
        nArray[7] = 1;
        nArray[8] = -1;
        toroidalX = nArray;
        int[] nArray2 = new int[9];
        nArray2[3] = 1;
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[6] = -1;
        nArray2[7] = -1;
        nArray2[8] = -1;
        toroidalY = nArray2;
    }

    public void setFrame(Paint p) {
        this.frame = p;
    }

    public Paint getFame() {
        return this.frame;
    }

    public void setAxes(Paint p) {
        this.axes = p;
    }

    public Paint getAxes() {
        return this.axes;
    }

    public boolean getDrawsFrameAndAxesInFront() {
        return this.drawsFrameAndAxesInFront;
    }

    public void setDrawsFrameAndAxesInFront(boolean val) {
        this.drawsFrameAndAxesInFront = val;
    }

    @Override
    public void setField(Object field) {
        if (!(field instanceof Continuous2D)) {
            throw new RuntimeException("Invalid field for ContinuousPortrayal2D: " + field);
        }
        super.setField(field);
    }

    @Override
    public Portrayal getDefaultPortrayal() {
        return this.defaultPortrayal;
    }

    @Override
    public Point2D.Double getRelativeObjectPosition(Object location, Object otherObjectLocation, DrawInfo2D otherObjectInfo) {
        Continuous2D field = (Continuous2D)this.field;
        if (field == null) {
            return null;
        }
        Double2D loc = (Double2D)location;
        Double2D oloc = (Double2D)otherObjectLocation;
        double dx = loc.x - oloc.x;
        double dy = loc.y - oloc.y;
        double xScale = otherObjectInfo.draw.width;
        double yScale = otherObjectInfo.draw.height;
        return new Point2D.Double(dx * xScale + otherObjectInfo.draw.x, dy * yScale + otherObjectInfo.draw.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double2D getScale(DrawInfo2D info) {
        Schedule schedule = info.gui.state.schedule;
        synchronized (schedule) {
            Continuous2D field;
            block4: {
                field = (Continuous2D)this.field;
                if (field != null) break block4;
                return null;
            }
            double xScale = info.draw.width / field.width;
            double yScale = info.draw.height / field.height;
            return new Double2D(xScale, yScale);
        }
    }

    @Override
    public Object getPositionLocation(Point2D.Double position, DrawInfo2D fieldPortrayalInfo) {
        Double2D scale = this.getScale(fieldPortrayalInfo);
        double xScale = scale.x;
        double yScale = scale.y;
        double x = (position.getX() - fieldPortrayalInfo.draw.x) / xScale;
        double y = (position.getY() - fieldPortrayalInfo.draw.y) / yScale;
        return new Double2D(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObjectPosition(Object object, Point2D.Double position, DrawInfo2D fieldPortrayalInfo) {
        Schedule schedule = fieldPortrayalInfo.gui.state.schedule;
        synchronized (schedule) {
            Continuous2D field = (Continuous2D)this.field;
            if (field == null) {
                return;
            }
            if (field.getObjectLocation(object) == null) {
                return;
            }
            Double2D location = (Double2D)this.getPositionLocation(position, fieldPortrayalInfo);
            if (location != null) {
                if (object instanceof Fixed2D && !((Fixed2D)object).maySetLocation(field, location)) {
                    return;
                }
                if (location != null) {
                    field.setObjectLocation(object, location);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectLocation(Object object, GUIState gui) {
        Schedule schedule = gui.state.schedule;
        synchronized (schedule) {
            Continuous2D field;
            block4: {
                field = (Continuous2D)this.field;
                if (field != null) break block4;
                return null;
            }
            return field.getObjectLocation(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point2D.Double getLocationPosition(Object location, DrawInfo2D fieldPortrayalInfo) {
        Schedule schedule = fieldPortrayalInfo.gui.state.schedule;
        synchronized (schedule) {
            Double2D loc;
            DrawInfo2D newinfo;
            double yScale;
            double xScale;
            block6: {
                Continuous2D field;
                block5: {
                    field = (Continuous2D)this.field;
                    if (field != null) break block5;
                    return null;
                }
                xScale = fieldPortrayalInfo.draw.width / field.width;
                yScale = fieldPortrayalInfo.draw.height / field.height;
                newinfo = new DrawInfo2D(fieldPortrayalInfo.gui, fieldPortrayalInfo.fieldPortrayal, new Rectangle2D.Double(0.0, 0.0, xScale, yScale), fieldPortrayalInfo.clip);
                newinfo.precise = fieldPortrayalInfo.precise;
                loc = (Double2D)location;
                if (loc != null) break block6;
                return null;
            }
            newinfo.draw.x = fieldPortrayalInfo.draw.x + xScale * loc.x;
            newinfo.draw.y = fieldPortrayalInfo.draw.y + yScale * loc.y;
            return new Point2D.Double(newinfo.draw.x, newinfo.draw.y);
        }
    }

    public void setDisplayingToroidally(boolean val) {
        this.displayingToroidally = val;
    }

    public boolean isDisplayingToroidally() {
        return this.displayingToroidally;
    }

    @Override
    protected void hitOrDraw(Graphics2D graphics, DrawInfo2D info, Bag putInHere) {
        Continuous2D field = (Continuous2D)this.field;
        if (field == null) {
            return;
        }
        if (!this.drawsFrameAndAxesInFront) {
            this.drawFrameAndAxes(graphics, info);
        }
        boolean objectSelected = !this.selectedWrappers.isEmpty();
        double xScale = info.draw.width / field.width;
        double yScale = info.draw.height / field.height;
        int startx = (int)Math.floor((info.clip.x - info.draw.x) / xScale);
        int starty = (int)Math.floor((info.clip.y - info.draw.y) / yScale);
        int endx = (int)Math.floor((info.clip.x - info.draw.x + info.clip.width) / xScale) + 1;
        int endy = (int)Math.floor((info.clip.y - info.draw.y + info.clip.height) / yScale) + 1;
        DrawInfo2D newinfo = new DrawInfo2D(info.gui, info.fieldPortrayal, new Rectangle2D.Double(0.0, 0.0, xScale, yScale), info.clip);
        newinfo.precise = info.precise;
        newinfo.fieldPortrayal = this;
        Bag objects = field.getAllObjects();
        double discretizationOverlap = field.discretization;
        int x = 0;
        while (x < objects.numObjs) {
            Object object = objects.objs[x];
            Double2D objectLoc = field.getObjectLocation(object);
            if (this.displayingToroidally) {
                objectLoc = new Double2D(field.tx(objectLoc.x), field.tx(objectLoc.y));
            }
            int i = 0;
            while (i < toroidalX.length) {
                Double2D loc = null;
                if (i == 0) {
                    loc = objectLoc;
                } else {
                    if (!this.displayingToroidally) break;
                    loc = new Double2D(objectLoc.x + field.width * (double)toroidalX[i], objectLoc.y + field.height * (double)toroidalY[i]);
                }
                if (loc.x >= (double)startx - discretizationOverlap && loc.x < (double)endx + discretizationOverlap && loc.y >= (double)starty - discretizationOverlap && loc.y < (double)endy + discretizationOverlap) {
                    Portrayal p = this.getPortrayalForObject(object);
                    if (!(p instanceof SimplePortrayal2D)) {
                        throw new RuntimeException("Unexpected Portrayal " + p + " for object " + objects.objs[x] + " -- expected a SimplePortrayal2D");
                    }
                    SimplePortrayal2D portrayal = (SimplePortrayal2D)p;
                    newinfo.draw.x = info.draw.x + xScale * loc.x;
                    newinfo.draw.y = info.draw.y + yScale * loc.y;
                    newinfo.location = loc;
                    Object portrayedObject = object;
                    if (graphics == null) {
                        if (portrayal.hitObject(portrayedObject, newinfo)) {
                            putInHere.add(this.getWrapper(portrayedObject));
                        }
                    } else {
                        newinfo.selected = objectSelected && this.selectedWrappers.get(portrayedObject) != null;
                        portrayal.draw(portrayedObject, graphics, newinfo);
                    }
                }
                ++i;
            }
            ++x;
        }
        if (this.drawsFrameAndAxesInFront) {
            this.drawFrameAndAxes(graphics, info);
        }
    }

    void drawFrameAndAxes(Graphics2D graphics, DrawInfo2D info) {
        if (this.frame != null && graphics != null) {
            graphics.setPaint(this.frame);
            graphics.draw(new Rectangle2D.Double(info.draw.x - 1.0, info.draw.y - 1.0, info.draw.width + 1.0, info.draw.height + 1.0));
        }
        if (this.axes != null && graphics != null) {
            graphics.setPaint(this.axes);
            graphics.draw(new Line2D.Double(info.clip.x, info.draw.y + info.draw.height / 2.0, info.clip.x + info.clip.width, info.draw.y + info.draw.height / 2.0));
            graphics.draw(new Line2D.Double(info.draw.x + info.draw.width / 2.0, info.clip.y, info.draw.x + info.draw.width / 2.0, info.clip.y + info.clip.height));
        }
    }

    public LocationWrapper getWrapper(Object obj) {
        Continuous2D field = (Continuous2D)this.field;
        final StableDouble2D w = new StableDouble2D(field, obj);
        return new LocationWrapper(obj, null, this){

            @Override
            public Object getLocation() {
                return w;
            }

            @Override
            public String getLocationName() {
                return w.toString();
            }
        };
    }

    @Override
    public boolean setSelected(LocationWrapper wrapper, boolean selected) {
        if (wrapper == null) {
            return true;
        }
        if (wrapper.getFieldPortrayal() != this) {
            return true;
        }
        Object obj = wrapper.getObject();
        boolean b = this.getPortrayalForObject(obj).setSelected(wrapper, selected);
        if (selected) {
            if (!b) {
                return false;
            }
            this.selectedWrappers.put(obj, wrapper);
        } else {
            this.selectedWrappers.remove(obj);
        }
        return true;
    }
}

