/*
 * Decompiled with CFR 0.152.
 */
package sim.field.grid;

import java.util.Map;
import sim.field.SparseField;
import sim.field.SparseField2D;
import sim.field.grid.Grid2D;
import sim.util.Bag;
import sim.util.Double2D;
import sim.util.Int2D;
import sim.util.IntBag;
import sim.util.MutableInt2D;

public class SparseGrid2D
extends SparseField
implements Grid2D,
SparseField2D {
    private static final long serialVersionUID = 1L;
    protected int width;
    protected int height;
    MutableInt2D speedyMutableInt2D = new MutableInt2D();

    public SparseGrid2D(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public SparseGrid2D(SparseGrid2D values) {
        super(values);
        this.width = values.width;
        this.height = values.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public final int tx(int x) {
        int width = this.width;
        if (x >= 0 && x < width) {
            return x;
        }
        if ((x %= width) < 0) {
            x += width;
        }
        return x;
    }

    @Override
    public final int ty(int y) {
        int height = this.height;
        if (y >= 0 && y < height) {
            return y;
        }
        if ((y %= height) < 0) {
            y += height;
        }
        return y;
    }

    @Override
    public int stx(int x) {
        if (x >= 0) {
            if (x < this.width) {
                return x;
            }
            return x - this.width;
        }
        return x + this.width;
    }

    @Override
    public int sty(int y) {
        if (y >= 0) {
            if (y < this.height) {
                return y;
            }
            return y - this.height;
        }
        return y + this.height;
    }

    final int stx(int x, int width) {
        if (x >= 0) {
            if (x < width) {
                return x;
            }
            return x - width;
        }
        return x + width;
    }

    final int sty(int y, int height) {
        if (y >= 0) {
            if (y < height) {
                return y;
            }
            return y - height;
        }
        return y + height;
    }

    @Override
    public int ulx(int x, int y) {
        return x - 1;
    }

    @Override
    public int uly(int x, int y) {
        if ((x & 1) == 0) {
            return y - 1;
        }
        return y;
    }

    @Override
    public int urx(int x, int y) {
        return x + 1;
    }

    @Override
    public int ury(int x, int y) {
        if ((x & 1) == 0) {
            return y - 1;
        }
        return y;
    }

    @Override
    public int dlx(int x, int y) {
        return x - 1;
    }

    @Override
    public int dly(int x, int y) {
        if ((x & 1) == 0) {
            return y;
        }
        return y + 1;
    }

    @Override
    public int drx(int x, int y) {
        return x + 1;
    }

    @Override
    public int dry(int x, int y) {
        if ((x & 1) == 0) {
            return y;
        }
        return y + 1;
    }

    @Override
    public int upx(int x, int y) {
        return x;
    }

    @Override
    public int upy(int x, int y) {
        return y - 1;
    }

    @Override
    public int downx(int x, int y) {
        return x;
    }

    @Override
    public int downy(int x, int y) {
        return y + 1;
    }

    @Override
    public boolean trb(int x, int y) {
        return (x + y & 1) == 1;
    }

    @Override
    public boolean trt(int x, int y) {
        return (x + y & 1) == 0;
    }

    int tx(int x, int width, int widthtimestwo, int xpluswidth, int xminuswidth) {
        if (x >= -width && x < widthtimestwo) {
            if (x < 0) {
                return xpluswidth;
            }
            if (x < width) {
                return x;
            }
            return xminuswidth;
        }
        return this.tx2(x, width);
    }

    int tx2(int x, int width) {
        if ((x %= width) < 0) {
            x += width;
        }
        return x;
    }

    int ty(int y, int height, int heighttimestwo, int yplusheight, int yminusheight) {
        if (y >= -height && y < heighttimestwo) {
            if (y < 0) {
                return yplusheight;
            }
            if (y < height) {
                return y;
            }
            return yminusheight;
        }
        return this.ty2(y, height);
    }

    int ty2(int y, int height) {
        if ((y %= height) < 0) {
            y += height;
        }
        return y;
    }

    protected void removeOrigin(int x, int y, IntBag xPos, IntBag yPos) {
        int size = xPos.size();
        int i = 0;
        while (i < size) {
            if (xPos.get(i) == x && yPos.get(i) == y) {
                xPos.remove(i);
                yPos.remove(i);
                return;
            }
            ++i;
        }
    }

    protected void removeOriginToroidal(int x, int y, IntBag xPos, IntBag yPos) {
        int size = xPos.size();
        x = this.tx(x, this.width, this.width * 2, x + this.width, x - this.width);
        y = this.ty(y, this.height, this.height * 2, y + this.height, y - this.height);
        int i = 0;
        while (i < size) {
            if (this.tx(xPos.get(i), this.width, this.width * 2, x + this.width, x - this.width) == x && this.ty(yPos.get(i), this.height, this.height * 2, y + this.height, y - this.height) == y) {
                xPos.remove(i);
                yPos.remove(i);
                return;
            }
            ++i;
        }
    }

    public int numObjectsAtLocation(int x, int y) {
        MutableInt2D speedyMutableInt2D = this.speedyMutableInt2D;
        speedyMutableInt2D.x = x;
        speedyMutableInt2D.y = y;
        return this.numObjectsAtLocation(speedyMutableInt2D);
    }

    public Bag getObjectsAtLocation(int x, int y) {
        MutableInt2D speedyMutableInt2D = this.speedyMutableInt2D;
        speedyMutableInt2D.x = x;
        speedyMutableInt2D.y = y;
        return this.getObjectsAtLocation(speedyMutableInt2D);
    }

    @Override
    public Double2D getObjectLocationAsDouble2D(Object obj) {
        Int2D loc = (Int2D)super.getRawObjectLocation(obj);
        if (loc == null) {
            return null;
        }
        return new Double2D(loc);
    }

    public Int2D getObjectLocation(Object obj) {
        return (Int2D)super.getRawObjectLocation(obj);
    }

    public Bag removeObjectsAtLocation(int x, int y) {
        MutableInt2D speedyMutableInt2D = this.speedyMutableInt2D;
        speedyMutableInt2D.x = x;
        speedyMutableInt2D.y = y;
        return this.removeObjectsAtLocation(speedyMutableInt2D);
    }

    public boolean setObjectLocation(Object obj, int x, int y) {
        return super.setObjectLocation(obj, new Int2D(x, y));
    }

    public boolean setObjectLocation(Object obj, Int2D location) {
        return super.setObjectLocation(obj, location);
    }

    @Override
    public void getNeighborsMaxDistance(int x, int y, int dist, boolean toroidal, IntBag xPos, IntBag yPos) {
        this.getMooreLocations(x, y, dist, toroidal ? 2 : 0, true, xPos, yPos);
    }

    @Override
    public void getMooreLocations(int x, int y, int dist, int mode, boolean includeOrigin, IntBag xPos, IntBag yPos) {
        boolean bounded;
        boolean toroidal = mode == 2;
        boolean bl = bounded = mode == 0;
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new RuntimeException("Mode must be either Grid2D.BOUNDED, Grid2D.UNBOUNDED, or Grid2D.TOROIDAL");
        }
        if (dist < 0) {
            throw new RuntimeException("Distance must be positive");
        }
        if (xPos == null || yPos == null) {
            throw new RuntimeException("xPos and yPos should not be null");
        }
        if (!(x >= 0 && x < this.width && y >= 0 && y < this.height || bounded)) {
            throw new RuntimeException("Invalid initial position");
        }
        xPos.clear();
        yPos.clear();
        int height = this.height;
        int width = this.width;
        if (toroidal) {
            int ymin;
            int ymax;
            int xmax = x + dist;
            int xmin = x - dist;
            if (xmax - xmin >= width) {
                xmin = 0;
                xmax = width - 1;
            }
            if ((ymax = y + dist) - (ymin = y - dist) >= height) {
                ymin = 0;
                ymax = width - 1;
            }
            int x0 = xmin;
            while (x0 <= xmax) {
                int x_0 = this.tx(x0, width, width * 2, x0 + width, x0 - width);
                int y0 = ymin;
                while (y0 <= ymax) {
                    int y_0 = this.ty(y0, height, height * 2, y0 + height, y0 - height);
                    xPos.add(x_0);
                    yPos.add(y_0);
                    ++y0;
                }
                ++x0;
            }
            if (!includeOrigin) {
                this.removeOriginToroidal(x, y, xPos, yPos);
            }
        } else {
            int xmin = x - dist >= 0 || !bounded ? x - dist : 0;
            int xmax = x + dist <= width - 1 || !bounded ? x + dist : width - 1;
            int ymin = y - dist >= 0 || !bounded ? y - dist : 0;
            int ymax = y + dist <= height - 1 || !bounded ? y + dist : height - 1;
            int x0 = xmin;
            while (x0 <= xmax) {
                int y0 = ymin;
                while (y0 <= ymax) {
                    xPos.add(x0);
                    yPos.add(y0);
                    ++y0;
                }
                ++x0;
            }
            if (!includeOrigin) {
                this.removeOrigin(x, y, xPos, yPos);
            }
        }
    }

    @Override
    public void getNeighborsHamiltonianDistance(int x, int y, int dist, boolean toroidal, IntBag xPos, IntBag yPos) {
        this.getVonNeumannLocations(x, y, dist, toroidal ? 2 : 0, true, xPos, yPos);
    }

    @Override
    public void getVonNeumannLocations(int x, int y, int dist, int mode, boolean includeOrigin, IntBag xPos, IntBag yPos) {
        boolean bounded;
        boolean toroidal = mode == 2;
        boolean bl = bounded = mode == 0;
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new RuntimeException("Mode must be either Grid2D.BOUNDED, Grid2D.UNBOUNDED, or Grid2D.TOROIDAL");
        }
        if (dist < 0) {
            throw new RuntimeException("Distance must be positive");
        }
        if (xPos == null || yPos == null) {
            throw new RuntimeException("xPos and yPos should not be null");
        }
        if (!(x >= 0 && x < this.width && y >= 0 && y < this.height || bounded)) {
            throw new RuntimeException("Invalid initial position");
        }
        xPos.clear();
        yPos.clear();
        int height = this.height;
        int width = this.width;
        if (toroidal) {
            int xmin;
            int xmax = x + dist;
            int x0 = xmin = x - dist;
            while (x0 <= xmax) {
                int ymin;
                int x_0 = this.tx(x0, width, width * 2, x0 + width, x0 - width);
                int ymax = y + (dist - (x0 - x >= 0 ? x0 - x : x - x0));
                int y0 = ymin = y - (dist - (x0 - x >= 0 ? x0 - x : x - x0));
                while (y0 <= ymax) {
                    int y_0 = this.ty(y0, height, height * 2, y0 + height, y0 - height);
                    xPos.add(x_0);
                    yPos.add(y_0);
                    ++y0;
                }
                ++x0;
            }
            if (dist * 2 >= width || dist * 2 >= height) {
                int sz = xPos.size();
                Map map = this.buildMap(sz);
                int i = 0;
                while (i < sz) {
                    Double2D elem = new Double2D(xPos.get(i), yPos.get(i));
                    if (map.containsKey(elem)) {
                        xPos.remove(i);
                        yPos.remove(i);
                        --i;
                        --sz;
                    } else {
                        map.put(elem, elem);
                    }
                    ++i;
                }
            }
            if (!includeOrigin) {
                this.removeOriginToroidal(x, y, xPos, yPos);
            }
        } else {
            int xmin;
            int xmax = x + dist <= width - 1 || !bounded ? x + dist : width - 1;
            int x0 = xmin = x - dist >= 0 || !bounded ? x - dist : 0;
            while (x0 <= xmax) {
                int ymin;
                int ymax = y + (dist - (x0 - x >= 0 ? x0 - x : x - x0)) <= height - 1 || !bounded ? y + (dist - (x0 - x >= 0 ? x0 - x : x - x0)) : height - 1;
                int y0 = ymin = y - (dist - (x0 - x >= 0 ? x0 - x : x - x0)) >= 0 || !bounded ? y - (dist - (x0 - x >= 0 ? x0 - x : x - x0)) : 0;
                while (y0 <= ymax) {
                    xPos.add(x0);
                    yPos.add(y0);
                    ++y0;
                }
                ++x0;
            }
            if (!includeOrigin) {
                this.removeOrigin(x, y, xPos, yPos);
            }
        }
    }

    @Override
    public void getNeighborsHexagonalDistance(int x, int y, int dist, boolean toroidal, IntBag xPos, IntBag yPos) {
        this.getHexagonalLocations(x, y, dist, toroidal ? 2 : 0, true, xPos, yPos);
    }

    @Override
    public void getHexagonalLocations(int x, int y, int dist, int mode, boolean includeOrigin, IntBag xPos, IntBag yPos) {
        boolean bounded;
        boolean toroidal = mode == 2;
        boolean bl = bounded = mode == 0;
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new RuntimeException("Mode must be either Grid2D.BOUNDED, Grid2D.UNBOUNDED, or Grid2D.TOROIDAL");
        }
        if (dist < 0) {
            throw new RuntimeException("Distance must be positive");
        }
        if (xPos == null || yPos == null) {
            throw new RuntimeException("xPos and yPos should not be null");
        }
        if (!(x >= 0 && x < this.width && y >= 0 && y < this.height || bounded)) {
            throw new RuntimeException("Invalid initial position");
        }
        xPos.clear();
        yPos.clear();
        int height = this.height;
        int width = this.width;
        if (toroidal && height % 2 == 1) {
            throw new RuntimeException("toroidal hexagonal environment should have even heights");
        }
        if (toroidal) {
            int y0;
            int temp_ymin;
            int ymin = y - dist;
            int ymax = y + dist;
            int y02 = ymin;
            while (y02 <= ymax) {
                xPos.add(this.tx(x, width, width * 2, x + width, x - width));
                yPos.add(this.ty(y02, height, height * 2, y02 + height, y02 - height));
                y02 = this.downy(x, y02);
            }
            int x0 = x;
            int i = 1;
            while (i <= dist) {
                temp_ymin = ymin;
                ymin = this.dly(x0, ymin);
                ymax = this.uly(x0, ymax);
                x0 = this.dlx(x0, temp_ymin);
                y0 = ymin;
                while (y0 <= ymax) {
                    xPos.add(this.tx(x0, width, width * 2, x0 + width, x0 - width));
                    yPos.add(this.ty(y0, height, height * 2, y0 + height, y0 - height));
                    y0 = this.downy(x0, y0);
                }
                ++i;
            }
            x0 = x;
            ymin = y - dist;
            ymax = y + dist;
            i = 1;
            while (i <= dist) {
                temp_ymin = ymin;
                ymin = this.dry(x0, ymin);
                ymax = this.ury(x0, ymax);
                x0 = this.drx(x0, temp_ymin);
                y0 = ymin;
                while (y0 <= ymax) {
                    xPos.add(this.tx(x0, width, width * 2, x0 + width, x0 - width));
                    yPos.add(this.ty(y0, height, height * 2, y0 + height, y0 - height));
                    y0 = this.downy(x0, y0);
                }
                ++i;
            }
            if (dist * 2 >= width || dist * 2 >= height) {
                int sz = xPos.size();
                Map map = this.buildMap(sz);
                int i2 = 0;
                while (i2 < sz) {
                    Double2D elem = new Double2D(xPos.get(i2), yPos.get(i2));
                    if (map.containsKey(elem)) {
                        xPos.remove(i2);
                        yPos.remove(i2);
                        --i2;
                        --sz;
                    } else {
                        map.put(elem, elem);
                    }
                    ++i2;
                }
            }
            if (!includeOrigin) {
                this.removeOriginToroidal(x, y, xPos, yPos);
            }
        } else {
            int y0;
            int temp_ymin;
            int ymin = y - dist;
            int ymax = y + dist;
            int ylBound = ymin >= 0 || !bounded ? ymin : 0;
            int yuBound = ymax < height || !bounded ? ymax : height - 1;
            int y03 = ylBound;
            while (y03 <= yuBound) {
                xPos.add(x);
                yPos.add(y03);
                y03 = this.downy(x, y03);
            }
            int x0 = x;
            ymin = y - dist;
            ymax = y + dist;
            int i = 1;
            while (i <= dist) {
                temp_ymin = ymin;
                ymin = this.dly(x0, ymin);
                ymax = this.uly(x0, ymax);
                x0 = this.dlx(x0, temp_ymin);
                ylBound = ymin >= 0 || !bounded ? ymin : 0;
                int n = yuBound = ymax < height || !bounded ? ymax : height - 1;
                if (x0 >= 0) {
                    y0 = ylBound;
                    while (y0 <= yuBound) {
                        if (y0 >= 0 || !bounded) {
                            xPos.add(x0);
                            yPos.add(y0);
                        }
                        y0 = this.downy(x0, y0);
                    }
                }
                ++i;
            }
            x0 = x;
            ymin = y - dist;
            ymax = y + dist;
            i = 1;
            while (i <= dist) {
                temp_ymin = ymin;
                ymin = this.dry(x0, ymin);
                ymax = this.ury(x0, ymax);
                x0 = this.drx(x0, temp_ymin);
                ylBound = ymin >= 0 || !bounded ? ymin : 0;
                int n = yuBound = ymax < height || !bounded ? ymax : height - 1;
                if (x0 < width) {
                    y0 = ymin;
                    while (y0 <= yuBound) {
                        if (y0 >= 0 || !bounded) {
                            xPos.add(x0);
                            yPos.add(y0);
                        }
                        y0 = this.downy(x0, y0);
                    }
                }
                ++i;
            }
            if (!includeOrigin) {
                this.removeOrigin(x, y, xPos, yPos);
            }
        }
    }

    public Bag getNeighborsMaxDistance(int x, int y, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos) {
        return this.getMooreNeighbors(x, y, dist, toroidal ? 2 : 0, result, xPos, yPos);
    }

    public Bag getMooreNeighbors(int x, int y, int dist, int mode, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getMooreLocations(x, y, dist, mode, true, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public Bag getNeighborsAndCorrespondingLocationsMaxDistance(int x, int y, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos) {
        return this.getMooreNeighborsAndLocations(x, y, dist, toroidal ? 2 : 0, result, xPos, yPos);
    }

    public Bag getMooreNeighborsAndLocations(int x, int y, int dist, int mode, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getMooreLocations(x, y, dist, mode, true, xPos, yPos);
        this.reduceObjectsAtLocations(xPos, yPos, result);
        return result;
    }

    public Bag getNeighborsHamiltonianDistance(int x, int y, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos) {
        return this.getVonNeumannNeighbors(x, y, dist, toroidal ? 2 : 0, result, xPos, yPos);
    }

    public Bag getVonNeumannNeighbors(int x, int y, int dist, int mode, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getVonNeumannLocations(x, y, dist, mode, true, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public Bag getNeighborsAndCorrespondingPositionsHamiltonianDistance(int x, int y, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos) {
        return this.getVonNeumannNeighborsAndLocations(x, y, dist, toroidal ? 2 : 0, result, xPos, yPos);
    }

    public Bag getVonNeumannNeighborsAndLocations(int x, int y, int dist, int mode, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getVonNeumannLocations(x, y, dist, mode, true, xPos, yPos);
        this.reduceObjectsAtLocations(xPos, yPos, result);
        return result;
    }

    public Bag getNeighborsHexagonalDistance(int x, int y, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos) {
        return this.getHexagonalNeighbors(x, y, dist, toroidal ? 2 : 0, result, xPos, yPos);
    }

    public Bag getHexagonalNeighbors(int x, int y, int dist, int mode, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getHexagonalLocations(x, y, dist, mode, true, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public Bag getNeighborsAndCorrespondingPositionsHexagonalDistance(int x, int y, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos) {
        return this.getHexagonalNeighborsAndLocations(x, y, dist, toroidal ? 2 : 0, result, xPos, yPos);
    }

    public Bag getHexagonalNeighborsAndLocations(int x, int y, int dist, int mode, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getHexagonalLocations(x, y, dist, mode, true, xPos, yPos);
        this.reduceObjectsAtLocations(xPos, yPos, result);
        return result;
    }

    void reduceObjectsAtLocations(IntBag xPos, IntBag yPos, Bag result) {
        if (result == null) {
            result = new Bag();
        } else {
            result.clear();
        }
        IntBag newXPos = new IntBag();
        IntBag newYPos = new IntBag();
        int len = xPos.numObjs;
        int[] xs = xPos.objs;
        int[] ys = yPos.objs;
        int i = 0;
        while (i < len) {
            Bag temp = this.getObjectsAtLocation(xs[i], ys[i]);
            if (temp != null) {
                int size = temp.numObjs;
                Object[] os = temp.objs;
                int j = 0;
                while (j < size) {
                    result.add(os[j]);
                    newXPos.add(xs[i]);
                    newYPos.add(ys[i]);
                    ++j;
                }
            }
            ++i;
        }
        xPos.clear();
        xPos.addAll(newXPos);
        yPos.clear();
        yPos.addAll(newYPos);
    }

    Bag getObjectsAtLocations(IntBag xPos, IntBag yPos, Bag result) {
        if (result == null) {
            result = new Bag();
        } else {
            result.clear();
        }
        int len = xPos.numObjs;
        int[] xs = xPos.objs;
        int[] ys = yPos.objs;
        int i = 0;
        while (i < len) {
            Bag temp = this.getObjectsAtLocation(xs[i], ys[i]);
            if (temp != null) {
                int n = temp.numObjs;
                if (n == 1) {
                    result.add(temp.objs[0]);
                } else if (n > 1) {
                    result.addAll(temp);
                }
            }
            ++i;
        }
        return result;
    }

    double ds(double d1x, double d1y, double d2x, double d2y) {
        return (d1x - d2x) * (d1x - d2x) + (d1y - d2y) * (d1y - d2y);
    }

    boolean within(double d1x, double d1y, double d2x, double d2y, double distanceSquared, boolean closed) {
        double d = this.ds(d1x, d1y, d2x, d2y);
        return d < distanceSquared || d == distanceSquared && closed;
    }

    @Override
    public void getRadialLocations(int x, int y, double dist, int mode, boolean includeOrigin, IntBag xPos, IntBag yPos) {
        this.getRadialLocations(x, y, dist, mode, includeOrigin, 1026, true, xPos, yPos);
    }

    @Override
    public void getRadialLocations(int x, int y, double dist, int mode, boolean includeOrigin, int measurementRule, boolean closed, IntBag xPos, IntBag yPos) {
        boolean toroidal;
        boolean bl = toroidal = mode == 2;
        if (dist < 0.0) {
            throw new RuntimeException("Distance must be positive");
        }
        if (measurementRule != 1026 && measurementRule != 1025 && measurementRule != 1024) {
            throw new RuntimeException(" Measurement rule must be one of ANY, ALL, or CENTER");
        }
        if (toroidal) {
            this.getMooreLocations(x, y, (int)Math.ceil(dist + 0.5), 1, includeOrigin, xPos, yPos);
        } else {
            this.getMooreLocations(x, y, (int)Math.ceil(dist + 0.5), mode, includeOrigin, xPos, yPos);
        }
        int len = xPos.size();
        double distsq = dist * dist;
        int width = this.width;
        int height = this.height;
        int widthtimestwo = width * 2;
        int heighttimestwo = height * 2;
        int i = 0;
        while (i < len) {
            int xp = xPos.get(i);
            int yp = yPos.get(i);
            boolean remove = false;
            if (measurementRule == 1026) {
                if (x == xp) {
                    double d;
                    remove = y < yp ? !((d = (double)yp - 0.5 - (double)y) < dist || d == dist && closed) : !((d = -((double)yp - 0.5 - (double)y)) < dist || d == dist && closed);
                } else if (y == yp) {
                    if (x < xp) {
                        double d = (double)xp - 0.5 - (double)x;
                        remove = !(d < dist || d == dist && closed);
                    } else {
                        double d = -((double)xp - 0.5 - (double)x);
                        boolean bl2 = remove = !(d < dist || d == dist && closed);
                    }
                }
                remove = x < xp ? (y < yp ? !this.within(x, y, (double)xp - 0.5, (double)yp - 0.5, distsq, closed) : !this.within(x, y, (double)xp - 0.5, (double)yp + 0.5, distsq, closed)) : (y < yp ? !this.within(x, y, (double)xp + 0.5, (double)yp - 0.5, distsq, closed) : !this.within(x, y, (double)xp + 0.5, (double)yp + 0.5, distsq, closed));
            } else if (measurementRule == 1025) {
                remove = x < xp ? (y < yp ? !this.within(x, y, (double)xp + 0.5, (double)yp + 0.5, distsq, closed) : !this.within(x, y, (double)xp + 0.5, (double)yp - 0.5, distsq, closed)) : (y < yp ? !this.within(x, y, (double)xp - 0.5, (double)yp + 0.5, distsq, closed) : !this.within(x, y, (double)xp - 0.5, (double)yp - 0.5, distsq, closed));
            } else {
                boolean bl3 = remove = !this.within(x, y, xp, yp, distsq, closed);
            }
            if (remove) {
                xPos.remove(i);
                yPos.remove(i);
                --i;
                --len;
            } else if (toroidal) {
                int _x = xPos.get(i);
                int _y = yPos.get(i);
                xPos.set(i, this.tx(_x, width, widthtimestwo, _x + width, _x - width));
                yPos.set(i, this.tx(_y, height, heighttimestwo, _y + width, _y - width));
            }
            ++i;
        }
    }

    public Bag getRadialNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos) {
        return this.getRadialNeighbors(x, y, dist, mode, includeOrigin, 1026, true, result, xPos, yPos);
    }

    public Bag getRadialNeighborsAndLocations(int x, int y, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos) {
        return this.getRadialNeighborsAndLocations(x, y, dist, mode, includeOrigin, 1026, true, result, xPos, yPos);
    }

    public Bag getRadialNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, int measurementRule, boolean closed, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getRadialLocations(x, y, dist, mode, includeOrigin, measurementRule, closed, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public Bag getRadialNeighborsAndLocations(int x, int y, int dist, int mode, boolean includeOrigin, int measurementRule, boolean closed, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getRadialLocations(x, y, dist, mode, includeOrigin, measurementRule, closed, xPos, yPos);
        this.reduceObjectsAtLocations(xPos, yPos, result);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    @Override
    public final Double2D getDimensions() {
        return new Double2D(this.width, this.height);
    }
}

