/*
 * Decompiled with CFR 0.152.
 */
package sim.field.grid;

import sim.field.grid.AbstractGrid2D;
import sim.util.Bag;
import sim.util.Int2D;
import sim.util.IntBag;
import sim.util.LocationLog;

public class ObjectGrid2D
extends AbstractGrid2D {
    private static final long serialVersionUID = 1L;
    public Object[][] field;

    public ObjectGrid2D(int width, int height) {
        this.width = width;
        this.height = height;
        this.field = new Object[width][height];
    }

    public ObjectGrid2D(int width, int height, Object initialValue) {
        this(width, height);
        this.setTo(initialValue);
    }

    public ObjectGrid2D(ObjectGrid2D values) {
        this.setTo(values);
    }

    public ObjectGrid2D(Object[][] values) {
        this.setTo(values);
    }

    public final void set(int x, int y, Object val) {
        assert (LocationLog.it(this, new Int2D(x, y)));
        this.field[x][y] = val;
    }

    public final Object get(int x, int y) {
        assert (LocationLog.it(this, new Int2D(x, y)));
        return this.field[x][y];
    }

    public final ObjectGrid2D setTo(Object thisObj) {
        Object[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                fieldx[y] = thisObj;
                ++y;
            }
            ++x;
        }
        return this;
    }

    public ObjectGrid2D setTo(Object[][] field) {
        if (field == null) {
            throw new RuntimeException("ObjectGrid2D set to null field.");
        }
        int w = field.length;
        int h = 0;
        if (w != 0) {
            h = field[0].length;
        }
        int i = 0;
        while (i < w) {
            if (field[i].length != h) {
                throw new RuntimeException("ObjectGrid2D initialized with a non-rectangular field.");
            }
            ++i;
        }
        this.field = new Object[w][h];
        i = 0;
        while (i < this.width) {
            this.field[i] = (Object[])field[i].clone();
            ++i;
        }
        this.width = w;
        this.height = h;
        return this;
    }

    public final Object[] toArray() {
        Object[][] field = this.field;
        Object[] fieldx = null;
        int width = this.width;
        int height = this.height;
        Object[] vals = new Object[width * height];
        int i = 0;
        int x = 0;
        while (x < width) {
            fieldx = field[x];
            int y = 0;
            while (y < height) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                vals[i++] = fieldx[y];
                ++y;
            }
            ++x;
        }
        return vals;
    }

    public final Bag elements() {
        Bag bag = new Bag();
        Object[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                if (fieldx[y] != null) {
                    assert (LocationLog.it(this, new Int2D(x, y)));
                    bag.add(fieldx[y]);
                }
                ++y;
            }
            ++x;
        }
        return bag;
    }

    public final Bag clear() {
        Bag bag = new Bag();
        Object[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                if (fieldx[y] != null) {
                    bag.add(fieldx[y]);
                }
                fieldx[y] = null;
                ++y;
            }
            ++x;
        }
        return bag;
    }

    public final ObjectGrid2D setTo(ObjectGrid2D values) {
        if (LocationLog.assertsEnabled) {
            int x = 0;
            while (x < values.width) {
                int y = 0;
                while (y < values.height) {
                    assert (LocationLog.it(this, new Int2D(x, y)));
                    ++y;
                }
                ++x;
            }
        }
        if (this.width != values.width || this.height != values.height) {
            int width = this.width = values.width;
            this.height = values.height;
            this.field = new Object[width][];
            Object[][] field = this.field;
            Object[][] ofield = values.field;
            int x = 0;
            while (x < width) {
                field[x] = (Object[])ofield[x].clone();
                ++x;
            }
        } else {
            Object[][] field = this.field;
            Object[][] ofield = values.field;
            int x = 0;
            while (x < this.width) {
                System.arraycopy(ofield[x], 0, field[x], 0, this.height);
                ++x;
            }
        }
        return this;
    }

    public Bag getNeighborsMaxDistance(int x, int y, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos) {
        return this.getMooreNeighbors(x, y, dist, toroidal ? 2 : 0, true, result, xPos, yPos);
    }

    public Bag getMooreNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getMooreLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public Bag getMooreNeighborsAndLocations(int x, int y, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getMooreLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        this.reduceObjectsAtLocations(xPos, yPos, result);
        return result;
    }

    public Bag getNeighborsHamiltonianDistance(int x, int y, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos) {
        return this.getVonNeumannNeighbors(x, y, dist, toroidal ? 2 : 0, true, result, xPos, yPos);
    }

    public Bag getVonNeumannNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getVonNeumannLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public Bag getVonNeumannNeighborsAndLocations(int x, int y, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getVonNeumannLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        this.reduceObjectsAtLocations(xPos, yPos, result);
        return result;
    }

    public Bag getNeighborsHexagonalDistance(int x, int y, int dist, boolean toroidal, Bag result, IntBag xPos, IntBag yPos) {
        return this.getHexagonalNeighbors(x, y, dist, toroidal ? 2 : 0, true, result, xPos, yPos);
    }

    public Bag getHexagonalNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getHexagonalLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public Bag getHexagonalNeighborsAndLocations(int x, int y, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getHexagonalLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        this.reduceObjectsAtLocations(xPos, yPos, result);
        return result;
    }

    public Bag getRadialNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos) {
        return this.getRadialNeighbors(x, y, dist, mode, includeOrigin, 1026, true, result, xPos, yPos);
    }

    public Bag getRadialNeighborsAndLocations(int x, int y, int dist, int mode, boolean includeOrigin, Bag result, IntBag xPos, IntBag yPos) {
        return this.getRadialNeighborsAndLocations(x, y, dist, mode, includeOrigin, 1026, true, result, xPos, yPos);
    }

    public Bag getRadialNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, int measurementRule, boolean closed, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getRadialLocations(x, y, dist, mode, includeOrigin, measurementRule, closed, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public Bag getRadialNeighborsAndLocations(int x, int y, int dist, int mode, boolean includeOrigin, int measurementRule, boolean closed, Bag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getRadialLocations(x, y, dist, mode, includeOrigin, measurementRule, closed, xPos, yPos);
        this.reduceObjectsAtLocations(xPos, yPos, result);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    void reduceObjectsAtLocations(IntBag xPos, IntBag yPos, Bag result) {
        if (result == null) {
            result = new Bag();
        } else {
            result.clear();
        }
        int i = 0;
        while (i < xPos.numObjs) {
            assert (LocationLog.it(this, new Int2D(xPos.objs[i], yPos.objs[i])));
            Object val = this.field[xPos.objs[i]][yPos.objs[i]];
            if (val != null) {
                result.add(val);
            } else {
                xPos.remove(i);
                yPos.remove(i);
                --i;
            }
            ++i;
        }
    }

    Bag getObjectsAtLocations(IntBag xPos, IntBag yPos, Bag result) {
        if (result == null) {
            result = new Bag();
        } else {
            result.clear();
        }
        int i = 0;
        while (i < xPos.numObjs) {
            assert (LocationLog.it(this, new Int2D(xPos.objs[i], yPos.objs[i])));
            Object val = this.field[xPos.objs[i]][yPos.objs[i]];
            if (val != null) {
                result.add(val);
            }
            ++i;
        }
        return result;
    }
}

