/*
 * Decompiled with CFR 0.152.
 */
package sim.field.grid;

import sim.field.grid.AbstractGrid2D;
import sim.util.Int2D;
import sim.util.IntBag;
import sim.util.LocationLog;

public class IntGrid2D
extends AbstractGrid2D {
    private static final long serialVersionUID = 1L;
    public int[][] field;

    public IntGrid2D(int width, int height) {
        this.width = width;
        this.height = height;
        this.field = new int[width][height];
    }

    public IntGrid2D(int width, int height, int initialValue) {
        this(width, height);
        this.setTo(initialValue);
    }

    public IntGrid2D(IntGrid2D values) {
        this.setTo(values);
    }

    public IntGrid2D(int[][] values) {
        this.setTo(values);
    }

    public final void set(int x, int y, int val) {
        assert (LocationLog.it(this, new Int2D(x, y)));
        this.field[x][y] = val;
    }

    public final int get(int x, int y) {
        assert (LocationLog.it(this, new Int2D(x, y)));
        return this.field[x][y];
    }

    public final IntGrid2D setTo(int thisMuch) {
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                fieldx[y] = thisMuch;
                ++y;
            }
            ++x;
        }
        return this;
    }

    public IntGrid2D setTo(int[][] field) {
        if (field == null) {
            throw new RuntimeException("IntGrid2D set to null field.");
        }
        int w = field.length;
        int h = 0;
        if (w != 0) {
            h = field[0].length;
        }
        int i = 0;
        while (i < w) {
            if (field[i].length != h) {
                throw new RuntimeException("IntGrid2D initialized with a non-rectangular field.");
            }
            ++i;
        }
        this.field = new int[w][h];
        i = 0;
        while (i < w) {
            this.field[i] = (int[])field[i].clone();
            ++i;
        }
        this.width = w;
        this.height = h;
        return this;
    }

    public final IntGrid2D setTo(IntGrid2D values) {
        int x;
        if (LocationLog.assertsEnabled) {
            x = 0;
            while (x < values.width) {
                int y = 0;
                while (y < values.height) {
                    assert (LocationLog.it(this, new Int2D(x, y)));
                    ++y;
                }
                ++x;
            }
        }
        if (this.width != values.width || this.height != values.height) {
            int width = this.width = values.width;
            this.height = values.height;
            int[][] nArrayArray = new int[width][];
            this.field = nArrayArray;
            int[][] field = nArrayArray;
            int x2 = 0;
            while (x2 < width) {
                field[x2] = (int[])values.field[x2].clone();
                ++x2;
            }
        } else {
            x = 0;
            while (x < this.width) {
                System.arraycopy(values.field[x], 0, this.field[x], 0, this.height);
                ++x;
            }
        }
        return this;
    }

    public final int[] toArray() {
        int[][] field = this.field;
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int[] vals = new int[width * height];
        int i = 0;
        int x = 0;
        while (x < width) {
            fieldx = field[x];
            int y = 0;
            while (y < height) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                vals[i++] = fieldx[y];
                ++y;
            }
            ++x;
        }
        return vals;
    }

    public final int max() {
        int max = Integer.MIN_VALUE;
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                if (max < fieldx[y]) {
                    max = fieldx[y];
                }
                ++y;
            }
            ++x;
        }
        return max;
    }

    public final int min() {
        int min = Integer.MAX_VALUE;
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                if (min > fieldx[y]) {
                    min = fieldx[y];
                }
                ++y;
            }
            ++x;
        }
        return min;
    }

    public final double mean() {
        long count = 0L;
        double mean = 0.0;
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                mean += (double)fieldx[y];
                ++count;
                ++y;
            }
            ++x;
        }
        return count == 0L ? 0.0 : mean / (double)count;
    }

    public final IntGrid2D upperBound(int toNoMoreThanThisMuch) {
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                if (fieldx[y] > toNoMoreThanThisMuch) {
                    fieldx[y] = toNoMoreThanThisMuch;
                }
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final IntGrid2D lowerBound(int toNoLowerThanThisMuch) {
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                if (fieldx[y] < toNoLowerThanThisMuch) {
                    fieldx[y] = toNoLowerThanThisMuch;
                }
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final IntGrid2D add(int withThisMuch) {
        if ((double)withThisMuch == 0.0) {
            return this;
        }
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                int n = y++;
                fieldx[n] = fieldx[n] + withThisMuch;
            }
            ++x;
        }
        return this;
    }

    public final IntGrid2D add(IntGrid2D withThis) {
        int[][] ofield = withThis.field;
        int[] ofieldx = null;
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            ofieldx = ofield[x];
            int y = 0;
            while (y < height) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                int n = y;
                fieldx[n] = fieldx[n] + ofieldx[y];
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final IntGrid2D multiply(int byThisMuch) {
        if ((double)byThisMuch == 1.0) {
            return this;
        }
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                int n = y++;
                fieldx[n] = fieldx[n] * byThisMuch;
            }
            ++x;
        }
        return this;
    }

    public final IntGrid2D multiply(IntGrid2D withThis) {
        int[][] ofield = withThis.field;
        int[] ofieldx = null;
        int[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            ofieldx = ofield[x];
            int y = 0;
            while (y < height) {
                assert (LocationLog.it(this, new Int2D(x, y)));
                int n = y;
                fieldx[n] = fieldx[n] * ofieldx[y];
                ++y;
            }
            ++x;
        }
        return this;
    }

    public void getNeighborsMaxDistance(int x, int y, int dist, boolean toroidal, IntBag result, IntBag xPos, IntBag yPos) {
        this.getMooreNeighbors(x, y, dist, toroidal ? 2 : 0, true, result, xPos, yPos);
    }

    public IntBag getMooreNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, IntBag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getMooreLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public void getNeighborsHamiltonianDistance(int x, int y, int dist, boolean toroidal, IntBag result, IntBag xPos, IntBag yPos) {
        this.getVonNeumannNeighbors(x, y, dist, toroidal ? 2 : 0, true, result, xPos, yPos);
    }

    public IntBag getVonNeumannNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, IntBag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getVonNeumannLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public void getNeighborsHexagonalDistance(int x, int y, int dist, boolean toroidal, IntBag result, IntBag xPos, IntBag yPos) {
        this.getHexagonalNeighbors(x, y, dist, toroidal ? 2 : 0, true, result, xPos, yPos);
    }

    public IntBag getHexagonalNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, IntBag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getHexagonalLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public IntBag getRadialNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, IntBag result, IntBag xPos, IntBag yPos) {
        return this.getRadialNeighbors(x, y, dist, mode, includeOrigin, result, xPos, yPos);
    }

    public IntBag getRadialNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, int measurementRule, boolean closed, IntBag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getRadialLocations(x, y, dist, mode, includeOrigin, measurementRule, closed, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    void reduceObjectsAtLocations(IntBag xPos, IntBag yPos, IntBag result) {
        if (result == null) {
            result = new IntBag();
        } else {
            result.clear();
        }
        int i = 0;
        while (i < xPos.numObjs) {
            assert (LocationLog.it(this, new Int2D(xPos.objs[i], yPos.objs[i])));
            int val = this.field[xPos.objs[i]][yPos.objs[i]];
            result.add(val);
            ++i;
        }
    }

    IntBag getObjectsAtLocations(IntBag xPos, IntBag yPos, IntBag result) {
        if (result == null) {
            result = new IntBag();
        } else {
            result.clear();
        }
        int i = 0;
        while (i < xPos.numObjs) {
            assert (LocationLog.it(this, new Int2D(xPos.objs[i], yPos.objs[i])));
            int val = this.field[xPos.objs[i]][yPos.objs[i]];
            result.add(val);
            ++i;
        }
        return result;
    }
}

