/*
 * Decompiled with CFR 0.152.
 */
package sim.field.grid;

import sim.field.grid.AbstractGrid2D;
import sim.field.grid.IntGrid2D;
import sim.util.DoubleBag;
import sim.util.Int2D;
import sim.util.IntBag;
import sim.util.LocationLog;

public class DoubleGrid2D
extends AbstractGrid2D {
    private static final long serialVersionUID = 1L;
    public double[][] field;

    public double[][] getField() {
        return this.field;
    }

    public DoubleGrid2D(int width, int height) {
        this.width = width;
        this.height = height;
        this.field = new double[width][height];
    }

    public DoubleGrid2D(int width, int height, double initialValue) {
        this(width, height);
        this.setTo(initialValue);
    }

    public DoubleGrid2D(DoubleGrid2D values) {
        this.setTo(values);
    }

    public DoubleGrid2D(double[][] values) {
        this.setTo(values);
    }

    public final void set(int x, int y, double val) {
        this.field[x][y] = val;
    }

    public final double get(int x, int y) {
        return this.field[x][y];
    }

    public final DoubleGrid2D setTo(double thisMuch) {
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                fieldx[y] = thisMuch;
                ++y;
            }
            ++x;
        }
        return this;
    }

    public DoubleGrid2D setTo(double[][] field) {
        if (field == null) {
            throw new RuntimeException("DoubleGrid2D set to null field.");
        }
        int w = field.length;
        int h = 0;
        if (w != 0) {
            h = field[0].length;
        }
        int i = 0;
        while (i < w) {
            if (field[i].length != h) {
                throw new RuntimeException("DoubleGrid2D initialized with a non-rectangular field.");
            }
            ++i;
        }
        this.field = new double[w][h];
        i = 0;
        while (i < this.width) {
            this.field[i] = (double[])field[i].clone();
            ++i;
        }
        this.width = w;
        this.height = h;
        return this;
    }

    public final DoubleGrid2D setTo(DoubleGrid2D values) {
        if (this.width != values.width || this.height != values.height) {
            int width = this.width = values.width;
            this.height = values.height;
            this.field = new double[width][];
            int x = 0;
            while (x < width) {
                this.field[x] = (double[])values.field[x].clone();
                ++x;
            }
        } else {
            int x = 0;
            while (x < this.width) {
                System.arraycopy(values.field[x], 0, this.field[x], 0, this.height);
                ++x;
            }
        }
        return this;
    }

    public final double[] toArray() {
        double[][] field = this.field;
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        double[] vals = new double[width * height];
        int i = 0;
        int x = 0;
        while (x < width) {
            fieldx = field[x];
            int y = 0;
            while (y < height) {
                vals[i++] = fieldx[y];
                ++y;
            }
            ++x;
        }
        return vals;
    }

    public final double max() {
        double max = Double.NEGATIVE_INFINITY;
        int width = this.width;
        int height = this.height;
        double[] fieldx = null;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                if (max < fieldx[y]) {
                    max = fieldx[y];
                }
                ++y;
            }
            ++x;
        }
        return max;
    }

    public final double min() {
        double min = Double.POSITIVE_INFINITY;
        int width = this.width;
        int height = this.height;
        double[] fieldx = null;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                if (min > fieldx[y]) {
                    min = fieldx[y];
                }
                ++y;
            }
            ++x;
        }
        return min;
    }

    public final double mean() {
        long count = 0L;
        double mean = 0.0;
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                mean += fieldx[y];
                ++count;
                ++y;
            }
            ++x;
        }
        return count == 0L ? 0.0 : mean / (double)count;
    }

    public final DoubleGrid2D upperBound(double toNoMoreThanThisMuch) {
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                if (fieldx[y] > toNoMoreThanThisMuch) {
                    fieldx[y] = toNoMoreThanThisMuch;
                }
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final DoubleGrid2D lowerBound(double toNoLowerThanThisMuch) {
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                if (fieldx[y] < toNoLowerThanThisMuch) {
                    fieldx[y] = toNoLowerThanThisMuch;
                }
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final DoubleGrid2D add(double withThisMuch) {
        int width = this.width;
        int height = this.height;
        if (withThisMuch == 0.0) {
            return this;
        }
        double[] fieldx = null;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                int n = y++;
                fieldx[n] = fieldx[n] + withThisMuch;
            }
            ++x;
        }
        return this;
    }

    public final DoubleGrid2D add(IntGrid2D withThis) {
        int[][] otherField = withThis.field;
        double[] fieldx = null;
        int[] ofieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            int y = 0;
            while (y < height) {
                int n = y;
                fieldx[n] = fieldx[n] + (double)ofieldx[y];
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final DoubleGrid2D add(DoubleGrid2D withThis) {
        double[][] otherField = withThis.field;
        double[] fieldx = null;
        double[] ofieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            int y = 0;
            while (y < height) {
                int n = y;
                fieldx[n] = fieldx[n] + ofieldx[y];
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final DoubleGrid2D multiply(double byThisMuch) {
        if (byThisMuch == 1.0) {
            return this;
        }
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                int n = y++;
                fieldx[n] = fieldx[n] * byThisMuch;
            }
            ++x;
        }
        return this;
    }

    public final DoubleGrid2D multiply(IntGrid2D withThis) {
        int[][] otherField = withThis.field;
        double[] fieldx = null;
        int[] ofieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            int y = 0;
            while (y < height) {
                int n = y;
                fieldx[n] = fieldx[n] * (double)ofieldx[y];
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final DoubleGrid2D multiply(DoubleGrid2D withThis) {
        double[][] otherField = withThis.field;
        double[] fieldx = null;
        double[] ofieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            ofieldx = otherField[x];
            int y = 0;
            while (y < height) {
                int n = y;
                fieldx[n] = fieldx[n] * ofieldx[y];
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final DoubleGrid2D floor() {
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                fieldx[y] = Math.floor(fieldx[y]);
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final DoubleGrid2D ceiling() {
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                fieldx[y] = Math.ceil(fieldx[y]);
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final DoubleGrid2D truncate() {
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                if (fieldx[y] > 0.0) {
                    Math.floor(fieldx[y]);
                } else {
                    Math.ceil(fieldx[y]);
                }
                ++y;
            }
            ++x;
        }
        return this;
    }

    public final DoubleGrid2D rint() {
        double[] fieldx = null;
        int width = this.width;
        int height = this.height;
        int x = 0;
        while (x < width) {
            fieldx = this.field[x];
            int y = 0;
            while (y < height) {
                fieldx[y] = Math.rint(fieldx[y]);
                ++y;
            }
            ++x;
        }
        return this;
    }

    public void getNeighborsMaxDistance(int x, int y, int dist, boolean toroidal, DoubleBag result, IntBag xPos, IntBag yPos) {
        this.getMooreNeighbors(x, y, dist, toroidal ? 2 : 0, true, result, xPos, yPos);
    }

    public DoubleBag getMooreNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, DoubleBag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getMooreLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public void getNeighborsHamiltonianDistance(int x, int y, int dist, boolean toroidal, DoubleBag result, IntBag xPos, IntBag yPos) {
        this.getVonNeumannNeighbors(x, y, dist, toroidal ? 2 : 0, true, result, xPos, yPos);
    }

    public DoubleBag getVonNeumannNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, DoubleBag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getVonNeumannLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public void getNeighborsHexagonalDistance(int x, int y, int dist, boolean toroidal, DoubleBag result, IntBag xPos, IntBag yPos) {
        this.getHexagonalNeighbors(x, y, dist, toroidal ? 2 : 0, true, result, xPos, yPos);
    }

    public DoubleBag getHexagonalNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, DoubleBag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getHexagonalLocations(x, y, dist, mode, includeOrigin, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    public DoubleBag getRadialNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, DoubleBag result, IntBag xPos, IntBag yPos) {
        return this.getRadialNeighbors(x, y, dist, mode, includeOrigin, result, xPos, yPos);
    }

    public DoubleBag getRadialNeighbors(int x, int y, int dist, int mode, boolean includeOrigin, int measurementRule, boolean closed, DoubleBag result, IntBag xPos, IntBag yPos) {
        if (xPos == null) {
            xPos = new IntBag();
        }
        if (yPos == null) {
            yPos = new IntBag();
        }
        this.getRadialLocations(x, y, dist, mode, includeOrigin, measurementRule, closed, xPos, yPos);
        return this.getObjectsAtLocations(xPos, yPos, result);
    }

    void reduceObjectsAtLocations(IntBag xPos, IntBag yPos, DoubleBag result) {
        if (result == null) {
            result = new DoubleBag();
        } else {
            result.clear();
        }
        int i = 0;
        while (i < xPos.numObjs) {
            assert (LocationLog.it(this, new Int2D(xPos.objs[i], yPos.objs[i])));
            double val = this.field[xPos.objs[i]][yPos.objs[i]];
            result.add(val);
            ++i;
        }
    }

    DoubleBag getObjectsAtLocations(IntBag xPos, IntBag yPos, DoubleBag result) {
        if (result == null) {
            result = new DoubleBag();
        } else {
            result.clear();
        }
        int i = 0;
        while (i < xPos.numObjs) {
            assert (LocationLog.it(this, new Int2D(xPos.objs[i], yPos.objs[i])));
            double val = this.field[xPos.objs[i]][yPos.objs[i]];
            result.add(val);
            ++i;
        }
        return result;
    }
}

