/*
 * Decompiled with CFR 0.152.
 */
package sim.field;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sim.util.Bag;
import sim.util.LocationLog;

public abstract class SparseField
implements Serializable {
    private static final long serialVersionUID = 1L;
    public boolean removeEmptyBags = true;
    public boolean replaceLargeBags = true;
    public static final int INITIAL_BAG_SIZE = 16;
    public static final int MIN_BAG_SIZE = 32;
    public static final int LARGE_BAG_RATIO = 4;
    public static final int REPLACEMENT_BAG_RATIO = 2;
    public Map locationAndIndexHash = this.buildMap(0);
    public Map objectHash = this.buildMap(0);
    public Bag allObjects = new Bag();
    public static final int ANY_SIZE = 0;

    public Map buildMap(Map other) {
        return new HashMap(other);
    }

    public Map buildMap(int size) {
        if (size <= 0) {
            return new HashMap();
        }
        return new HashMap(size);
    }

    protected SparseField() {
    }

    protected SparseField(SparseField other) {
        this.removeEmptyBags = other.removeEmptyBags;
        this.replaceLargeBags = other.replaceLargeBags;
        this.locationAndIndexHash = this.buildMap(other.locationAndIndexHash);
        this.objectHash = this.buildMap(other.objectHash);
        this.allObjects = new Bag(other.allObjects);
    }

    public int getObjectIndex(Object obj) {
        LocationAndIndex lai = (LocationAndIndex)this.locationAndIndexHash.get(obj);
        if (lai == null) {
            return -1;
        }
        return lai.index;
    }

    public boolean exists(Object obj) {
        return this.getRawObjectLocation(obj) != null;
    }

    public int size() {
        return this.allObjects.size();
    }

    protected final Object getRawObjectLocation(Object obj) {
        LocationAndIndex lai = (LocationAndIndex)this.locationAndIndexHash.get(obj);
        if (lai == null) {
            return null;
        }
        assert (LocationLog.it(this, lai.location));
        return lai.location;
    }

    public final int numObjectsAtLocation(Object location) {
        Bag b = (Bag)this.objectHash.get(location);
        if (b == null) {
            return 0;
        }
        assert (LocationLog.it(this, location));
        return b.numObjs;
    }

    public Bag getObjectsAtLocation(Object location) {
        return this.getRawObjectsAtLocation(location);
    }

    protected final Bag getRawObjectsAtLocation(Object location) {
        Bag b = (Bag)this.objectHash.get(location);
        if (b == null) {
            return null;
        }
        if (b.numObjs == 0) {
            return null;
        }
        assert (LocationLog.it(this, location));
        return b;
    }

    public Bag getObjectsAtLocationOfObject(Object obj) {
        LocationAndIndex lai = (LocationAndIndex)this.locationAndIndexHash.get(obj);
        if (lai == null) {
            return null;
        }
        assert (LocationLog.it(this, lai.location));
        return lai.otherObjectsAtLocation;
    }

    public int numObjectsAtLocationOfObject(Object obj) {
        LocationAndIndex lai = (LocationAndIndex)this.locationAndIndexHash.get(obj);
        if (lai == null) {
            return 0;
        }
        assert (LocationLog.it(this, lai.location));
        return lai.otherObjectsAtLocation.numObjs;
    }

    public Bag removeObjectsAtLocation(Object location) {
        Bag objs = (Bag)this.objectHash.remove(location);
        if (objs != null) {
            int j = 0;
            while (j < objs.numObjs) {
                LocationAndIndex lai = (LocationAndIndex)this.locationAndIndexHash.remove(objs.objs[j]);
                assert (LocationLog.it(this, lai.location));
                this.allObjects.remove(lai.index);
                if (this.allObjects.numObjs > lai.index) {
                    ((LocationAndIndex)this.locationAndIndexHash.get((Object)this.allObjects.objs[lai.index])).index = lai.index;
                }
                ++j;
            }
        }
        return objs;
    }

    public Bag clear() {
        this.locationAndIndexHash = this.buildMap(0);
        this.objectHash = this.buildMap(0);
        Bag retval = this.allObjects;
        this.allObjects = new Bag();
        return retval;
    }

    public Object remove(Object obj) {
        LocationAndIndex lai = (LocationAndIndex)this.locationAndIndexHash.remove(obj);
        if (lai != null) {
            Bag objs = (Bag)this.objectHash.get(lai.location);
            objs.remove(obj);
            int objsNumObjs = objs.numObjs;
            if (this.removeEmptyBags && objsNumObjs == 0) {
                this.objectHash.remove(lai.location);
            } else if (this.replaceLargeBags && objsNumObjs >= 32 && objsNumObjs * 4 <= objs.objs.length) {
                objs.shrink(objsNumObjs * 2);
            }
            this.allObjects.remove(lai.index);
            if (this.allObjects.numObjs > lai.index) {
                ((LocationAndIndex)this.locationAndIndexHash.get((Object)this.allObjects.objs[lai.index])).index = lai.index;
            }
            assert (LocationLog.it(this, lai.location));
            return lai.location;
        }
        return null;
    }

    protected boolean setObjectLocation(Object obj, Object location) {
        Bag objs;
        if (obj == null) {
            return false;
        }
        if (location == null) {
            return false;
        }
        Bag canUse = null;
        LocationAndIndex lai = (LocationAndIndex)this.locationAndIndexHash.get(obj);
        if (lai != null) {
            if (lai.location.equals(location)) {
                return true;
            }
            objs = lai.otherObjectsAtLocation;
            objs.remove(obj);
            int objsNumObjs = objs.numObjs;
            if (this.removeEmptyBags && objsNumObjs == 0) {
                this.objectHash.remove(lai.location);
                canUse = objs;
            } else if (this.replaceLargeBags && objsNumObjs >= 32 && objsNumObjs * 4 <= objs.objs.length) {
                objs.shrink(objsNumObjs * 2);
            }
            assert (LocationLog.it(this, lai.location));
            lai.location = location;
        } else {
            this.allObjects.add(obj);
            lai = new LocationAndIndex(location, this.allObjects.numObjs - 1);
            this.locationAndIndexHash.put(obj, lai);
        }
        assert (LocationLog.it(this, location));
        objs = (Bag)this.objectHash.get(location);
        if (objs == null) {
            if (canUse != null) {
                canUse.clear();
            } else {
                canUse = new Bag(16);
            }
            canUse.add(obj);
            objs = canUse;
            this.objectHash.put(location, objs);
        } else {
            objs.add(obj);
        }
        lai.otherObjectsAtLocation = objs;
        return true;
    }

    public final Bag getAllObjects() {
        return this.allObjects;
    }

    public Bag getObjectsAtLocations(Bag locations, Bag result) {
        if (result == null) {
            result = new Bag();
        }
        Object[] objs = locations.objs;
        int len = locations.numObjs;
        int i = 0;
        while (i < len) {
            Bag temp = this.getObjectsAtLocation(objs[i]);
            if (temp != null) {
                int n = temp.numObjs;
                if (n == 1) {
                    result.add(temp.objs[0]);
                } else {
                    result.addAll(temp);
                }
            }
            ++i;
        }
        return result;
    }

    public Iterator iterator() {
        final Iterator i = this.allObjects.iterator();
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            public Object next() {
                return i.next();
            }

            @Override
            public void remove() {
                throw new IllegalStateException("Remove not supported in SparseField.iterator()");
            }
        };
    }

    public Iterator locationBagIterator() {
        final Iterator i = this.objectHash.values().iterator();
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            public Object next() {
                return i.next();
            }

            @Override
            public void remove() {
                throw new IllegalStateException("Remove not supported in SparseField.iterator()");
            }
        };
    }

    public static class LocationAndIndex
    implements Serializable {
        Object location;
        int index;
        Bag otherObjectsAtLocation;

        public Object getLocation() {
            return this.location;
        }

        public int getIndex() {
            return this.index;
        }

        public LocationAndIndex(Object location, int index) {
            this.location = location;
            this.index = index;
        }
    }
}

