/*
 * Decompiled with CFR 0.152.
 */
package sim.display3d;

import com.sun.j3d.utils.behaviors.mouse.MouseBehavior;
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickIntersection;
import com.sun.j3d.utils.picking.PickResult;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.swing.SwingUtilities;
import javax.vecmath.Point3d;
import sim.display.GUIState;
import sim.display3d.Display3D;
import sim.portrayal.LocationWrapper;
import sim.portrayal3d.FieldPortrayal3D;
import sim.util.Bag;

public class SelectionBehavior
extends MouseBehavior {
    GUIState guiState = null;
    PickCanvas pickCanvas;
    BranchGroup r;
    boolean oneClick = true;
    boolean twoClicks = true;

    public void setTolerance(double tolerance) {
        this.pickCanvas.setTolerance((float)tolerance);
    }

    public void detach() {
        try {
            this.pickCanvas.getCanvas().removeMouseMotionListener((MouseMotionListener)((Object)this));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.pickCanvas.getCanvas().removeMouseListener((MouseListener)((Object)this));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SelectionBehavior(Canvas3D canvas, BranchGroup root, Bounds bounds, GUIState guiState) {
        super((Component)canvas, 0);
        this.pickCanvas = new PickCanvas(canvas, root);
        this.setTolerance(2.0);
        this.r = root;
        root.addChild((Node)this);
        this.pickCanvas.setMode(1024);
        this.guiState = guiState;
    }

    public void setSelectsAll(boolean selection, boolean inspection) {
        this.oneClick = selection;
        this.twoClicks = inspection;
    }

    public void processStimulus(Enumeration criteria) {
    }

    public void mouseClicked(MouseEvent evt) {
        if (!this.r.isLive()) {
            return;
        }
        int numClicks = evt.getClickCount();
        int xpos = evt.getPoint().x;
        int ypos = evt.getPoint().y;
        PickResult pickResult = null;
        PickResult[] pickResults = null;
        Shape3D shape = null;
        this.pickCanvas.setShapeLocation(xpos, ypos);
        Point3d eyePos = this.pickCanvas.getStartPosition();
        try {
            PickResult p;
            pickResults = numClicks == 1 && !this.oneClick ? ((p = this.pickCanvas.pickClosest()) != null ? new PickResult[]{p} : new PickResult[]{}) : (numClicks > 1 && !this.oneClick ? this.pickCanvas.pickAllSorted() : this.pickCanvas.pickAllSorted());
        }
        catch (CapabilityNotSetException e) {
            e.printStackTrace();
        }
        if (pickResults == null) {
            pickResults = new PickResult[]{};
        }
        LocationWrapper[] picks = new LocationWrapper[pickResults.length];
        final Bag inspectors = new Bag();
        Bag inspectorPortrayals = new Bag();
        Bag uniqueWrappers = new Bag();
        final Bag names = new Bag();
        int distinctObjectCount = 0;
        int i = 0;
        while (i < pickResults.length) {
            pickResult = pickResults[i];
            shape = (Shape3D)pickResult.getNode(1);
            LocationWrapper w = (LocationWrapper)shape.getUserData();
            if (w != null) {
                boolean duplicate = false;
                int j = 0;
                while (j < distinctObjectCount) {
                    if (w == picks[j]) {
                        duplicate = true;
                        break;
                    }
                    ++j;
                }
                if (!duplicate) {
                    PickIntersection pi;
                    picks[distinctObjectCount++] = w;
                    if (pickResult.numGeometryArrays() > 0 && (pi = pickResult.getClosestIntersection(eyePos)) != null) {
                        FieldPortrayal3D fPortrayal = (FieldPortrayal3D)w.getFieldPortrayal();
                        if (fPortrayal == null) {
                            System.err.println("WARNING: The value of a LocationWrapper.getFieldPortrayal() is null.\nLikely the wrapper was created from a SimplePortrayal3D whose field portrayal was not set before getModel(...) was called.");
                        } else {
                            LocationWrapper filledLW = fPortrayal.completedWrapper(w, pi, pickResult);
                            if (numClicks >= 1 && (this.oneClick || uniqueWrappers.size() == 0)) {
                                uniqueWrappers.add(filledLW);
                            }
                            if (numClicks >= 2 && (this.twoClicks || inspectors.size() == 0)) {
                                inspectors.add(fPortrayal.getInspector(filledLW, this.guiState));
                                inspectorPortrayals.add(fPortrayal);
                                names.add(fPortrayal.getName(filledLW));
                            }
                        }
                    }
                }
            }
            ++i;
        }
        if (numClicks >= 1) {
            ((Display3D)this.pickCanvas.getCanvas().getParent()).performSelection(uniqueWrappers);
        }
        final GUIState g = this.guiState;
        if (distinctObjectCount != 0 && numClicks >= 2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    g.controller.setInspectors(inspectors, names);
                }
            });
        }
    }
}

