/*
 * Decompiled with CFR 0.152.
 */
package sim.display;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessControlException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.display.Prefs;
import sim.display.SimApplet;
import sim.display.SimpleController;
import sim.engine.Schedule;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.engine.Stoppable;
import sim.portrayal.Inspector;
import sim.util.Bag;
import sim.util.gui.AbstractScrollable;
import sim.util.gui.HTMLBrowser;
import sim.util.gui.LabelledList;
import sim.util.gui.PropertyField;
import sim.util.gui.Utilities;

public class Console
extends JFrame
implements Controller {
    public static final int DEFAULT_WIDTH = 380;
    public static final int DEFAULT_HEIGHT = 380;
    public static final int DEFAULT_GUTTER = 5;
    public static final int MAXIMUM_STEPS = 20;
    GUIState simulation;
    static Vector classNames = new Vector();
    static Vector shortNames = new Vector();
    static boolean allowOtherClassNames;
    boolean newMenuAllowed = true;
    int preferredInspectorIndex = 0;
    static final ImageIcon I_PLAY_ON;
    static final ImageIcon I_PLAY_OFF;
    static final ImageIcon I_STOP_ON;
    static final ImageIcon I_STOP_OFF;
    static final ImageIcon I_PAUSE_ON;
    static final ImageIcon I_PAUSE_OFF;
    static final ImageIcon I_STEP_ON;
    static final ImageIcon I_STEP_OFF;
    JComponent infoPanel;
    JLabel time;
    JSlider slider;
    JLabel sliderText;
    JSlider stepSlider;
    JLabel stepSliderText;
    JCheckBox repeatButton;
    JButton stopButton;
    JButton playButton;
    JButton pauseButton;
    JTabbedPane tabPane;
    JList frameListDisplay;
    Vector frameList;
    PropertyField endField;
    PropertyField pauseField;
    PropertyField timeEndField;
    PropertyField timePauseField;
    PropertyField randomField;
    JMenuBar menuBar;
    JMenuItem newMenu;
    JSplitPane innerInspectorPanel;
    JPanel inspectorPanel;
    JCheckBox incrementSeedOnStop;
    JList inspectorList;
    JPanel inspectorSwitcher;
    CardLayout inspectorCardLayout;
    JButton detatchButton;
    JButton removeButton;
    Inspector modelInspector;
    JScrollPane modelInspectorScrollPane;
    Box buttonBox;
    JComboBox timeBox;
    long randomSeed = 0L;
    int numStepsPerStepButtonPress = 1;
    static final String DEFAULT_PREFERENCES_KEY = "Console";
    static final String DELAY_KEY = "Delay";
    static final String STEPS_KEY = "Steps";
    static final String AUTOMATIC_STOP_STEPS_KEY = "Automatically Stop at Step";
    static final String AUTOMATIC_STOP_TIME_KEY = "Automatically Stop after Time";
    static final String AUTOMATIC_PAUSE_STEPS_KEY = "Automatically Pause at Step";
    static final String AUTOMATIC_PAUSE_TIME_KEY = "Automatically Pause after Time";
    static final String INCREMENT_KEY = "Increment";
    static final String REPEAT_KEY = "Repeat";
    boolean shouldRepeat = false;
    int threadPriority = 5;
    long whenShouldEnd = Long.MAX_VALUE;
    long whenShouldPause = Long.MAX_VALUE;
    double whenShouldEndTime = Double.POSITIVE_INFINITY;
    double whenShouldPauseTime = Double.POSITIVE_INFINITY;
    long playSleep = 0L;
    Thread playThread;
    final Object playThreadLock = new Object();
    boolean threadShouldStop = false;
    public static final int PS_STOPPED = 0;
    public static final int PS_PLAYING = 1;
    public static final int PS_PAUSED = 2;
    int playState = 0;
    static boolean isQuitting;
    static final Object isQuittingLock;
    public static WeakHashMap allControllers;
    boolean isClosing = false;
    final Object isClosingLock = new Object();
    static boolean sacrificial;
    static JFrame aboutFrame;
    static Object classLock;
    static boolean classListLoaded;
    public static final String ONLY_INDICATOR = "ONLY";
    public static final String NAME_INDICATOR = "NAME:";
    File simulationFile = null;
    boolean requiresConfirmationToStop = false;
    double lastTime = -1.0;
    double lastRate = 0.0;
    long lastSteps = 0L;
    static final int SHOWING_TIME = 0;
    static final int SHOWING_STEPS = 1;
    static final int SHOWING_TPS = 2;
    static final int SHOWING_NOTHING = -1;
    int showing = 0;
    NumberFormat rateFormat;
    String lastText = null;
    Runnable blocker = new Runnable(){

        @Override
        public void run() {
        }
    };
    Vector inspectorNames = new Vector();
    Vector inspectorStoppables = new Vector();
    Vector inspectorToolbars = new Vector();
    WeakHashMap allInspectors = new WeakHashMap();

    static {
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        try {
            System.setProperty("Quaqua.TabbedPane.design", "auto");
            System.setProperty("Quaqua.visualMargin", "1,1,1,1");
            UIManager.put("Panel.opaque", Boolean.TRUE);
            UIManager.setLookAndFeel((String)Class.forName("ch.randelshofer.quaqua.QuaquaManager").getMethod("getLookAndFeelClassName", null).invoke(null, null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            System.setProperty("com.apple.hwaccel", "true");
            System.setProperty("apple.awt.graphics.UseQuartz", "true");
            System.setProperty("apple.awt.showGrowBox", "true");
            System.setProperty("com.apple.macos.use-file-dialog-packages", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        I_PLAY_ON = Console.iconFor("Playing.png");
        I_PLAY_OFF = Console.iconFor("NotPlaying.png");
        I_STOP_ON = Console.iconFor("Stopped.png");
        I_STOP_OFF = Console.iconFor("NotStopped.png");
        I_PAUSE_ON = Console.iconFor("PauseOn.png");
        I_PAUSE_OFF = Console.iconFor("PauseOff.png");
        I_STEP_ON = Console.iconFor("StepOn.png");
        I_STEP_OFF = Console.iconFor("StepOff.png");
        isQuitting = false;
        isQuittingLock = new Object();
        allControllers = new WeakHashMap();
        aboutFrame = null;
        classLock = new Object();
        classListLoaded = false;
    }

    public GUIState getSimulation() {
        return this.simulation;
    }

    public void setNewMenuAllowed(boolean val) {
        this.newMenuAllowed = val;
        if (!this.newMenuAllowed || classNames.size() == 0) {
            this.newMenu.setEnabled(false);
        }
    }

    public boolean isNewMenuAllowed() {
        return this.newMenuAllowed;
    }

    static ImageIcon iconFor(String name) {
        return new ImageIcon(Console.class.getResource(name));
    }

    public Console(final GUIState simulation) {
        super(GUIState.getName(simulation.getClass()));
        Color transparentBackground = new JPanel().getBackground();
        this.simulation = simulation;
        this.randomSeed = simulation.state.seed();
        this.rateFormat = NumberFormat.getInstance();
        this.rateFormat.setMaximumFractionDigits(3);
        this.rateFormat.setMinimumIntegerDigits(1);
        this.buttonBox = new Box(0);
        this.playButton = new JButton(I_PLAY_OFF);
        this.playButton.setPressedIcon(I_PLAY_ON);
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.pressPlay();
            }
        });
        this.playButton.setBorderPainted(false);
        this.playButton.setContentAreaFilled(false);
        this.playButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.buttonBox.add(this.playButton);
        this.pauseButton = new JButton(I_PAUSE_OFF);
        this.pauseButton.setPressedIcon(I_PAUSE_ON);
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.pressPause();
            }
        });
        this.pauseButton.setBorderPainted(false);
        this.pauseButton.setContentAreaFilled(false);
        this.pauseButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.buttonBox.add(this.pauseButton);
        this.stopButton = new JButton(I_STOP_OFF);
        this.stopButton.setIcon(I_STOP_ON);
        this.stopButton.setPressedIcon(I_STOP_OFF);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.pressStopMaybe();
            }
        });
        this.stopButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.stopButton.setBorderPainted(false);
        this.stopButton.setContentAreaFilled(false);
        this.buttonBox.add(this.stopButton);
        this.timeBox = new JComboBox<Object>(new Object[]{"Time", STEPS_KEY, "Rate", "None"});
        this.timeBox.setSelectedIndex(0);
        this.timeBox.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                JLabel jLabel = Console.this.time;
                synchronized (jLabel) {
                    Console.this.showing = Console.this.timeBox.getSelectedIndex();
                }
                Console.this.updateTime();
            }
        });
        Box timeBox1 = new Box(1);
        timeBox1.add(Box.createGlue());
        timeBox1.add(this.timeBox);
        timeBox1.add(Box.createGlue());
        this.time = new JLabel("");
        this.time.setPreferredSize(new JLabel("8888888888888888888").getPreferredSize());
        this.time.setMinimumSize(new JLabel("888").getMinimumSize());
        this.buttonBox.add(this.time);
        this.buttonBox.add(Box.createGlue());
        this.buttonBox.add(new JLabel(" "));
        this.buttonBox.add(timeBox1);
        if (Display2D.isMacOSX()) {
            this.buttonBox.add(new JLabel("    "));
        }
        this.infoPanel = new HTMLBrowser(GUIState.getInfo(simulation.getClass()));
        this.frameList = new Vector();
        this.frameListDisplay = new JList(this.frameList);
        this.frameListDisplay.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JFrame frame;
                    int index = Console.this.frameListDisplay.locationToIndex(e.getPoint());
                    frame.setVisible(!(frame = (JFrame)Console.this.frameListDisplay.getModel().getElementAt(index)).isVisible());
                    Console.this.frameListDisplay.repaint();
                }
            }
        });
        this.frameListDisplay.setCellRenderer(new ListCellRenderer(){
            protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                JFrame frame = (JFrame)value;
                if (frame.isVisible()) {
                    renderer.setForeground(Color.black);
                } else {
                    renderer.setForeground(Color.gray);
                }
                renderer.setText(frame.getTitle());
                return renderer;
            }
        });
        Box b = new Box(0);
        JButton button = new JButton("Show All");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.showAllFrames();
            }
        });
        b.add(button);
        button = new JButton("Show");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.showSelectedFrames();
            }
        });
        b.add(button);
        button = new JButton("Hide");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.hideSelectedFrames();
            }
        });
        b.add(button);
        button = new JButton("Hide All");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.hideAllFrames();
            }
        });
        b.add(button);
        b.add(Box.createGlue());
        JPanel frameListPanel = new JPanel();
        frameListPanel.setLayout(new BorderLayout());
        frameListPanel.add((Component)new JScrollPane(this.frameListDisplay), "Center");
        frameListPanel.add((Component)b, "South");
        LabelledList controlPanel = new LabelledList(){
            Insets insets = new Insets(2, 4, 2, 4);

            @Override
            public Insets getInsets() {
                return this.insets;
            }
        };
        this.slider = new JSlider(0, 1000, 0);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int val = Console.this.slider.getValue();
                long speed = (long)(512000.0 / (Math.pow(4.0, 5.0) - 1.0) * (Math.pow(4.0, (double)val / 1000.0) - 1.0));
                if (!Console.this.slider.getValueIsAdjusting()) {
                    Console.this.setPlaySleep(speed);
                }
                Console.this.sliderText.setText("" + (double)speed / 1000.0);
            }
        });
        b = new Box(0){
            Insets insets;
            {
                this.insets = new Insets(2, 4, 2, 4);
            }

            @Override
            public Insets getInsets() {
                return this.insets;
            }
        };
        b.add(this.slider);
        this.sliderText = new JLabel("0.0");
        this.sliderText.setMinimumSize(new JLabel("88.888").getMinimumSize());
        this.sliderText.setPreferredSize(new JLabel("88.888").getPreferredSize());
        b.add(this.sliderText);
        controlPanel.addLabelled("Delay (Sec/Step) ", b);
        this.stepSlider = new JSlider(1, 20, 1);
        this.stepSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Console.this.setNumStepsPerStepButtonPress(Console.this.stepSlider.getValue());
            }
        });
        b = new Box(0){
            Insets insets;
            {
                this.insets = new Insets(2, 4, 2, 4);
            }

            @Override
            public Insets getInsets() {
                return this.insets;
            }
        };
        b.add(this.stepSlider);
        this.stepSliderText = new JLabel("1");
        this.stepSliderText.setMinimumSize(new JLabel("8.888").getMinimumSize());
        this.stepSliderText.setPreferredSize(new JLabel("8.888").getPreferredSize());
        b.add(this.stepSliderText);
        controlPanel.addLabelled("Steps per Step-Button ", b);
        this.endField = new PropertyField(""){

            @Override
            public String newValue(String value) {
                long l = -1L;
                try {
                    l = Long.parseLong(value);
                    if (l < 0L) {
                        l = Long.MAX_VALUE;
                    }
                }
                catch (NumberFormatException num) {
                    l = Long.MAX_VALUE;
                }
                Console.this.setWhenShouldEnd(l);
                if (l == Long.MAX_VALUE) {
                    return "";
                }
                return "" + l;
            }
        };
        this.endField.getField().setColumns(20);
        this.endField.setMaximumSize(this.endField.getField().getPreferredSize());
        this.endField.setPreferredSize(this.endField.getField().getPreferredSize());
        b = new Box(0){
            Insets insets;
            {
                this.insets = new Insets(2, 4, 2, 4);
            }

            @Override
            public Insets getInsets() {
                return this.insets;
            }
        };
        b.add(this.endField);
        controlPanel.addLabelled("Automatically Stop at Step ", b);
        this.timeEndField = new PropertyField(""){

            @Override
            public String newValue(String value) {
                double l = -1.0;
                try {
                    l = Double.parseDouble(value);
                    if (l < 0.0 || l != l) {
                        l = Double.POSITIVE_INFINITY;
                    }
                }
                catch (NumberFormatException num) {
                    l = Double.POSITIVE_INFINITY;
                }
                Console.this.setWhenShouldEndTime(l);
                if (l == Double.POSITIVE_INFINITY) {
                    return "";
                }
                return "" + l;
            }
        };
        this.timeEndField.getField().setColumns(20);
        this.timeEndField.setMaximumSize(this.endField.getField().getPreferredSize());
        this.timeEndField.setPreferredSize(this.endField.getField().getPreferredSize());
        b = new Box(0){
            Insets insets;
            {
                this.insets = new Insets(2, 4, 2, 4);
            }

            @Override
            public Insets getInsets() {
                return this.insets;
            }
        };
        b.add(this.timeEndField);
        controlPanel.addLabelled("Automatically Stop after Time ", b);
        this.pauseField = new PropertyField(""){

            @Override
            public String newValue(String value) {
                long l = Long.MAX_VALUE;
                try {
                    l = Long.parseLong(value);
                    if (l < 0L) {
                        l = Long.MAX_VALUE;
                    }
                }
                catch (NumberFormatException num) {
                    l = Long.MAX_VALUE;
                }
                Console.this.setWhenShouldPause(l);
                if (l == Long.MAX_VALUE) {
                    return "";
                }
                return "" + l;
            }
        };
        this.pauseField.getField().setColumns(20);
        this.pauseField.setMaximumSize(this.pauseField.getField().getPreferredSize());
        this.pauseField.setPreferredSize(this.pauseField.getField().getPreferredSize());
        b = new Box(0){
            Insets insets;
            {
                this.insets = new Insets(2, 4, 2, 4);
            }

            @Override
            public Insets getInsets() {
                return this.insets;
            }
        };
        b.add(this.pauseField);
        controlPanel.addLabelled("Automatically Pause at Step ", b);
        this.timePauseField = new PropertyField(""){

            @Override
            public String newValue(String value) {
                double l = -1.0;
                try {
                    l = Double.parseDouble(value);
                    if (l < 0.0 || l != l) {
                        l = Double.POSITIVE_INFINITY;
                    }
                }
                catch (NumberFormatException num) {
                    l = Double.POSITIVE_INFINITY;
                }
                Console.this.setWhenShouldPauseTime(l);
                if (l == Double.POSITIVE_INFINITY) {
                    return "";
                }
                return "" + l;
            }
        };
        this.timePauseField.getField().setColumns(20);
        this.timePauseField.setMaximumSize(this.pauseField.getField().getPreferredSize());
        this.timePauseField.setPreferredSize(this.pauseField.getField().getPreferredSize());
        b = new Box(0){
            Insets insets;
            {
                this.insets = new Insets(2, 4, 2, 4);
            }

            @Override
            public Insets getInsets() {
                return this.insets;
            }
        };
        b.add(this.timePauseField);
        controlPanel.addLabelled("Automatically Pause After Time ", b);
        this.randomField = new PropertyField(""){
            boolean lock;
            {
                this.lock = false;
            }

            @Override
            public String newValue(String value) {
                if (this.lock) {
                    return value;
                }
                this.lock = true;
                try {
                    long l = Long.parseLong(value);
                    if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                        Utilities.inform("Seed Will Be Truncated", "The random number generator only uses 32 bits of a given seed.  You've specified a longer seed than this.Not all the bits of this seed will be used.", Console.this);
                    }
                    Console.this.randomSeed = l = (long)((int)l);
                    this.lock = false;
                    return "" + l;
                }
                catch (NumberFormatException num) {
                    this.lock = false;
                    return this.getValue();
                }
            }
        };
        this.randomField.getField().setColumns(20);
        this.randomField.setMaximumSize(this.randomField.getField().getPreferredSize());
        this.randomField.setPreferredSize(this.randomField.getField().getPreferredSize());
        this.randomField.setValue("" + this.randomSeed);
        b = new Box(0){
            Insets insets;
            {
                this.insets = new Insets(2, 4, 2, 4);
            }

            @Override
            public Insets getInsets() {
                return this.insets;
            }
        };
        b.add(this.randomField);
        controlPanel.addLabelled("Random Number Seed ", b);
        b = new Box(0){
            Insets insets;
            {
                this.insets = new Insets(2, 4, 2, 4);
            }

            @Override
            public Insets getInsets() {
                return this.insets;
            }
        };
        this.incrementSeedOnStop = new JCheckBox();
        this.incrementSeedOnStop.setSelected(true);
        b.add(this.incrementSeedOnStop);
        controlPanel.addLabelled("Increment Seed on Stop ", b);
        b = new Box(0){
            Insets insets;
            {
                this.insets = new Insets(2, 4, 2, 4);
            }

            @Override
            public Insets getInsets() {
                return this.insets;
            }
        };
        this.repeatButton = new JCheckBox();
        this.repeatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.setShouldRepeat(Console.this.repeatButton.isSelected());
            }
        });
        this.repeatButton.setSelected(false);
        b.add(this.repeatButton);
        controlPanel.addLabelled("Repeat Play on Stop ", b);
        Box defaults = new Box(0);
        defaults.add(new JLabel(" Save as Defaults for "));
        JButton appPreferences = new JButton("Simulation");
        JButton systemPreferences = new JButton("MASON");
        defaults.add(appPreferences);
        defaults.add(systemPreferences);
        defaults.add(Box.createGlue());
        systemPreferences.putClientProperty("JComponent.sizeVariant", "mini");
        systemPreferences.putClientProperty("JButton.buttonType", "bevel");
        systemPreferences.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.savePreferences(false);
                Prefs.removeAppPreferences(simulation, Console.DEFAULT_PREFERENCES_KEY);
            }
        });
        appPreferences.putClientProperty("JComponent.sizeVariant", "mini");
        appPreferences.putClientProperty("JButton.buttonType", "bevel");
        appPreferences.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.savePreferences(true);
            }
        });
        JPanel lowerPane = new JPanel();
        lowerPane.setLayout(new BorderLayout());
        this.removeButton = new JButton("Empty List");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.removeAllInspectors(false);
            }
        });
        this.removeButton.setEnabled(false);
        this.detatchButton = new JButton("Detatch");
        this.detatchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.detatchInspector();
            }
        });
        this.detatchButton.setEnabled(false);
        Box removeButtonBox = new Box(0);
        removeButtonBox.add(this.removeButton);
        removeButtonBox.add(this.detatchButton);
        removeButtonBox.add(Box.createGlue());
        this.inspectorList = new JList(this.inspectorNames);
        this.inspectorList.setSelectionMode(0);
        this.inspectorList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && Console.this.inspectorList.getSelectedIndex() != -1) {
                    Console.this.inspectorCardLayout.show(Console.this.inspectorSwitcher, "" + Console.this.inspectorList.getSelectedIndex());
                    Console.this.preferredInspectorIndex = Console.this.inspectorList.getSelectedIndex();
                }
            }
        });
        JScrollPane listPane = new JScrollPane(this.inspectorList);
        listPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.inspectorSwitcher = new JPanel();
        this.inspectorCardLayout = new CardLayout();
        this.inspectorSwitcher.setLayout(this.inspectorCardLayout);
        this.innerInspectorPanel = new JSplitPane(0, true, listPane, this.inspectorSwitcher);
        this.innerInspectorPanel.setDividerLocation(60);
        this.inspectorPanel = new JPanel();
        this.inspectorPanel.setLayout(new BorderLayout());
        this.inspectorPanel.add((Component)this.innerInspectorPanel, "Center");
        this.inspectorPanel.add((Component)removeButtonBox, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buttonBox, "South");
        this.tabPane = new JTabbedPane(){

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, 0);
            }
        };
        this.tabPane.putClientProperty("Quaqua.TabbedPane.contentBorderPainted", Boolean.FALSE);
        this.tabPane.addTab("About", this.infoPanel);
        AbstractScrollable consoleScrollable = new AbstractScrollable(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return true;
            }
        };
        consoleScrollable.setLayout(new BorderLayout());
        consoleScrollable.add((Component)controlPanel, "Center");
        JScrollPane controlScroll = new JScrollPane(consoleScrollable){
            Insets insets;
            {
                this.insets = new Insets(0, 0, 0, 0);
            }

            @Override
            public Insets getInsets() {
                return this.insets;
            }
        };
        controlScroll.getViewport().setBackground(transparentBackground);
        JPanel upperPane = new JPanel();
        upperPane.setLayout(new BorderLayout());
        upperPane.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(0, 0, 0, 64)));
        upperPane.add((Component)controlScroll, "Center");
        JPanel outerPane = new JPanel();
        outerPane.setLayout(new BorderLayout());
        outerPane.add((Component)upperPane, "Center");
        outerPane.add((Component)defaults, "South");
        this.tabPane.addTab(DEFAULT_PREFERENCES_KEY, outerPane);
        this.tabPane.addTab("Displays", frameListPanel);
        this.tabPane.addTab("Inspectors", this.inspectorPanel);
        this.buildModelInspector();
        this.getContentPane().add((Component)this.tabPane, "Center");
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        JMenu fileMenu = new JMenu("File");
        this.menuBar.add(fileMenu);
        Console.buildClassList();
        this.newMenu = new JMenuItem("New Simulation...");
        this.setNewMenuAllowed(this.isNewMenuAllowed());
        this.newMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.doNew();
            }
        });
        fileMenu.add(this.newMenu);
        JMenuItem open = new JMenuItem("Open...");
        if (SimApplet.isApplet) {
            open.setEnabled(false);
        }
        open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.doOpen();
            }
        });
        fileMenu.add(open);
        JMenuItem save = new JMenuItem("Save");
        if (SimApplet.isApplet) {
            save.setEnabled(false);
        }
        save.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                Schedule schedule = simulation.state.schedule;
                synchronized (schedule) {
                    Console.this.doSave();
                }
            }
        });
        fileMenu.add(save);
        JMenuItem saveAs = new JMenuItem("Save As...");
        if (SimApplet.isApplet) {
            saveAs.setEnabled(false);
        }
        saveAs.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                Schedule schedule = simulation.state.schedule;
                synchronized (schedule) {
                    Console.this.doSaveAs();
                }
            }
        });
        fileMenu.add(saveAs);
        JMenuItem _about = new JMenuItem("About MASON");
        _about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.doAbout();
            }
        });
        fileMenu.add(_about);
        JMenuItem quit = new JMenuItem("Quit");
        quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.doQuit();
            }
        });
        fileMenu.add(quit);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Utilities.doEnsuredRepaint(Console.this.getContentPane());
                Utilities.doEnsuredRepaint(Console.this.menuBar);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Console.this.doClose();
            }
        });
        this.setDefaultCloseOperation(0);
        this.setSize(380, 380);
        Point defLoc = this.getLocation();
        this.setLocation(-10000, -10000);
        this.setResizable(true);
        this.repaint();
        allControllers.put(this, this);
        this.invokeInSwing(new Runnable(){

            @Override
            public void run() {
                try {
                    simulation.init(Console.this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        Point loc = this.getLocation();
        if (loc.x == -10000 && loc.y == -10000) {
            Rectangle screen = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
            Rectangle bounds = new Rectangle(0, 0, 0, 0);
            Iterator i = this.frameList.iterator();
            while (i.hasNext()) {
                bounds = bounds.union(((Component)i.next()).getBounds());
            }
            if (bounds.width + this.getWidth() + 5 <= screen.width) {
                this.setLocation(bounds.width + 5, defLoc.y);
            } else {
                this.setLocation(defLoc);
            }
        }
        this.invokeInSwing(new Runnable(){

            @Override
            public void run() {
                Console.this.resetToPreferences();
            }
        });
    }

    void invokeInSwing(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    void buildModelInspector() {
        if (this.modelInspectorScrollPane != null) {
            this.tabPane.remove(this.modelInspectorScrollPane);
        }
        this.modelInspector = this.simulation.getInspector();
        if (this.modelInspector != null) {
            this.modelInspectorScrollPane = new JScrollPane(this.modelInspector){
                Insets insets;
                {
                    this.insets = new Insets(0, 0, 0, 0);
                }

                @Override
                public Insets getInsets() {
                    return this.insets;
                }
            };
            this.modelInspectorScrollPane.getViewport().setBackground(new JPanel().getBackground());
            this.tabPane.addTab("Model", this.modelInspectorScrollPane);
        }
        this.tabPane.revalidate();
    }

    void savePreferences(boolean appPreferences) {
        Preferences prefs = null;
        try {
            prefs = appPreferences ? Prefs.getAppPreferences(this.simulation, DEFAULT_PREFERENCES_KEY) : Prefs.getGlobalPreferences(DEFAULT_PREFERENCES_KEY);
            prefs.putInt(DELAY_KEY, this.slider.getValue());
            prefs.putInt(STEPS_KEY, this.stepSlider.getValue());
            prefs.put(AUTOMATIC_STOP_STEPS_KEY, this.endField.getValue());
            prefs.put(AUTOMATIC_STOP_TIME_KEY, this.timeEndField.getValue());
            prefs.put(AUTOMATIC_PAUSE_STEPS_KEY, this.pauseField.getValue());
            prefs.put(AUTOMATIC_PAUSE_TIME_KEY, this.timePauseField.getValue());
            prefs.putBoolean(INCREMENT_KEY, this.incrementSeedOnStop.isSelected());
            prefs.putBoolean(REPEAT_KEY, this.repeatButton.isSelected());
            if (!Prefs.save(prefs)) {
                Utilities.inform("Preferences Cannot be Saved", "Your Java system can't save preferences.  Perhaps this is an applet?", this);
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    void resetToPreferences() {
        try {
            Preferences systemPrefs = Prefs.getGlobalPreferences(DEFAULT_PREFERENCES_KEY);
            Preferences appPrefs = Prefs.getAppPreferences(this.simulation, DEFAULT_PREFERENCES_KEY);
            this.slider.setValue(appPrefs.getInt(DELAY_KEY, systemPrefs.getInt(DELAY_KEY, this.slider.getValue())));
            this.stepSlider.setValue(appPrefs.getInt(STEPS_KEY, systemPrefs.getInt(STEPS_KEY, this.stepSlider.getValue())));
            this.endField.setValue(this.endField.newValue(appPrefs.get(AUTOMATIC_STOP_STEPS_KEY, systemPrefs.get(AUTOMATIC_STOP_STEPS_KEY, this.endField.getValue()))));
            this.timeEndField.setValue(this.timeEndField.newValue(appPrefs.get(AUTOMATIC_STOP_TIME_KEY, systemPrefs.get(AUTOMATIC_STOP_TIME_KEY, this.timeEndField.getValue()))));
            this.pauseField.setValue(this.pauseField.newValue(appPrefs.get(AUTOMATIC_PAUSE_STEPS_KEY, systemPrefs.get(AUTOMATIC_PAUSE_STEPS_KEY, this.pauseField.getValue()))));
            this.timePauseField.setValue(this.timePauseField.newValue(appPrefs.get(AUTOMATIC_PAUSE_TIME_KEY, systemPrefs.get(AUTOMATIC_PAUSE_TIME_KEY, this.timePauseField.getValue()))));
            this.incrementSeedOnStop.setSelected(appPrefs.getBoolean(INCREMENT_KEY, systemPrefs.getBoolean(INCREMENT_KEY, this.incrementSeedOnStop.isSelected())));
            this.repeatButton.setSelected(appPrefs.getBoolean(REPEAT_KEY, systemPrefs.getBoolean(REPEAT_KEY, this.repeatButton.isSelected())));
            this.setShouldRepeat(this.repeatButton.isSelected());
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShouldRepeat(boolean val) {
        Object object = this.playThreadLock;
        synchronized (object) {
            this.shouldRepeat = val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getShouldRepeat() {
        Object object = this.playThreadLock;
        synchronized (object) {
            return this.shouldRepeat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadPriority(int val) {
        Object object = this.playThreadLock;
        synchronized (object) {
            this.threadPriority = val;
            if (this.playThread != null) {
                this.playThread.setPriority(this.threadPriority);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getThreadPriority() {
        Object object = this.playThreadLock;
        synchronized (object) {
            return this.threadPriority;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWhenShouldEnd(long val) {
        Object object = this.playThreadLock;
        synchronized (object) {
            this.whenShouldEnd = val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWhenShouldEnd() {
        Object object = this.playThreadLock;
        synchronized (object) {
            return this.whenShouldEnd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWhenShouldPause(long val) {
        Object object = this.playThreadLock;
        synchronized (object) {
            this.whenShouldPause = val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWhenShouldPause() {
        Object object = this.playThreadLock;
        synchronized (object) {
            return this.whenShouldPause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWhenShouldEndTime(double val) {
        Object object = this.playThreadLock;
        synchronized (object) {
            this.whenShouldEndTime = val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getWhenShouldEndTime() {
        Object object = this.playThreadLock;
        synchronized (object) {
            return this.whenShouldEndTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWhenShouldPauseTime(double val) {
        Object object = this.playThreadLock;
        synchronized (object) {
            this.whenShouldPauseTime = val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getWhenShouldPauseTime() {
        Object object = this.playThreadLock;
        synchronized (object) {
            return this.whenShouldPauseTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlaySleep(long sleep) {
        Object object = this.playThreadLock;
        synchronized (object) {
            this.playSleep = sleep;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPlaySleep() {
        Object object = this.playThreadLock;
        synchronized (object) {
            return this.playSleep;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getThreadShouldStop() {
        Object object = this.playThreadLock;
        synchronized (object) {
            return this.threadShouldStop;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setThreadShouldStop(boolean stop) {
        Object object = this.playThreadLock;
        synchronized (object) {
            this.threadShouldStop = stop;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPlayState(int state) {
        Object object = this.playThreadLock;
        synchronized (object) {
            this.playState = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayState() {
        Object object = this.playThreadLock;
        synchronized (object) {
            return this.playState;
        }
    }

    void startSimulation() {
        this.removeAllInspectors(true);
        this.simulation.state.setSeed(this.randomSeed);
        this.simulation.start();
        this.updateTime(this.simulation.state.schedule.getSteps(), this.simulation.state.schedule.getTime(), -1.0);
        if (this.modelInspector != null) {
            Steppable stepper = new Steppable(){

                @Override
                public void step(final SimState state) {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Schedule schedule = state.schedule;
                            synchronized (schedule) {
                                if ((this).Console.this.modelInspector.isVolatile()) {
                                    (this).Console.this.modelInspector.updateInspector();
                                    (this).Console.this.modelInspector.repaint();
                                }
                            }
                        }
                    });
                }
            };
            if (this.modelInspector.isVolatile()) {
                this.simulation.scheduleRepeatingImmediatelyAfter(stepper);
            }
        }
    }

    public synchronized JTabbedPane getTabPane() {
        return this.tabPane;
    }

    public synchronized Inspector getModelInspector() {
        return this.modelInspector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doQuit() {
        Object object = isQuittingLock;
        synchronized (object) {
            if (isQuitting) {
                return;
            }
            isQuitting = true;
            Object[] entries = allControllers.entrySet().toArray();
            int x = 0;
            while (x < entries.length) {
                if (entries[x] != null && entries[x] instanceof Console) {
                    ((Console)((Map.Entry)entries[x]).getKey()).doClose();
                } else if (entries[x] != null && entries[x] instanceof SimpleController) {
                    ((SimpleController)((Map.Entry)entries[x]).getKey()).doClose();
                }
                ++x;
            }
            if (!SimApplet.isApplet) {
                try {
                    System.exit(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            isQuitting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doClose() {
        Object object = this.isClosingLock;
        synchronized (object) {
            if (this.isClosing) {
                return;
            }
            this.isClosing = true;
        }
        this.pressStop();
        this.simulation.quit();
        this.dispose();
        allControllers.remove(this);
        if (allControllers.size() == 0) {
            Console.doQuit();
        }
    }

    public static void main(String[] args) {
        sacrificial = Display2D.isMacOSX();
        if (!Console.doNew(null, true) && !SimApplet.isApplet) {
            System.exit(0);
        }
    }

    protected void doAbout() {
        if (aboutFrame == null) {
            aboutFrame = new JFrame("About MASON");
            JPanel p = new JPanel();
            p.setBorder(BorderFactory.createEmptyBorder(25, 30, 30, 30));
            Box b = new Box(1);
            p.add((Component)b, "Center");
            aboutFrame.getContentPane().add((Component)p, "Center");
            aboutFrame.setResizable(false);
            Font small = new Font("Dialog", 0, 9);
            JLabel j = new JLabel("MASON");
            j.setFont(new Font("Serif", 0, 36));
            b.add(j);
            NumberFormat n = NumberFormat.getInstance();
            n.setMinimumFractionDigits(0);
            j = new JLabel("Version " + n.format(SimState.version()));
            b.add(j);
            JLabel spacer = new JLabel(" ");
            spacer.setFont(new Font("Dialog", 0, 6));
            b.add(spacer);
            j = new JLabel("Co-created by George Mason University's");
            b.add(j);
            j = new JLabel("Evolutionary Computation Laboratory and");
            b.add(j);
            j = new JLabel("Center for Social Complexity");
            b.add(j);
            spacer = new JLabel(" ");
            spacer.setFont(new Font("Dialog", 0, 6));
            b.add(spacer);
            j = new JLabel("http://cs.gmu.edu/~eclab/projects/mason/");
            b.add(j);
            spacer = new JLabel(" ");
            spacer.setFont(new Font("Dialog", 0, 6));
            b.add(spacer);
            j = new JLabel("Major contributors include Sean Luke,");
            b.add(j);
            j = new JLabel("Gabriel Catalin Balan, Liviu Panait,");
            b.add(j);
            j = new JLabel("Claudio Cioffi-Revilla, Sean Paus,");
            b.add(j);
            j = new JLabel("Keith Sullivan, and Daniel Kuebrich.");
            b.add(j);
            spacer = new JLabel(" ");
            spacer.setFont(new Font("Dialog", 0, 6));
            b.add(spacer);
            j = new JLabel("MASON is (c) 2005-2012 Sean Luke and George Mason University,");
            j.setFont(small);
            b.add(j);
            j = new JLabel("with various elements copyrighted by the above contributors.");
            j.setFont(small);
            b.add(j);
            j = new JLabel("PNGEncoder is (c) 2000 J. David Eisenberg.  MovieEncoder,", 2);
            j.setFont(small);
            b.add(j);
            j = new JLabel("SelectionBehavior, and WireFrameBoxPortrayal3D are partly", 2);
            j.setFont(small);
            b.add(j);
            j = new JLabel("(c) 1996 Sun Microsystems.  MersenneTwisterFast is partly", 2);
            j.setFont(small);
            b.add(j);
            j = new JLabel("(c) 1993 Michael Lecuyer.  CapturingCanvas3D is based in", 2);
            j.setFont(small);
            b.add(j);
            j = new JLabel("part on code by Peter Kunszt.", 2);
            j.setFont(small);
            b.add(j);
            aboutFrame.pack();
        }
        if (!aboutFrame.isVisible()) {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            d.width -= aboutFrame.getWidth();
            d.height -= aboutFrame.getHeight();
            d.width /= 2;
            d.height /= 2;
            if (d.width < 0) {
                d.width = 0;
            }
            if (d.height < 0) {
                d.height = 0;
            }
            aboutFrame.setLocation(d.width, d.height);
        }
        aboutFrame.setVisible(true);
    }

    public void doNew() {
        Console.doNew(this, false);
    }

    static int showOptionDialog(JFrame originalFrame, JComponent component, String title, Object[] options, boolean resizable) {
        JOptionPane p = new JOptionPane(component, -1, 2, null, options, options[0]);
        JDialog d = p.createDialog(originalFrame, title);
        d.pack();
        d.setResizable(resizable);
        p.selectInitialValue();
        d.setVisible(true);
        int counter = 0;
        while (counter < options.length) {
            if (options[counter].equals(p.getValue())) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void buildClassList() {
        Object object = classLock;
        synchronized (object) {
            if (classListLoaded) {
                return;
            }
            classListLoaded = true;
        }
        allowOtherClassNames = true;
        try {
            InputStream s = Console.class.getResourceAsStream("simulation.classes");
            StreamTokenizer st = new StreamTokenizer(new BufferedReader(new InputStreamReader(s)));
            st.resetSyntax();
            st.wordChars(32, 255);
            st.whitespaceChars(0, 31);
            st.commentChar(35);
            boolean errout = false;
            String nextName = null;
            while (st.nextToken() != -1) {
                if (st.sval == null) continue;
                if (ONLY_INDICATOR.equalsIgnoreCase(st.sval)) {
                    allowOtherClassNames = false;
                    continue;
                }
                if (st.sval.toUpperCase().startsWith(NAME_INDICATOR)) {
                    nextName = st.sval.substring(5).trim();
                    continue;
                }
                String shortName = null;
                if (nextName == null) {
                    try {
                        Class<?> c = Class.forName(st.sval);
                        try {
                            shortName = GUIState.getName(c);
                        }
                        catch (Throwable e) {
                            shortName = GUIState.getTruncatedName(c);
                        }
                    }
                    catch (Throwable e) {
                        if (!errout) {
                            System.err.println("WARNING: Not all classes loaded, due to error: probably no Java3D.");
                        }
                        errout = true;
                    }
                } else {
                    shortName = nextName;
                    nextName = null;
                }
                if (shortName == null) continue;
                classNames.add(st.sval);
                shortNames.add(shortName);
            }
            if (nextName != null) {
                System.err.println("WARNING: Spurious NAME tag at end of simulation.classes file:\n\tNAME: " + nextName);
            }
            s.close();
        }
        catch (Exception e) {
            System.err.println("WARNING: Couldn't load the simulation.classes file because of error. \nLikely the file does not exist or could not be opened.\nThe error was:\n");
            e.printStackTrace();
        }
    }

    static boolean doNew(JFrame originalFrame, boolean startingUp) {
        Console.buildClassList();
        String defaultText = "<html><body bgcolor='white'><font face='dialog'><br><br><br><br><p align='center'>Select a MASON simulation from the list at left,<br>or type a Java class name below.</p></font></body></html>";
        String nothingSelectedText = "<html><body bgcolor='white'></body></html>";
        while (true) {
            int reply;
            final JList<Object> list = new JList<Object>(classNames);
            JScrollPane pane = new JScrollPane(list);
            list.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (index >= 0) {
                        label.setText("<html><body><font face='dialog'> " + shortNames.get(index) + "<font size='-2' color='#AAAAAA'><br> " + classNames.get(index) + "</font></font></body></html>");
                    }
                    return label;
                }
            });
            final HTMLBrowser browser = new HTMLBrowser("<html><body bgcolor='white'><font face='dialog'><br><br><br><br><p align='center'>Select a MASON simulation from the list at left,<br>or type a Java class name below.</p></font></body></html>"){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(400, 400);
                }

                @Override
                public Dimension getMinimumSize() {
                    return new Dimension(10, 10);
                }
            };
            final JTextField field = new JTextField("sim.app.");
            JPanel fieldp = new JPanel();
            fieldp.setLayout(new BorderLayout());
            fieldp.add((Component)field, "Center");
            fieldp.add((Component)new JLabel("Simulation class name: "), "West");
            fieldp.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        try {
                            field.setText((String)list.getSelectedValue());
                            browser.setText(GUIState.getInfo(Class.forName(field.getText())));
                        }
                        catch (Throwable ex) {
                            field.setText((String)list.getSelectedValue());
                            browser.setText("<html><body bgcolor='white'></body></html>");
                        }
                    }
                }
            });
            final boolean[] doubleClick = new boolean[1];
            list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        doubleClick[0] = true;
                        Container c = list;
                        while (c.getParent() != null) {
                            c = c.getParent();
                        }
                        ((Window)c).dispose();
                    }
                }
            });
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.add((Component)browser, "Center");
            p.add((Component)pane, "West");
            if (allowOtherClassNames) {
                p.add((Component)fieldp, "South");
            }
            if ((reply = Console.showOptionDialog(null, p, "New Simulation", new Object[]{"Select", startingUp ? "Quit" : "Cancel"}, true)) != 0 && !doubleClick[0]) {
                return false;
            }
            String className = field.getText();
            try {
                Constructor<?> cons = Class.forName(className).getConstructor(new Class[0]);
                final GUIState state = (GUIState)Class.forName(className).newInstance();
                if (SwingUtilities.isEventDispatchThread()) {
                    state.createController();
                } else {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            state.createController();
                        }
                    });
                }
                return true;
            }
            catch (NoSuchMethodException e) {
                Utilities.informOfError(e, "The simulation does not have a default constructor: " + className, originalFrame);
                continue;
            }
            catch (Throwable e) {
                Utilities.informOfError(e, "An error occurred while creating the simulation " + className, originalFrame);
                continue;
            }
            break;
        }
    }

    public void doSaveAs() {
        FileDialog fd = new FileDialog((Frame)this, "Save Simulation As...", 1);
        if (this.simulationFile == null) {
            fd.setFile("Untitled.checkpoint");
        } else {
            fd.setFile(this.simulationFile.getName());
            fd.setDirectory(this.simulationFile.getParentFile().getPath());
        }
        fd.setVisible(true);
        File f = null;
        if (fd.getFile() != null) {
            try {
                f = new File(fd.getDirectory(), Utilities.ensureFileEndsWith(fd.getFile(), ".checkpoint"));
                this.simulation.state.writeToCheckpoint(f);
                this.simulationFile = f;
            }
            catch (Exception e) {
                Utilities.informOfError(e, "An error occurred while saving the simulation to the file " + (f == null ? " " : f.getName()), null);
            }
        }
    }

    public void doSave() {
        if (this.simulationFile == null) {
            this.doSaveAs();
        } else {
            try {
                this.simulation.state.writeToCheckpoint(this.simulationFile);
            }
            catch (Exception e) {
                Utilities.informOfError(e, "An error occurred while saving the simulation to the file " + this.simulationFile.getName(), null);
            }
        }
    }

    public void doOpen() {
        FileDialog fd = new FileDialog((Frame)this, "Load Saved Simulation...", 0);
        fd.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return Utilities.ensureFileEndsWith(name, ".checkpoint").equals(name);
            }
        });
        if (this.simulationFile != null) {
            fd.setFile(this.simulationFile.getName());
            fd.setDirectory(this.simulationFile.getParentFile().getPath());
        }
        boolean failed = true;
        int originalPlayState = this.getPlayState();
        if (originalPlayState == 1) {
            this.pressPause();
        }
        fd.setVisible(true);
        File f = null;
        if (fd.getFile() != null) {
            try {
                f = new File(fd.getDirectory(), fd.getFile());
                if (!this.simulation.readNewStateFromCheckpoint(f)) {
                    throw new RuntimeException("Invalid SimState class.  Original state: " + this.simulation.state);
                }
                this.simulationFile = f;
                this.buildModelInspector();
                this.removeAllInspectors(true);
                if (originalPlayState == 0) {
                    this.pressPause(false);
                }
                failed = false;
            }
            catch (Throwable e) {
                Utilities.informOfError(e, "An error occurred while loading the simulation from the file " + (f == null ? fd.getFile() : f.getName()), null);
            }
        }
        if (failed && originalPlayState == 1) {
            this.pressPause();
        }
        this.updateTime(this.simulation.state.schedule.getSteps(), this.simulation.state.schedule.getTime(), -1.0);
        this.randomField.setValue("" + this.simulation.state.seed());
    }

    @Override
    public synchronized ArrayList getAllFrames() {
        return new ArrayList(this.frameList);
    }

    synchronized void showSelectedFrames() {
        Object[] vals = this.frameListDisplay.getSelectedValues();
        int x = 0;
        while (x < vals.length) {
            ((JFrame)vals[x]).toFront();
            ((JFrame)vals[x]).setVisible(true);
            ++x;
        }
        this.frameListDisplay.repaint();
    }

    public synchronized void showAllFrames() {
        Object[] vals = this.frameList.toArray();
        int x = 0;
        while (x < vals.length) {
            ((JFrame)vals[x]).toFront();
            ((JFrame)vals[x]).setVisible(true);
            ++x;
        }
        this.frameListDisplay.repaint();
    }

    synchronized void hideSelectedFrames() {
        Object[] vals = this.frameListDisplay.getSelectedValues();
        int x = 0;
        while (x < vals.length) {
            ((JFrame)vals[x]).setVisible(false);
            ++x;
        }
        this.frameListDisplay.repaint();
    }

    public synchronized void hideAllFrames() {
        Object[] vals = this.frameList.toArray();
        int x = 0;
        while (x < vals.length) {
            ((JFrame)vals[x]).setVisible(false);
            ++x;
        }
        this.frameListDisplay.repaint();
    }

    public synchronized void setRequiresConfirmationToStop(boolean val) {
        this.requiresConfirmationToStop = val;
    }

    public synchronized boolean getRequiresConfirmationToStop() {
        return this.requiresConfirmationToStop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void pressStopMaybe() {
        if (this.requiresConfirmationToStop) {
            if (this.getPlayState() != 0) {
                boolean result = false;
                Schedule schedule = this.simulation.state.schedule;
                synchronized (schedule) {
                    result = JOptionPane.showConfirmDialog(this, "The simulation is running.  Really stop it?", "Stop the simulation?", 2) == 0;
                }
                if (result) {
                    this.pressStop();
                }
            }
        } else {
            this.pressStop();
        }
    }

    public void setIncrementSeedOnPlay(boolean val) {
        this.setIncrementSeedOnStop(val);
    }

    public boolean getIncrementSeedOnPlay() {
        return this.getIncrementSeedOnStop();
    }

    public void setIncrementSeedOnStop(boolean val) {
        this.incrementSeedOnStop.setSelected(val);
    }

    public boolean getIncrementSeedOnStop() {
        return this.incrementSeedOnStop.isSelected();
    }

    public synchronized void pressStop() {
        if (this.getPlayState() != 0) {
            this.stopButton.setIcon(I_STOP_ON);
            this.stopButton.setPressedIcon(I_STOP_OFF);
            this.playButton.setIcon(I_PLAY_OFF);
            this.playButton.setPressedIcon(I_PLAY_ON);
            this.pauseButton.setIcon(I_PAUSE_OFF);
            this.pauseButton.setPressedIcon(I_PAUSE_ON);
            this.repaint();
            this.killPlayThread();
            this.simulation.finish();
            this.stopAllInspectors(true);
            this.setPlayState(0);
            this.repaint();
            if (this.incrementSeedOnStop.isSelected()) {
                this.randomSeed = (int)(this.randomSeed + 1L);
                this.randomField.setValue("" + this.randomSeed);
            }
            if (this.getShouldRepeat()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Console.this.pressPlay();
                    }
                });
            }
        }
    }

    public synchronized void pressPause() {
        this.pressPause(true);
    }

    synchronized void pressPause(boolean shouldStartSimulationIfStopped) {
        if (this.getPlayState() == 1) {
            this.killPlayThread();
            this.pauseButton.setIcon(I_PAUSE_ON);
            this.pauseButton.setPressedIcon(I_PAUSE_OFF);
            this.playButton.setIcon(I_STEP_OFF);
            this.playButton.setPressedIcon(I_STEP_ON);
            this.setPlayState(2);
            this.refresh();
        } else if (this.getPlayState() == 2) {
            this.pauseButton.setIcon(I_PAUSE_OFF);
            this.pauseButton.setPressedIcon(I_PAUSE_ON);
            this.playButton.setIcon(I_PLAY_ON);
            this.playButton.setPressedIcon(I_PLAY_OFF);
            this.spawnPlayThread();
            this.setPlayState(1);
        } else if (this.getPlayState() == 0) {
            if (shouldStartSimulationIfStopped) {
                this.startSimulation();
            }
            this.stopButton.setIcon(I_STOP_OFF);
            this.stopButton.setPressedIcon(I_STOP_ON);
            this.pauseButton.setIcon(I_PAUSE_ON);
            this.pauseButton.setPressedIcon(I_PAUSE_OFF);
            this.playButton.setIcon(I_STEP_OFF);
            this.playButton.setPressedIcon(I_STEP_ON);
            this.setPlayState(2);
            this.refresh();
        }
        this.repaint();
    }

    public int getNumStepsPerStepButtonPress() {
        return this.numStepsPerStepButtonPress;
    }

    public void setNumStepsPerStepButtonPress(int val) {
        if (val > 0) {
            this.numStepsPerStepButtonPress = val;
            this.stepSliderText.setText("" + this.numStepsPerStepButtonPress);
            this.slider.setValue(val);
        }
    }

    public synchronized void pressPlay() {
        if (this.getPlayState() == 0) {
            this.stopButton.setIcon(I_STOP_OFF);
            this.stopButton.setPressedIcon(I_STOP_ON);
            this.playButton.setIcon(I_PLAY_ON);
            this.playButton.setPressedIcon(I_PLAY_OFF);
            this.pauseButton.setIcon(I_PAUSE_OFF);
            this.pauseButton.setPressedIcon(I_PAUSE_ON);
            this.repaint();
            this.startSimulation();
            this.spawnPlayThread();
            this.setPlayState(1);
        } else if (this.getPlayState() == 2) {
            int x = 0;
            while (x < this.numStepsPerStepButtonPress) {
                if (!this.simulation.step() || this.simulation.state.schedule.getTime() >= this.getWhenShouldEndTime() || this.simulation.state.schedule.getSteps() >= this.getWhenShouldEnd()) {
                    this.pressStop();
                    this.updateTime(this.simulation.state.schedule.getSteps(), this.simulation.state.schedule.getTime(), -1.0);
                    break;
                }
                this.updateTime(this.simulation.state.schedule.getSteps(), this.simulation.state.schedule.getTime(), -1.0);
                ++x;
            }
            this.refresh();
        }
        this.repaint();
    }

    void updateTimeText(final String timeString) {
        if (!timeString.equals(this.lastText)) {
            this.lastText = timeString;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Console.this.time.setText(timeString);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTime() {
        double rate;
        double time;
        long steps;
        JLabel jLabel = this.time;
        synchronized (jLabel) {
            steps = this.lastSteps;
            time = this.lastTime;
            rate = this.lastRate;
        }
        this.updateTime(steps, time, rate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTime(long steps, double time, double rate) {
        int showing;
        boolean simulationExists = this.simulation != null && this.simulation.state != null;
        JLabel jLabel = this.time;
        synchronized (jLabel) {
            this.lastRate = rate;
            this.lastSteps = steps;
            this.lastTime = time;
            showing = this.showing;
        }
        switch (showing) {
            case 0: {
                this.updateTimeText(simulationExists ? this.simulation.state.schedule.getTimestamp(this.lastTime, "At Start", "At End") : "");
                break;
            }
            case 1: {
                this.updateTimeText(simulationExists ? "" + this.lastSteps : "");
                break;
            }
            case 2: {
                if (this.lastRate == 0.0) break;
                this.updateTimeText(this.lastRate < 0.0 ? "" : this.rateFormat.format(this.lastRate));
                break;
            }
            default: {
                this.updateTimeText("");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getStepsPerSecond() {
        JLabel jLabel = this.time;
        synchronized (jLabel) {
            return this.lastRate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void killPlayThread() {
        block8: {
            this.setThreadShouldStop(true);
            try {
                if (this.playThread == null) break block8;
                do {
                    try {
                        Schedule schedule = this.simulation.state.schedule;
                        synchronized (schedule) {
                            this.playThread.interrupt();
                        }
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    this.playThread.join(50L);
                } while (this.playThread.isAlive());
                this.playThread = null;
            }
            catch (InterruptedException e) {
                System.err.println("WARNING: This should never happen: " + e);
            }
        }
    }

    synchronized void spawnPlayThread() {
        this.setThreadShouldStop(false);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                double currentRate = 0.0;
                try {
                    long lastRateDisplayStepTime;
                    long lastTimeDisplayStepTime = lastRateDisplayStepTime = System.currentTimeMillis();
                    int currentSteps = 0;
                    long RATE_UPDATE_INTERVAL = 500L;
                    long TIME_UPDATE_INTERVAL = 40L;
                    if (!Thread.currentThread().isInterrupted() && !Console.this.getThreadShouldStop()) {
                        try {
                            SwingUtilities.invokeAndWait(Console.this.blocker);
                        }
                        catch (InterruptedException e) {
                            try {
                                Thread.currentThread().interrupt();
                            }
                            catch (SecurityException securityException) {}
                        }
                        catch (InvocationTargetException e) {
                            System.err.println("WARNING: This should never happen: " + e);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    Console.this.simulation.state.nameThread();
                    boolean result = true;
                    while (!Console.this.getThreadShouldStop()) {
                        result = Console.this.simulation.step();
                        double t = Console.this.simulation.state.schedule.getTime();
                        long s = Console.this.simulation.state.schedule.getSteps();
                        ++currentSteps;
                        long l = System.currentTimeMillis();
                        if (l - lastRateDisplayStepTime >= 500L) {
                            currentRate = (double)currentSteps / ((double)(l - lastRateDisplayStepTime) / 1000.0);
                            currentSteps = 0;
                            lastRateDisplayStepTime = l;
                        }
                        if (l - lastTimeDisplayStepTime >= 40L) {
                            Console.this.updateTime(s, t, currentRate);
                            lastTimeDisplayStepTime = l;
                        }
                        if (!Thread.currentThread().isInterrupted() && !Console.this.getThreadShouldStop()) {
                            try {
                                SwingUtilities.invokeAndWait(Console.this.blocker);
                            }
                            catch (InterruptedException e) {
                                try {
                                    Thread.currentThread().interrupt();
                                }
                                catch (SecurityException securityException) {}
                            }
                            catch (InvocationTargetException e) {
                                System.err.println("WARNING: This should never happen" + e);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (!result || Console.this.getThreadShouldStop() || t >= Console.this.getWhenShouldEndTime() || t >= Console.this.getWhenShouldPauseTime() || s >= Console.this.getWhenShouldEnd() || s >= Console.this.getWhenShouldPause()) break;
                        long sleep = Console.this.getPlaySleep();
                        if (sleep <= 0L || Thread.currentThread().isInterrupted() || Console.this.getThreadShouldStop()) continue;
                        try {
                            Thread.sleep(sleep);
                        }
                        catch (InterruptedException e) {
                            try {
                                Thread.currentThread().interrupt();
                            }
                            catch (SecurityException securityException) {
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (!result || Console.this.simulation.state.schedule.getTime() >= Console.this.getWhenShouldEndTime() || Console.this.simulation.state.schedule.getSteps() >= Console.this.getWhenShouldEnd()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Console.this.pressStop();
                                }
                                catch (Exception e) {
                                    System.err.println("WARNING: This should never happen: " + e);
                                }
                            }
                        });
                    } else if (Console.this.simulation.state.schedule.getTime() >= Console.this.getWhenShouldPauseTime() || Console.this.simulation.state.schedule.getSteps() >= Console.this.getWhenShouldPause()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Console.this.pressPause();
                                    (this).Console.this.pauseField.setValue("");
                                    (this).Console.this.timePauseField.setValue("");
                                    Console.this.setWhenShouldPause(Long.MAX_VALUE);
                                    Console.this.setWhenShouldPauseTime(Double.POSITIVE_INFINITY);
                                }
                                catch (Exception e) {
                                    System.err.println("WARNING: This should never happen: " + e);
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Console.this.updateTime(Console.this.simulation.state.schedule.getSteps(), Console.this.simulation.state.schedule.getTime(), currentRate);
            }
        };
        this.playThread = new Thread(run);
        this.playThread.setPriority(this.getThreadPriority());
        this.playThread.start();
    }

    @Override
    public synchronized boolean registerFrame(JFrame frame) {
        this.frameList.add(frame);
        this.frameListDisplay.setListData(this.frameList);
        return true;
    }

    @Override
    public synchronized boolean unregisterFrame(JFrame frame) {
        this.frameList.removeElement(frame);
        this.frameListDisplay.setListData(this.frameList);
        return true;
    }

    @Override
    public synchronized boolean unregisterAllFrames() {
        this.frameList.removeAllElements();
        this.frameListDisplay.setListData(this.frameList);
        return true;
    }

    @Override
    public synchronized void doChangeCode(Runnable r) {
        if (this.playThread != null) {
            this.killPlayThread();
            r.run();
            this.spawnPlayThread();
        } else {
            r.run();
        }
    }

    @Override
    public void refresh() {
        Enumeration e = this.frameList.elements();
        while (e.hasMoreElements()) {
            ((JFrame)e.nextElement()).getContentPane().repaint();
        }
        for (Inspector c : this.allInspectors.keySet()) {
            if (c == null || !c.isVolatile()) continue;
            c.updateInspector();
            c.repaint();
        }
        if (this.modelInspector != null && this.modelInspector.isVolatile()) {
            this.modelInspector.updateInspector();
            this.modelInspector.repaint();
        }
        this.getContentPane().repaint();
    }

    void resetInspectors(int preferredSelection) {
        this.inspectorSwitcher = new JPanel();
        this.inspectorCardLayout = new CardLayout();
        this.inspectorSwitcher.setLayout(this.inspectorCardLayout);
        int loc = this.innerInspectorPanel.getDividerLocation();
        this.innerInspectorPanel.setBottomComponent(this.inspectorSwitcher);
        this.innerInspectorPanel.setDividerLocation(loc);
        int x = 0;
        while (x < this.inspectorToolbars.size()) {
            this.inspectorSwitcher.add((Component)((JComponent)this.inspectorToolbars.elementAt(x)), "" + x);
            ++x;
        }
        this.inspectorSwitcher.add((Component)new JPanel(), "-1");
        this.inspectorList.setListData(this.inspectorNames);
        if (preferredSelection >= this.inspectorToolbars.size()) {
            preferredSelection = 0;
        }
        if (preferredSelection >= this.inspectorToolbars.size()) {
            preferredSelection = -1;
        }
        this.inspectorCardLayout.show(this.inspectorSwitcher, "" + preferredSelection);
        this.inspectorList.setSelectedIndex(preferredSelection);
        boolean shouldEnableButtons = this.inspectorNames.size() > 0;
        this.detatchButton.setEnabled(shouldEnableButtons);
        this.removeButton.setEnabled(shouldEnableButtons);
    }

    void detatchInspector() {
        int currentInspector = this.inspectorList.getSelectedIndex();
        if (currentInspector == -1) {
            return;
        }
        this.inspectorNames.remove(currentInspector);
        Stoppable stoppable = (Stoppable)this.inspectorStoppables.remove(currentInspector);
        JScrollPane oldInspector = (JScrollPane)this.inspectorToolbars.remove(currentInspector);
        Point oldInspectorLocation = oldInspector.getLocationOnScreen();
        Inspector i = (Inspector)oldInspector.getViewport().getView();
        oldInspector.remove(i);
        JFrame frame = i.createFrame(stoppable);
        frame.setLocation(oldInspectorLocation);
        frame.setVisible(true);
        if (this.inspectorNames.size() == 0) {
            currentInspector = -1;
        } else if (currentInspector == this.inspectorNames.size()) {
            --currentInspector;
        }
        this.resetInspectors(currentInspector);
    }

    @Override
    public void setInspectors(final Bag inspectors, Bag names) {
        Object oldSelectedInspector = null;
        if (inspectors.objs.length > this.preferredInspectorIndex) {
            oldSelectedInspector = inspectors.objs[this.preferredInspectorIndex];
        }
        this.removeAllInspectors(false);
        if (inspectors.numObjs != names.numObjs) {
            throw new RuntimeException("Number of inspectors and names do not match");
        }
        int x = 0;
        while (x < inspectors.numObjs) {
            if (inspectors.objs[x] != null) {
                final int xx = x;
                Steppable stepper = new Steppable(){

                    @Override
                    public void step(final SimState state) {
                        59 foo = this;
                        SwingUtilities.invokeLater(new Runnable(inspectors, xx){
                            Inspector inspector;
                            {
                                this.inspector = (Inspector)bag.objs[n];
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Schedule schedule = state.schedule;
                                synchronized (schedule) {
                                    if (this.inspector.isVolatile()) {
                                        this.inspector.updateInspector();
                                        this.inspector.repaint();
                                    }
                                }
                            }
                        });
                    }
                };
                Stoppable stopper = null;
                try {
                    stopper = ((Inspector)inspectors.objs[x]).reviseStopper(this.simulation.scheduleRepeatingImmediatelyAfter(stepper));
                    this.inspectorStoppables.addElement(stopper);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                this.registerInspector((Inspector)inspectors.objs[x], stopper);
                JScrollPane scrollInspector = new JScrollPane((Component)inspectors.objs[x]);
                scrollInspector.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.inspectorSwitcher.add((Component)scrollInspector, "" + x);
                this.inspectorNames.addElement((String)names.objs[x]);
                this.inspectorToolbars.add(scrollInspector);
            }
            ++x;
        }
        this.resetInspectors(this.preferredInspectorIndex);
        try {
            this.tabPane.setSelectedComponent(this.inspectorPanel);
            Utilities.doEnsuredRepaint(this.inspectorPanel);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void registerInspector(Inspector inspector, Stoppable stopper) {
        this.allInspectors.put(inspector, stopper);
    }

    @Override
    public ArrayList getAllInspectors() {
        ArrayList<Inspector> list = new ArrayList<Inspector>();
        Iterator i = this.allInspectors.keySet().iterator();
        while (i.hasNext()) {
            list.add((Inspector)i.next());
        }
        return list;
    }

    public void stopAllInspectors(boolean killDraggedOutWindowsToo) {
        Stoppable stopper;
        for (Inspector insp : this.allInspectors.keySet()) {
            insp.updateInspector();
            insp.repaint();
        }
        int x = 0;
        while (x < this.inspectorStoppables.size()) {
            stopper = (Stoppable)this.inspectorStoppables.elementAt(x);
            if (stopper != null) {
                stopper.stop();
            }
            ++x;
        }
        if (killDraggedOutWindowsToo) {
            for (Inspector insp : this.allInspectors.keySet()) {
                stopper = (Stoppable)this.allInspectors.get(insp);
                if (stopper == null) continue;
                stopper.stop();
            }
        }
    }

    public void removeAllInspectors(boolean killDraggedOutWindowsToo) {
        this.stopAllInspectors(killDraggedOutWindowsToo);
        if (killDraggedOutWindowsToo) {
            for (Inspector inspector : this.allInspectors.keySet()) {
                inspector.disposeFrame();
            }
            this.allInspectors = new WeakHashMap();
        }
        this.inspectorStoppables = new Vector();
        this.inspectorNames = new Vector();
        this.inspectorToolbars = new Vector();
        this.resetInspectors(-1);
    }
}

