/*
 * Decompiled with CFR 0.152.
 */
package sim.app.woims3d;

import javax.swing.JFrame;
import sim.app.woims3d.Obstacle3D;
import sim.app.woims3d.Woim3D;
import sim.display3d.Display3D;
import sim.engine.SimState;
import sim.field.continuous.Continuous3D;
import sim.util.Double3D;

public class WoimsDemo3D
extends SimState {
    private static final long serialVersionUID = 1L;
    public static final double XMIN = 0.0;
    public static final double XMAX = 200.0;
    public static final double YMIN = 0.0;
    public static final double YMAX = 200.0;
    public static final double ZMIN = 0.0;
    public static final double ZMAX = 200.0;
    public static final double DIAMETER = 1.0;
    public static final double[][] obstInfo = new double[][]{{40.0, 40.0, 40.0, 40.0}, {60.0, 135.0, 135.0, 135.0}};
    public static final int NUM_WOIMS = 40;
    public static final double TIMESTEP = 30.0;
    public Display3D display;
    public JFrame displayFrame;
    public Continuous3D environment = new Continuous3D(2.0, 200.0, 200.0, 200.0);
    public Continuous3D woimEnvironment = null;
    public Continuous3D obstacles = null;
    public static final double EXTRA_SPACE = 10.0;

    public WoimsDemo3D(long seed) {
        super(seed);
    }

    public void setObjectLocation(Woim3D woim, Double3D location) {
        double x = location.x;
        while (x < -10.0) {
            x += 220.0;
        }
        while (x > 210.0) {
            x -= 220.0;
        }
        double y = location.y;
        while (y < -10.0) {
            y += 220.0;
        }
        while (y > 210.0) {
            y -= 220.0;
        }
        double z = location.z;
        while (z < -10.0) {
            z += 220.0;
        }
        while (z > 210.0) {
            z -= 220.0;
        }
        location = new Double3D(x, y, z);
        this.environment.setObjectLocation((Object)woim, location);
        this.woimEnvironment.setObjectLocation((Object)woim, location);
        woim.x = location.x;
        woim.y = location.y;
        woim.z = location.z;
    }

    @Override
    public void start() {
        super.start();
        this.environment = new Continuous3D(2.0, 200.0, 200.0, 200.0);
        this.woimEnvironment = new Continuous3D(Woim3D.MAX_DISTANCE, 200.0, 200.0, 200.0);
        this.obstacles = new Continuous3D(Math.max(200.0, Math.max(200.0, 200.0)), 200.0, 200.0, 200.0);
        int x = 0;
        while (x < 40) {
            Double3D loc = null;
            Woim3D woim = null;
            int caz = this.random.nextInt(6);
            switch (caz) {
                case 0: {
                    loc = new Double3D(-10.0, this.random.nextDouble() * 199.0 + 0.0 + 0.5, this.random.nextDouble() * 199.0 + 0.0 + 0.5);
                    break;
                }
                case 1: {
                    loc = new Double3D(210.0, this.random.nextDouble() * 199.0 + 0.0 + 0.5, this.random.nextDouble() * 199.0 + 0.0 + 0.5);
                    break;
                }
                case 2: {
                    loc = new Double3D(this.random.nextDouble() * 199.0 + 0.0 + 0.5, -10.0, this.random.nextDouble() * 199.0 + 0.0 + 0.5);
                    break;
                }
                case 3: {
                    loc = new Double3D(this.random.nextDouble() * 199.0 + 0.0 + 0.5, 210.0, this.random.nextDouble() * 199.0 + 0.0 + 0.5);
                    break;
                }
                case 4: {
                    loc = new Double3D(this.random.nextDouble() * 199.0 + 0.0 + 0.5, this.random.nextDouble() * 199.0 + 0.0 + 0.5, -10.0);
                    break;
                }
                case 5: {
                    loc = new Double3D(this.random.nextDouble() * 199.0 + 0.0 + 0.5, this.random.nextDouble() * 199.0 + 0.0 + 0.5, 210.0);
                }
            }
            woim = new Woim3D();
            this.environment.setObjectLocation((Object)woim, loc);
            this.woimEnvironment.setObjectLocation((Object)woim, loc);
            woim.x = loc.x;
            woim.y = loc.y;
            woim.z = loc.z;
            this.schedule.scheduleRepeating(woim);
            ++x;
        }
        int i = 0;
        while (i < obstInfo.length) {
            this.environment.setObjectLocation((Object)new Obstacle3D(obstInfo[i][0]), new Double3D(obstInfo[i][1], obstInfo[i][2], obstInfo[i][3]));
            ++i;
        }
    }

    public static void main(String[] args) {
        WoimsDemo3D.doLoop(WoimsDemo3D.class, args);
        System.exit(0);
    }
}

