/*
 * Decompiled with CFR 0.152.
 */
package sim.app.woims;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import sim.app.woims.Vector2D;
import sim.app.woims.WoimsDemo;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.SimplePortrayal2D;
import sim.util.Bag;
import sim.util.Double2D;

public class Woim
extends SimplePortrayal2D
implements Steppable {
    private static final long serialVersionUID = 1L;
    public static final double CENTROID_DISTANCE = 20.0;
    public static final double AVOID_DISTANCE = 16.0;
    public static final double COPY_SPEED_DISTANCE = 40.0;
    public static final double OBSTACLE_AVOID_COEF = 1.05;
    public static final double OBSTACLE_FAST_AVOID_COEF = 1.5;
    public static final double MAX_DISTANCE = Math.max(20.0, Math.max(16.0, 40.0));
    public static final double ADJUSTMENT_RATE = 0.025;
    public static final double MIN_VELOCITY = 0.25;
    public static final double MAX_VELOCITY = 0.75;
    Bag nearbyWoims;
    double[] distSqrTo;
    double ond;
    double ondSpeed;
    protected Vector2D woimPosition = new Vector2D(0.0, 0.0);
    public double x;
    public double y;
    Vector2D[] lastPos;
    Color[] colors;
    int numLinks = 7;
    protected double orientation;
    protected Vector2D velocity = new Vector2D(0.0, 0.0);
    protected Vector2D acceleration = new Vector2D(0.0, 0.0);

    public Woim() {
        this.ond = Math.random() * 6.2832;
        this.ondSpeed = 0.05 + Math.random() * 0.15;
        this.setNumberOfLinks(this.numLinks);
    }

    public final double distanceSquared(Vector2D loc1, Vector2D loc2) {
        return (loc1.x - loc2.x) * (loc1.x - loc2.x) + (loc1.y - loc2.y) * (loc1.y - loc2.y);
    }

    public final double distanceSquared(Vector2D loc1, Double2D loc2) {
        return (loc1.x - loc2.x) * (loc1.x - loc2.x) + (loc1.y - loc2.y) * (loc1.y - loc2.y);
    }

    public final double distanceSquared(double x1, double y1, double x2, double y2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
    }

    public final double dotproduct(Vector2D loc1, Vector2D loc2) {
        return loc1.x * loc2.x + loc1.y * loc2.y;
    }

    void preprocessWoims(WoimsDemo state, Double2D pos, double distance) {
        this.nearbyWoims = state.woimsEnvironment.getNeighborsWithinDistance(pos, distance);
        if (this.nearbyWoims == null) {
            return;
        }
        this.distSqrTo = new double[this.nearbyWoims.numObjs];
        int i = 0;
        while (i < this.nearbyWoims.numObjs) {
            Woim p = (Woim)this.nearbyWoims.objs[i];
            this.distSqrTo[i] = this.distanceSquared(pos.x, pos.y, p.x, p.y);
            ++i;
        }
    }

    public Vector2D towardsFlockCenterOfMass(WoimsDemo state) {
        if (this.nearbyWoims == null) {
            return new Vector2D(0.0, 0.0);
        }
        Vector2D mean = new Vector2D(0.0, 0.0);
        int n = 0;
        int i = 0;
        while (i < this.nearbyWoims.numObjs) {
            if (this.nearbyWoims.objs[i] != this && this.distSqrTo[i] <= 400.0 && this.distSqrTo[i] > 256.0) {
                Woim p = (Woim)this.nearbyWoims.objs[i];
                mean = mean.add(new Double2D(p.x, p.y));
                ++n;
            }
            ++i;
        }
        if (n == 0) {
            return new Vector2D(0.0, 0.0);
        }
        mean = mean.amplify(1.0 / (double)n);
        mean = mean.subtract(this.woimPosition);
        return mean.normalize();
    }

    public Vector2D awayFromCloseBys(WoimsDemo state) {
        if (this.nearbyWoims == null) {
            return new Vector2D(0.0, 0.0);
        }
        Vector2D away = new Vector2D(0.0, 0.0);
        int i = 0;
        while (i < this.nearbyWoims.numObjs) {
            if (this.nearbyWoims.objs[i] != this && this.distSqrTo[i] <= 256.0) {
                Woim p = (Woim)this.nearbyWoims.objs[i];
                Vector2D temp = this.woimPosition.subtract(new Double2D(p.x, p.y));
                temp = temp.normalize();
                away = away.add(temp);
            }
            ++i;
        }
        return away.normalize();
    }

    public Vector2D matchFlockSpeed(SimState state) {
        if (this.nearbyWoims == null) {
            return new Vector2D(0.0, 0.0);
        }
        Vector2D mean = new Vector2D(0.0, 0.0);
        int n = 0;
        int i = 0;
        while (i < this.nearbyWoims.numObjs) {
            if (this.nearbyWoims.objs[i] != this && this.distSqrTo[i] <= 1600.0 && this.distSqrTo[i] > 256.0) {
                mean = mean.add(((Woim)this.nearbyWoims.objs[i]).velocity);
                ++n;
            }
            ++i;
        }
        if (n == 0) {
            return new Vector2D(0.0, 0.0);
        }
        mean = mean.amplify(1.0 / (double)n);
        return mean.normalize();
    }

    public Vector2D randomDirection(SimState state) {
        Vector2D temp = new Vector2D(1.0 - 2.0 * state.random.nextDouble(), 1.0 - 2.0 * state.random.nextDouble());
        return temp.setLength(0.25 + state.random.nextDouble() * 0.5);
    }

    public Vector2D niceUndulation(SimState state) {
        this.ond += this.ondSpeed;
        if (this.ond > 7.0) {
            this.ond -= 6.2832;
        }
        double angle = Math.cos(this.ond);
        Vector2D temp = this.velocity;
        double velA = Math.atan2(temp.y, temp.x);
        return new Vector2D(Math.cos(velA += 1.5708 * angle), Math.sin(velA));
    }

    public Vector2D avoidObstacles(SimState state) {
        double[][] info = WoimsDemo.obstInfo;
        if (info == null || info.length == 0) {
            return new Vector2D(0.0, 0.0);
        }
        Vector2D away = new Vector2D(0.0, 0.0);
        int i = 0;
        while (i < info.length) {
            double dist = Math.sqrt((this.woimPosition.x - info[i][1]) * (this.woimPosition.x - info[i][1]) + (this.woimPosition.y - info[i][2]) * (this.woimPosition.y - info[i][2]));
            if (dist <= info[i][0] + 16.0) {
                Vector2D temp = this.woimPosition.subtract(new Vector2D(info[i][1], info[i][2]));
                temp = temp.normalize();
                away = away.add(temp);
            }
            ++i;
        }
        return away.normalize();
    }

    @Override
    public void step(SimState state) {
        double vl;
        WoimsDemo bd = (WoimsDemo)state;
        Double2D temp = new Double2D(this.x, this.y);
        this.woimPosition.x = this.x;
        this.woimPosition.y = this.y;
        this.preprocessWoims(bd, temp, MAX_DISTANCE);
        Vector2D vel = new Vector2D(0.0, 0.0);
        vel = vel.add(this.avoidObstacles(bd).amplify(1.5));
        vel = vel.add(this.towardsFlockCenterOfMass(bd).amplify(0.5));
        vel = vel.add(this.matchFlockSpeed(bd).amplify(0.5));
        vel = vel.add(this.awayFromCloseBys(bd).amplify(1.5));
        if (vel.length() <= 1.0) {
            vel = vel.add(this.niceUndulation(bd).amplify(0.5));
            vel = vel.add(this.randomDirection(bd).amplify(0.25));
        }
        if ((vl = vel.length()) < 0.25) {
            vel = vel.setLength(0.25);
        } else if (vl > 0.75) {
            vel = vel.setLength(0.75);
        }
        this.velocity = vel = new Vector2D(0.975 * this.velocity.x + 0.025 * vel.x, 0.975 * this.velocity.y + 0.025 * vel.y);
        Double2D desiredPosition = new Double2D(this.woimPosition.x + vel.x * 2.0, this.woimPosition.y + vel.y * 2.0);
        bd.setObjectLocation(this, desiredPosition);
        this.updateLinkPosition();
    }

    public int getNumberOfLinks() {
        return this.numLinks;
    }

    public void setNumberOfLinks(int n) {
        if (this.numLinks == n && this.colors != null) {
            return;
        }
        if (n <= 0) {
            return;
        }
        if (n > 1000) {
            n = 1000;
        }
        this.numLinks = n;
        this.lastPos = new Vector2D[this.numLinks];
        this.colors = new Color[this.numLinks];
        int i = 0;
        while (i < this.colors.length) {
            this.colors[i] = new Color((int)(63.0 + 192.0 * (double)(this.colors.length - i) / (double)this.colors.length), 0, 0);
            ++i;
        }
        this.updateLinkPosition();
    }

    void drawLink(Graphics2D graphics, double x, double y, double rx, double ry, Color color) {
        graphics.setColor(color);
        graphics.fillOval((int)(x - rx / 2.0), (int)(y - ry / 2.0), (int)rx, (int)ry);
    }

    public void updateLinkPosition() {
        double centerx = this.x;
        double centery = this.y;
        this.lastPos[0] = new Vector2D(centerx, centery);
        int i = 1;
        while (i < this.numLinks) {
            Vector2D temp;
            if (this.lastPos[i] == null) {
                temp = this.velocity.normalize().amplify(-1.0);
                centerx = this.lastPos[i - 1].x + 1.0 * temp.x;
                centery = this.lastPos[i - 1].y + 1.0 * temp.y;
                this.lastPos[i] = new Vector2D(centerx, centery);
            } else {
                temp = this.lastPos[i - 1].subtract(this.lastPos[i]);
                temp = temp.setLength(1.0);
                this.lastPos[i] = temp = this.lastPos[i - 1].subtract(temp);
            }
            ++i;
        }
    }

    @Override
    public final void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        if (this.lastPos == null) {
            return;
        }
        int i = 0;
        while (i < this.numLinks) {
            if (this.lastPos[i] != null) {
                this.drawLink(graphics, info.draw.x + info.draw.width * (this.lastPos[i].x - this.lastPos[0].x), info.draw.y + info.draw.height * (this.lastPos[i].y - this.lastPos[0].y), info.draw.width, info.draw.height, this.colors[i]);
            }
            ++i;
        }
    }

    @Override
    public boolean hitObject(Object object, DrawInfo2D info) {
        if (this.lastPos == null) {
            return false;
        }
        int i = 0;
        while (i < this.numLinks) {
            Ellipse2D.Double ellipse;
            if (this.lastPos[i] != null && (ellipse = new Ellipse2D.Double(info.draw.x + info.draw.width * (this.lastPos[i].x - this.lastPos[0].x), info.draw.y + info.draw.height * (this.lastPos[i].y - this.lastPos[0].y), info.draw.width, info.draw.height)).intersects(info.clip.x, info.clip.y, info.clip.width, info.clip.height)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

