/*
 * Decompiled with CFR 0.152.
 */
package sim.app.wcss.tutorial14;

import java.awt.Color;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import javax.swing.JFrame;
import sim.app.wcss.tutorial14.Student;
import sim.app.wcss.tutorial14.Students;
import sim.display.Console;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.display3d.Display3D;
import sim.engine.SimState;
import sim.field.network.Edge;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.Inspector;
import sim.portrayal.continuous.ContinuousPortrayal2D;
import sim.portrayal.network.NetworkPortrayal2D;
import sim.portrayal.network.SimpleEdgePortrayal2D;
import sim.portrayal.network.SpatialNetwork2D;
import sim.portrayal.simple.CircledPortrayal2D;
import sim.portrayal.simple.LabelledPortrayal2D;
import sim.portrayal.simple.MovablePortrayal2D;
import sim.portrayal.simple.OvalPortrayal2D;
import sim.portrayal3d.continuous.ContinuousPortrayal3D;
import sim.portrayal3d.network.CylinderEdgePortrayal3D;
import sim.portrayal3d.network.NetworkPortrayal3D;
import sim.portrayal3d.network.SpatialNetwork3D;
import sim.portrayal3d.simple.ConePortrayal3D;

public class StudentsWithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    ContinuousPortrayal2D yardPortrayal = new ContinuousPortrayal2D();
    NetworkPortrayal2D buddiesPortrayal = new NetworkPortrayal2D();
    public Display3D display3d;
    public JFrame displayFrame3d;
    ContinuousPortrayal3D agitatedYardPortrayal = new ContinuousPortrayal3D();
    NetworkPortrayal3D agitatedBuddiesPortrayal = new NetworkPortrayal3D();

    public static void main(String[] args) {
        StudentsWithUI vid = new StudentsWithUI();
        Console c = new Console(vid);
        c.setVisible(true);
    }

    public StudentsWithUI() {
        super(new Students(System.currentTimeMillis()));
    }

    public StudentsWithUI(SimState state) {
        super(state);
    }

    @Override
    public Object getSimulationInspectedObject() {
        return this.state;
    }

    @Override
    public Inspector getInspector() {
        Inspector i = super.getInspector();
        i.setVolatile(true);
        return i;
    }

    public static String getName() {
        return "WCSS Tutorial 14: Student Cliques (in 3D)";
    }

    @Override
    public void start() {
        super.start();
        this.setupPortrayals();
    }

    @Override
    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        Students students = (Students)this.state;
        this.yardPortrayal.setField(students.yard);
        this.yardPortrayal.setPortrayalForAll(new MovablePortrayal2D(new CircledPortrayal2D(new LabelledPortrayal2D(new OvalPortrayal2D(){

            @Override
            public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
                Student student = (Student)object;
                int agitationShade = (int)(student.getAgitation() * 255.0 / 10.0);
                if (agitationShade > 255) {
                    agitationShade = 255;
                }
                this.paint = new Color(agitationShade, 0, 255 - agitationShade);
                super.draw(object, graphics, info);
            }
        }, 5.0, null, Color.black, true), 0.0, 5.0, Color.green, true)));
        this.buddiesPortrayal.setField(new SpatialNetwork2D(students.yard, students.buddies));
        this.buddiesPortrayal.setPortrayalForAll(new SimpleEdgePortrayal2D());
        this.display.reset();
        this.display.setBackdrop(Color.white);
        this.display.repaint();
        this.agitatedYardPortrayal.setField(students.agitatedYard);
        this.agitatedYardPortrayal.setPortrayalForAll(new ConePortrayal3D(Color.red, 2.0));
        this.agitatedBuddiesPortrayal.setField(new SpatialNetwork3D(students.agitatedYard, students.buddies));
        CylinderEdgePortrayal3D ep = new CylinderEdgePortrayal3D(){
            DecimalFormat format = new DecimalFormat("#.##");

            @Override
            public String getLabel(Edge edge) {
                return this.format.format(edge.getWeight());
            }
        };
        ep.setLabelScale(0.5);
        this.agitatedBuddiesPortrayal.setPortrayalForAll(ep);
        this.display3d.createSceneGraph();
        this.display3d.reset();
    }

    @Override
    public void init(Controller c) {
        super.init(c);
        this.display = new Display2D(600.0, 600.0, this);
        this.display.setClipping(false);
        this.displayFrame = this.display.createFrame();
        this.displayFrame.setTitle("Schoolyard Display");
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach(this.buddiesPortrayal, "Buddies");
        this.display.attach(this.yardPortrayal, "Yard");
        this.display3d = new Display3D(300.0, 300.0, this);
        double width = 100.0;
        this.display3d.translate(-width / 2.0, -width / 2.0, 0.0);
        this.display3d.scale(2.0 / width);
        this.displayFrame3d = this.display3d.createFrame();
        this.displayFrame3d.setTitle("Schoolyard Display... NOW IN 3-D!");
        c.registerFrame(this.displayFrame3d);
        this.displayFrame3d.setVisible(true);
        this.display3d.attach(this.agitatedBuddiesPortrayal, "Buddies ... IN 3-D!");
        this.display3d.attach(this.agitatedYardPortrayal, "Yard ... IN 3-D!");
    }

    @Override
    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
        if (this.displayFrame3d != null) {
            this.displayFrame3d.dispose();
        }
        this.displayFrame3d = null;
        this.display3d = null;
    }
}

