/*
 * Decompiled with CFR 0.152.
 */
package sim.app.wcss.tutorial10;

import java.awt.Color;
import java.awt.Graphics2D;
import javax.swing.JFrame;
import sim.app.wcss.tutorial10.Student;
import sim.app.wcss.tutorial10.Students;
import sim.display.Console;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.engine.SimState;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.Inspector;
import sim.portrayal.continuous.ContinuousPortrayal2D;
import sim.portrayal.network.NetworkPortrayal2D;
import sim.portrayal.network.SimpleEdgePortrayal2D;
import sim.portrayal.network.SpatialNetwork2D;
import sim.portrayal.simple.OvalPortrayal2D;

public class StudentsWithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    ContinuousPortrayal2D yardPortrayal = new ContinuousPortrayal2D();
    NetworkPortrayal2D buddiesPortrayal = new NetworkPortrayal2D();

    public static void main(String[] args) {
        StudentsWithUI vid = new StudentsWithUI();
        Console c = new Console(vid);
        c.setVisible(true);
    }

    public StudentsWithUI() {
        super(new Students(System.currentTimeMillis()));
    }

    public StudentsWithUI(SimState state) {
        super(state);
    }

    @Override
    public Object getSimulationInspectedObject() {
        return this.state;
    }

    @Override
    public Inspector getInspector() {
        Inspector i = super.getInspector();
        i.setVolatile(true);
        return i;
    }

    public static String getName() {
        return "WCSS 2008 Tutorial";
    }

    @Override
    public void start() {
        super.start();
        this.setupPortrayals();
    }

    @Override
    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        Students students = (Students)this.state;
        this.yardPortrayal.setField(students.yard);
        this.yardPortrayal.setPortrayalForAll(new OvalPortrayal2D(){

            @Override
            public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
                Student student = (Student)object;
                int agitationShade = (int)(student.getAgitation() * 255.0 / 10.0);
                if (agitationShade > 255) {
                    agitationShade = 255;
                }
                this.paint = new Color(agitationShade, 0, 255 - agitationShade);
                super.draw(object, graphics, info);
            }
        });
        this.buddiesPortrayal.setField(new SpatialNetwork2D(students.yard, students.buddies));
        this.buddiesPortrayal.setPortrayalForAll(new SimpleEdgePortrayal2D());
        this.display.reset();
        this.display.setBackdrop(Color.white);
        this.display.repaint();
    }

    @Override
    public void init(Controller c) {
        super.init(c);
        this.display = new Display2D(600.0, 600.0, this);
        this.display.setClipping(false);
        this.displayFrame = this.display.createFrame();
        this.displayFrame.setTitle("Schoolyard Display");
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach(this.buddiesPortrayal, "Buddies");
        this.display.attach(this.yardPortrayal, "Yard");
    }

    @Override
    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

