/*
 * Decompiled with CFR 0.152.
 */
package sim.app.virus;

import java.awt.Color;
import java.awt.Graphics2D;
import sim.app.virus.Agent;
import sim.app.virus.VirusInfectionDemo;
import sim.engine.SimState;
import sim.portrayal.DrawInfo2D;
import sim.util.Double2D;

public class Human
extends Agent {
    private static final long serialVersionUID = 1L;
    protected boolean infected = false;
    Double2D desiredLocation = null;
    Double2D suggestedLocation = null;
    int steps = 0;
    protected Color humanColor = new Color(192, 128, 128);
    protected Color infectedColor = new Color(128, 255, 128);

    public final boolean isInfected() {
        return this.infected;
    }

    public final void setInfected(boolean b) {
        this.infected = b;
    }

    public Human(String id, Double2D location) {
        super(id, location);
        try {
            this.intID = Integer.parseInt(id.substring(5));
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("Exception generated: " + e);
            System.exit(1);
        }
        catch (NumberFormatException e) {
            System.err.println("Exception generated: " + e);
            System.exit(1);
        }
    }

    @Override
    public void step(SimState state) {
        double dy;
        double dx;
        double temp;
        VirusInfectionDemo hb = (VirusInfectionDemo)state;
        --this.steps;
        if (this.desiredLocation == null || this.steps <= 0) {
            this.desiredLocation = new Double2D((state.random.nextDouble() - 0.5) * 152.0 + this.agentLocation.x, (state.random.nextDouble() - 0.5) * 112.0 + this.agentLocation.y);
            this.steps = 50 + state.random.nextInt(50);
        }
        if ((temp = Math.sqrt((dx = this.desiredLocation.x - this.agentLocation.x) * dx + (dy = this.desiredLocation.y - this.agentLocation.y) * dy)) < 1.0) {
            this.steps = 0;
        } else {
            dx /= temp;
            dy /= temp;
        }
        if (!hb.acceptablePosition(this, new Double2D(this.agentLocation.x + dx, this.agentLocation.y + dy))) {
            this.steps = 0;
        } else {
            this.agentLocation = new Double2D(this.agentLocation.x + dx, this.agentLocation.y + dy);
            hb.environment.setObjectLocation((Object)this, this.agentLocation);
        }
    }

    @Override
    public final void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        double diamx = info.draw.width * 8.0;
        double diamy = info.draw.height * 8.0;
        if (this.isInfected()) {
            graphics.setColor(this.infectedColor);
        } else {
            graphics.setColor(this.humanColor);
        }
        graphics.fillOval((int)(info.draw.x - diamx / 2.0), (int)(info.draw.y - diamy / 2.0), (int)diamx, (int)diamy);
    }

    @Override
    public String getType() {
        if (this.isInfected()) {
            return "Infected Human";
        }
        return "Healthy Human";
    }
}

