/*
 * Decompiled with CFR 0.152.
 */
package sim.app.pso;

import java.awt.Color;
import java.awt.Graphics2D;
import javax.swing.JFrame;
import sim.app.pso.PSO;
import sim.app.pso.Particle;
import sim.display.Controller;
import sim.display.Display2D;
import sim.display.GUIState;
import sim.engine.SimState;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.continuous.ContinuousPortrayal2D;
import sim.portrayal.simple.RectanglePortrayal2D;
import sim.util.gui.SimpleColorMap;

public class PSOWithUI
extends GUIState {
    public Display2D display;
    public JFrame displayFrame;
    ContinuousPortrayal2D swarmPortrayal = new ContinuousPortrayal2D();

    public static void main(String[] args) {
        new PSOWithUI().createController();
    }

    @Override
    public Object getSimulationInspectedObject() {
        return this.state;
    }

    public static String getName() {
        return "Particle Swarm Optimization";
    }

    public PSOWithUI() {
        super(new PSO(System.currentTimeMillis()));
    }

    public PSOWithUI(SimState state) {
        super(state);
    }

    @Override
    public void start() {
        super.start();
        this.setupPortrayals();
    }

    @Override
    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        double h;
        PSO swarm = (PSO)this.state;
        final SimpleColorMap map = new SimpleColorMap(swarm.fitnessFunctionLowerBound[swarm.fitnessFunction], 1000.0, Color.blue, Color.red);
        this.swarmPortrayal.setField(swarm.space);
        int x = 0;
        while (x < swarm.space.allObjects.numObjs) {
            final Particle p = (Particle)swarm.space.allObjects.objs[x];
            this.swarmPortrayal.setPortrayalForObject(p, new RectanglePortrayal2D(Color.green, 0.05){

                @Override
                public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
                    this.paint = map.getColor(p.getFitness());
                    super.draw(object, graphics, info);
                }
            });
            ++x;
        }
        double w = swarm.space.getWidth();
        if (w == (h = swarm.space.getHeight())) {
            this.display.insideDisplay.height = 750.0;
            this.display.insideDisplay.width = 750.0;
        } else if (w > h) {
            this.display.insideDisplay.width = 750.0;
            this.display.insideDisplay.height = 750.0 * (h / w);
        } else if (w < h) {
            this.display.insideDisplay.height = 750.0;
            this.display.insideDisplay.width = 750.0 * (w / h);
        }
        this.display.reset();
        this.display.repaint();
    }

    @Override
    public void init(Controller c) {
        super.init(c);
        this.display = new Display2D(750.0, 750.0, this);
        this.display.setBackdrop(Color.black);
        this.displayFrame = this.display.createFrame();
        this.displayFrame.setTitle("Particle Swarm Optimization");
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
        this.display.attach(this.swarmPortrayal, "Behold the Swarm!", this.display.insideDisplay.width * 0.5, this.display.insideDisplay.height * 0.5, true);
    }

    @Override
    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }
}

