/*
 * Decompiled with CFR 0.152.
 */
package sim.app.particles3d;

import java.awt.Color;
import javax.swing.JFrame;
import sim.app.particles3d.Particles3D;
import sim.display.Controller;
import sim.display.GUIState;
import sim.display3d.Display3D;
import sim.engine.SimState;
import sim.portrayal3d.grid.SparseGridPortrayal3D;
import sim.portrayal3d.grid.ValueGridPortrayal3D;
import sim.portrayal3d.simple.SpherePortrayal3D;
import sim.portrayal3d.simple.WireFrameBoxPortrayal3D;
import sim.util.gui.SimpleColorMap;

public class Particles3DWithUI
extends GUIState {
    public Display3D display;
    public JFrame displayFrame;
    SparseGridPortrayal3D particlesPortrayal = new SparseGridPortrayal3D();
    ValueGridPortrayal3D trailsPortrayal = new ValueGridPortrayal3D("Trail");
    WireFrameBoxPortrayal3D wireFramePortrayal;

    public static void main(String[] args) {
        new Particles3DWithUI().createController();
    }

    public Particles3DWithUI() {
        super(new Particles3D(System.currentTimeMillis()));
    }

    public Particles3DWithUI(SimState state) {
        super(state);
    }

    public static String getName() {
        return "3D Particles";
    }

    @Override
    public void quit() {
        super.quit();
        if (this.displayFrame != null) {
            this.displayFrame.dispose();
        }
        this.displayFrame = null;
        this.display = null;
    }

    @Override
    public void start() {
        super.start();
        this.setupPortrayals();
    }

    @Override
    public void load(SimState state) {
        super.load(state);
        this.setupPortrayals();
    }

    public void setupPortrayals() {
        this.particlesPortrayal.setField(((Particles3D)this.state).particles);
        this.particlesPortrayal.setPortrayalForAll(new SpherePortrayal3D(Color.red));
        this.trailsPortrayal.setField(((Particles3D)this.state).trails);
        this.trailsPortrayal.setMap(new SimpleColorMap(0.0, 1.0, new Color(0, 0, 0, 0), Color.black));
        this.display.reset();
        this.display.createSceneGraph();
    }

    @Override
    public void init(Controller c) {
        super.init(c);
        this.display = new Display3D(600.0, 600.0, this);
        this.wireFramePortrayal = new WireFrameBoxPortrayal3D(-0.5, -0.5, -0.5, (double)Particles3D.gridWidth, (double)Particles3D.gridHeight, (double)Particles3D.gridLength, Color.blue);
        this.display.attach(this.wireFramePortrayal, "Wire Frame");
        this.display.attach(this.particlesPortrayal, "Particles");
        this.display.attach(this.trailsPortrayal, "Trails");
        this.display.translate(-Particles3D.gridWidth / 2, -Particles3D.gridHeight / 2, -Particles3D.gridLength / 2);
        this.display.scale(1.0 / (double)Particles3D.gridWidth);
        this.display.setBackdrop(Color.white);
        this.displayFrame = this.display.createFrame();
        c.registerFrame(this.displayFrame);
        this.displayFrame.setVisible(true);
    }
}

