/*
 * Decompiled with CFR 0.152.
 */
package sim.app.mav;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.SimplePortrayal2D;

public class Region
extends SimplePortrayal2D {
    private static final long serialVersionUID = 1L;
    public static final Shape[] shapes = new Shape[]{new Ellipse2D.Double(0.0, 0.0, 100.0, 100.0), AffineTransform.getRotateInstance(0.6108652381980153).createTransformedShape(new RoundRectangle2D.Double(0.0, 0.0, 100.0, 100.0, 15.0, 15.0)), new Font("Serif", 0, 128).createGlyphVector(new FontRenderContext(new AffineTransform(), false, true), "MAV").getOutline()};
    public double originx;
    public double originy;
    int shapeNum;
    public static final Color[] surfacecolors = new Color[]{Color.white, Color.blue, Color.green, Color.red};
    public Shape shape;
    public Area area;
    public int surface;
    Shape oldShape;
    Rectangle2D.Double oldDraw = null;

    public Region(int num, int s, double x, double y) {
        this.shapeNum = num;
        this.shape = shapes[this.shapeNum];
        this.surface = s;
        this.area = new Area(this.shape);
        this.originx = x;
        this.originy = y;
    }

    @Override
    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        if (this.oldDraw == null || this.oldDraw.x != info.draw.x || this.oldDraw.y != info.draw.y || this.oldDraw.width != info.draw.width || this.oldDraw.height != info.draw.height) {
            this.oldDraw = info.draw;
            AffineTransform transform = new AffineTransform();
            transform.translate(this.oldDraw.x, this.oldDraw.y);
            transform.scale(this.oldDraw.width, this.oldDraw.height);
            this.oldShape = transform.createTransformedShape(this.shape);
        }
        graphics.setColor(surfacecolors[this.surface]);
        graphics.fill(this.oldShape);
    }

    @Override
    public boolean hitObject(Object object, DrawInfo2D range) {
        AffineTransform transform = new AffineTransform();
        transform.translate(range.draw.x, range.draw.y);
        transform.scale(range.draw.width, range.draw.height);
        Shape s = transform.createTransformedShape(this.shape);
        return s.intersects(range.clip.x, range.clip.y, range.clip.width, range.clip.height);
    }

    private void writeObject(ObjectOutputStream p) throws IOException {
        p.writeDouble(this.originx);
        p.writeDouble(this.originy);
        p.writeInt(this.shapeNum);
        p.writeInt(this.surface);
    }

    private void readObject(ObjectInputStream p) throws IOException, ClassNotFoundException {
        this.originx = p.readDouble();
        this.originy = p.readDouble();
        this.shapeNum = p.readInt();
        this.surface = p.readInt();
        this.shape = shapes[this.shapeNum];
        this.area = new Area(this.shape);
    }
}

