/*
 * Decompiled with CFR 0.152.
 */
package sim.app.lsystem;

import java.io.Serializable;

public class ByteList
implements Serializable {
    private static final long serialVersionUID = 1L;
    public byte[] b;
    public int length = 0;

    ByteList() {
        this.b = new byte[16];
    }

    ByteList(int size) {
        this.b = new byte[size];
    }

    ByteList(ByteList a) {
        this.b = new byte[a.b.length];
        System.arraycopy(a.b, 0, this.b, 0, a.length);
        this.length = a.length;
    }

    public void resize(int toAtLeast) {
        if (this.b.length >= toAtLeast) {
            return;
        }
        if (this.b.length * 2 > toAtLeast) {
            toAtLeast = this.b.length * 2;
        }
        byte[] newb = new byte[toAtLeast];
        System.arraycopy(this.b, 0, newb, 0, this.length);
        this.b = newb;
    }

    public void add(byte n) {
        if (this.length + 1 > this.b.length) {
            this.resize(this.length + 1);
        }
        this.b[this.length] = n;
        ++this.length;
    }

    public void addAll(ByteList a) {
        if (this.length + a.length > this.b.length) {
            this.resize(this.length + a.length);
        }
        System.arraycopy(a.b, 0, this.b, this.length, a.length);
        this.length += a.length;
    }

    public void clear() {
        this.b = new byte[16];
        this.length = 0;
    }
}

