/*
 * Decompiled with CFR 0.152.
 */
package sim.app.hexabugs;

import sim.app.hexabugs.HexaBug;
import sim.app.hexabugs.HexaDiffuser;
import sim.app.hexabugs.ThreadedHexaDiffuser;
import sim.engine.SimState;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.SparseGrid2D;
import sim.util.DoubleBag;
import sim.util.IntBag;
import sim.util.Interval;

public class HexaBugs
extends SimState {
    private static final long serialVersionUID = 1L;
    public double minIdealTemp = 17000.0;
    public double maxIdealTemp = 31000.0;
    public double minOutputHeat = 6000.0;
    public double maxOutputHeat = 10000.0;
    public double evaporationRate = 0.993;
    public double diffusionRate = 1.0;
    public static final double MAX_HEAT = 32000.0;
    public double randomMovementProbability = 0.1;
    public int gridHeight = 100;
    public int gridWidth = 100;
    public int bugCount = 100;
    HexaBug[] bugs;
    public DoubleGrid2D valgrid = new DoubleGrid2D(this.gridWidth, this.gridHeight, 0.0);
    public DoubleGrid2D valgrid2 = new DoubleGrid2D(this.gridWidth, this.gridHeight, 0.0);
    public SparseGrid2D buggrid = new SparseGrid2D(this.gridWidth, this.gridHeight);
    DoubleBag neighVal = new DoubleBag();
    IntBag neighX = new IntBag();
    IntBag neighY = new IntBag();
    ThreadedHexaDiffuser diffuser = null;

    public double getMinimumIdealTemperature() {
        return this.minIdealTemp;
    }

    public void setMinimumIdealTemperature(double temp) {
        if (temp <= this.maxIdealTemp) {
            this.minIdealTemp = temp;
        }
    }

    public double getMaximumIdealTemperature() {
        return this.maxIdealTemp;
    }

    public void setMaximumIdealTemperature(double temp) {
        if (temp >= this.minIdealTemp) {
            this.maxIdealTemp = temp;
        }
    }

    public double getMinimumOutputHeat() {
        return this.minOutputHeat;
    }

    public void setMinimumOutputHeat(double temp) {
        if (temp <= this.maxOutputHeat) {
            this.minOutputHeat = temp;
        }
    }

    public double getMaximumOutputHeat() {
        return this.maxOutputHeat;
    }

    public void setMaximumOutputHeat(double temp) {
        if (temp >= this.minOutputHeat) {
            this.maxOutputHeat = temp;
        }
    }

    public Object domEvaporationConstant() {
        return new Interval(0.0, 1.0);
    }

    public double getEvaporationConstant() {
        return this.evaporationRate;
    }

    public void setEvaporationConstant(double temp) {
        if (temp >= 0.0 && temp <= 1.0) {
            this.evaporationRate = temp;
        }
    }

    public Object domDiffusionConstant() {
        return new Interval(0.0, 1.0);
    }

    public double getDiffusionConstant() {
        return this.diffusionRate;
    }

    public void setDiffusionConstant(double temp) {
        if (temp >= 0.0 && temp <= 1.0) {
            this.diffusionRate = temp;
        }
    }

    public Object domRandomMovementProbability() {
        return new Interval(0.0, 1.0);
    }

    public double getRandomMovementProbability() {
        return this.randomMovementProbability;
    }

    public void setRandomMovementProbability(double t) {
        if (t >= 0.0 && t <= 1.0) {
            this.randomMovementProbability = t;
            int i = 0;
            while (i < this.bugCount) {
                if (this.bugs[i] != null) {
                    this.bugs[i].setRandomMovementProbability(this.randomMovementProbability);
                }
                ++i;
            }
        }
    }

    public double getMaximumHeat() {
        return 32000.0;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public int getBugCount() {
        return this.bugCount;
    }

    public void setBugCount(int val) {
        if (val >= 0) {
            this.bugCount = val;
        }
    }

    public HexaBugs(long seed) {
        super(seed);
        this.bugs = new HexaBug[this.bugCount];
    }

    @Override
    public void start() {
        super.start();
        this.valgrid = new DoubleGrid2D(this.gridWidth, this.gridHeight, 0.0);
        this.valgrid2 = new DoubleGrid2D(this.gridWidth, this.gridHeight, 0.0);
        this.buggrid = new SparseGrid2D(this.gridWidth, this.gridHeight);
        this.bugs = new HexaBug[this.bugCount];
        int x = 0;
        while (x < this.bugCount) {
            this.bugs[x] = new HexaBug(this.random.nextDouble() * (this.maxIdealTemp - this.minIdealTemp) + this.minIdealTemp, this.random.nextDouble() * (this.maxOutputHeat - this.minOutputHeat) + this.minOutputHeat, 32000.0, this.randomMovementProbability);
            this.buggrid.setObjectLocation(this.bugs[x], this.random.nextInt(this.gridWidth), this.random.nextInt(this.gridHeight));
            this.schedule.scheduleRepeating(this.bugs[x]);
            ++x;
        }
        if (this.availableProcessors() > 1) {
            this.diffuser = new ThreadedHexaDiffuser(this.valgrid, this.valgrid2, this.evaporationRate, this.diffusionRate);
            this.schedule.scheduleRepeating(0.0, 1, this.diffuser, 1.0);
        } else {
            this.schedule.scheduleRepeating(0.0, 1, new HexaDiffuser(this.valgrid, this.valgrid2, this.evaporationRate, this.diffusionRate), 1.0);
        }
    }

    public void stop() {
        if (this.diffuser != null) {
            this.diffuser.cleanup();
        }
        this.diffuser = null;
    }

    public int availableProcessors() {
        Runtime runtime = Runtime.getRuntime();
        try {
            return (Integer)runtime.getClass().getMethod("availableProcessors", null).invoke((Object)runtime, null);
        }
        catch (Exception e) {
            return 1;
        }
    }

    public static void main(String[] args) {
        HexaBugs.doLoop(HexaBugs.class, args);
        System.exit(0);
    }
}

