/*
 * Decompiled with CFR 0.152.
 */
package sim.app.hexabugs;

import sim.app.hexabugs.HexaBugs;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.grid.DoubleGrid2D;
import sim.util.DoubleBag;
import sim.util.Int2D;
import sim.util.IntBag;

public class HexaBug
implements Steppable {
    private static final long serialVersionUID = 1L;
    public double idealTemp;
    public double heatOutput;
    public double maxHeat;
    public double randomMovementProbability;

    public double getIdealTemperature() {
        return this.idealTemp;
    }

    public void setIdealTemperature(double t) {
        this.idealTemp = t;
    }

    public double getHeatOutput() {
        return this.heatOutput;
    }

    public void setHeatOutput(double t) {
        this.heatOutput = t;
    }

    public double getMaximumHeat() {
        return this.maxHeat;
    }

    public void setMaximumHeat(double t) {
        this.maxHeat = t;
    }

    public double getRandomMovementProbability() {
        return this.randomMovementProbability;
    }

    public void setRandomMovementProbability(double t) {
        this.randomMovementProbability = t;
    }

    public HexaBug(double idealTemp, double heatOutput, double maxHeat, double randomMovementProbability) {
        this.heatOutput = heatOutput;
        this.idealTemp = idealTemp;
        this.maxHeat = maxHeat;
        this.randomMovementProbability = randomMovementProbability;
    }

    public void addHeat(DoubleGrid2D grid, int x, int y, double Heat) {
        double[] dArray = grid.field[x];
        int n = y;
        dArray[n] = dArray[n] + Heat;
        if (grid.field[x][y] > this.maxHeat) {
            grid.field[x][y] = this.maxHeat;
        }
    }

    @Override
    public void step(SimState state) {
        HexaBugs hb = (HexaBugs)state;
        DoubleBag neighVal = hb.neighVal;
        IntBag neighX = hb.neighX;
        IntBag neighY = hb.neighY;
        Int2D location = hb.buggrid.getObjectLocation(this);
        int myx = location.x;
        int myy = location.y;
        int START = -1;
        int bestx = -1;
        int besty = 0;
        DoubleGrid2D cfr_ignored_0 = hb.valgrid;
        hb.valgrid.getHexagonalNeighbors(myx, myy, 1, 2, true, neighVal, neighX, neighY);
        if (state.random.nextBoolean(this.randomMovementProbability)) {
            int temp_random = state.random.nextInt(neighX.numObjs);
            bestx = neighX.objs[temp_random];
            besty = neighY.objs[temp_random];
        } else if (hb.valgrid.field[myx][myy] > this.idealTemp) {
            int i = 0;
            while (i < neighX.numObjs) {
                if ((neighX.objs[i] != myx || neighY.objs[i] != myy) && (bestx == -1 || neighVal.objs[i] < hb.valgrid.field[bestx][besty] || neighVal.objs[i] == hb.valgrid.field[bestx][besty] && state.random.nextBoolean())) {
                    bestx = neighX.objs[i];
                    besty = neighY.objs[i];
                }
                ++i;
            }
        } else if (hb.valgrid.field[myx][myy] < this.idealTemp) {
            int i = 0;
            while (i < neighX.numObjs) {
                if ((neighX.objs[i] != myx || neighY.objs[i] != myy) && (bestx == -1 || neighVal.objs[i] > hb.valgrid.field[bestx][besty] || neighVal.objs[i] > hb.valgrid.field[bestx][besty] && state.random.nextBoolean())) {
                    bestx = neighX.objs[i];
                    besty = neighY.objs[i];
                }
                ++i;
            }
        } else {
            bestx = myx;
            besty = myy;
        }
        hb.buggrid.setObjectLocation(this, bestx, besty);
        this.addHeat(hb.valgrid, bestx, besty, this.heatOutput);
    }
}

