/*
 * Decompiled with CFR 0.152.
 */
package sim.app.heatbugs;

import sim.app.heatbugs.HeatBugs;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.field.grid.DoubleGrid2D;
import sim.util.Int2D;
import sim.util.Interval;

public class HeatBug
implements Steppable {
    private static final long serialVersionUID = 1L;
    public double idealTemp;
    public double heatOutput;
    public double randomMovementProbability;

    public double getIdealTemperature() {
        return this.idealTemp;
    }

    public void setIdealTemperature(double t) {
        this.idealTemp = t;
    }

    public double getHeatOutput() {
        return this.heatOutput;
    }

    public void setHeatOutput(double t) {
        this.heatOutput = t;
    }

    public double getRandomMovementProbability() {
        return this.randomMovementProbability;
    }

    public void setRandomMovementProbability(double t) {
        if (t >= 0.0 && t <= 1.0) {
            this.randomMovementProbability = t;
        }
    }

    public Object domRandomMovementProbability() {
        return new Interval(0.0, 1.0);
    }

    public HeatBug(double idealTemp, double heatOutput, double randomMovementProbability) {
        this.heatOutput = heatOutput;
        this.idealTemp = idealTemp;
        this.randomMovementProbability = randomMovementProbability;
    }

    public void addHeat(DoubleGrid2D grid, int x, int y, double heat) {
        double[] dArray = grid.field[x];
        int n = y;
        dArray[n] = dArray[n] + heat;
        if (grid.field[x][y] > 32000.0) {
            grid.field[x][y] = 32000.0;
        }
    }

    @Override
    public void step(SimState state) {
        HeatBugs hb = (HeatBugs)state;
        Int2D location = hb.buggrid.getObjectLocation(this);
        int myx = location.x;
        int myy = location.y;
        int START = -1;
        int bestx = -1;
        int besty = 0;
        if (state.random.nextBoolean(this.randomMovementProbability)) {
            bestx = hb.buggrid.stx(state.random.nextInt(3) - 1 + myx);
            besty = hb.buggrid.sty(state.random.nextInt(3) - 1 + myy);
        } else if (hb.valgrid.field[myx][myy] > this.idealTemp) {
            int x = -1;
            while (x < 2) {
                int y = -1;
                while (y < 2) {
                    if (x != 0 || y != 0) {
                        int xx = hb.buggrid.stx(x + myx);
                        int yy = hb.buggrid.sty(y + myy);
                        if (bestx == -1 || hb.valgrid.field[xx][yy] < hb.valgrid.field[bestx][besty] || hb.valgrid.field[xx][yy] == hb.valgrid.field[bestx][besty] && state.random.nextBoolean()) {
                            bestx = xx;
                            besty = yy;
                        }
                    }
                    ++y;
                }
                ++x;
            }
        } else if (hb.valgrid.field[myx][myy] < this.idealTemp) {
            int x = -1;
            while (x < 2) {
                int y = -1;
                while (y < 2) {
                    if (x != 0 || y != 0) {
                        int xx = hb.buggrid.stx(x + myx);
                        int yy = hb.buggrid.sty(y + myy);
                        if (bestx == -1 || hb.valgrid.field[xx][yy] > hb.valgrid.field[bestx][besty] || hb.valgrid.field[xx][yy] == hb.valgrid.field[bestx][besty] && state.random.nextBoolean()) {
                            bestx = xx;
                            besty = yy;
                        }
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            bestx = myx;
            besty = myy;
        }
        hb.buggrid.setObjectLocation(this, bestx, besty);
        this.addHeat(hb.valgrid, bestx, besty, this.heatOutput);
    }
}

