/*
 * Decompiled with CFR 0.152.
 */
package sim.app.cto;

import java.io.Serializable;
import sim.app.cto.CooperativeObservation;
import sim.util.Double2D;

public class KMeansEngine
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final double ALFA = 0.25;
    Double2D[] clusterPoints;
    Boolean[] usable;
    Double2D[] means;
    int[] labels;
    int[] n;
    double[] weight;
    CooperativeObservation co;

    public KMeansEngine(CooperativeObservation co) {
        this.co = co;
        this.clusterPoints = new Double2D[10];
        this.usable = new Boolean[10];
        this.means = new Double2D[10];
        int i = 0;
        while (i < 10) {
            this.clusterPoints[i] = new Double2D();
            this.means[i] = new Double2D();
            this.usable[i] = new Boolean(false);
            ++i;
        }
        this.labels = new int[40];
        this.n = new int[10];
        this.weight = new double[10];
        Thread thread = new Thread(){

            @Override
            public void run() {
                KMeansEngine.this.doKMeans();
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double2D getGoalPosition(int id) {
        Boolean bl = this.usable[id];
        synchronized (bl) {
            if (this.usable[id].booleanValue()) {
                return this.clusterPoints[id];
            }
            return null;
        }
    }

    public final double distanceBetweenPointsSQR(double x1, double y1, double x2, double y2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doKMeans() {
        while (true) {
            int i = 0;
            while (i < 10) {
                this.weight[i] = 0.0;
                if (this.means[i].x == 0.0 && this.means[i].y == 0.0) {
                    this.clusterPoints[i] = this.means[i];
                }
                this.means[i] = this.co.agentPos[i];
                ++i;
            }
            i = 0;
            while (i < 40) {
                int min = -1;
                double distance = -1.0;
                int j = 0;
                while (j < 10) {
                    double currDist = this.distanceBetweenPointsSQR(this.co.targetPos[i].x, this.co.targetPos[i].y, this.co.agentPos[j].x, this.co.agentPos[j].y);
                    if (distance == -1.0 || distance > currDist) {
                        min = j;
                        distance = currDist;
                    }
                    ++j;
                }
                this.labels[i] = min;
                ++i;
            }
            i = 0;
            while (i < 10) {
                this.means[i] = new Double2D(0.0, 0.0);
                this.n[i] = 0;
                ++i;
            }
            i = 0;
            while (i < 40) {
                if (this.labels[i] != -1) {
                    this.means[this.labels[i]] = new Double2D(this.means[this.labels[i]].x + this.co.targetPos[i].x, this.means[this.labels[i]].y + this.co.targetPos[i].y);
                    int n = this.labels[i];
                    this.n[n] = this.n[n] + 1;
                }
                ++i;
            }
            i = 0;
            while (i < 10) {
                Boolean bl = this.usable[i];
                synchronized (bl) {
                    if (this.n[i] != 0) {
                        this.means[i] = new Double2D(this.means[i].x / (double)this.n[i], this.means[i].y / (double)this.n[i]);
                        this.clusterPoints[i] = new Double2D(0.75 * this.clusterPoints[i].x + 0.25 * this.means[i].x, 0.75 * this.clusterPoints[i].y + 0.25 * this.means[i].y);
                        this.usable[i] = new Boolean(true);
                    } else {
                        this.usable[i] = new Boolean(false);
                    }
                }
                ++i;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

