/*
 * Decompiled with CFR 0.152.
 */
package sim.app.asteroids;

import sim.app.asteroids.Asteroid;
import sim.app.asteroids.Ship;
import sim.engine.SimState;
import sim.field.continuous.Continuous2D;
import sim.util.Double2D;
import sim.util.MutableDouble2D;

public class Asteroids
extends SimState {
    private static final long serialVersionUID = 1L;
    public static final int WAIT_PERIOD = 60;
    public static final double SAFE_DISTANCE = 30.0;
    public Continuous2D field;
    public double width = 150.0;
    public double height = 150.0;
    public int numAsteroids = 5;
    public int numShips = 1;
    public int score = 0;
    public int deaths = 0;
    public int level = 0;
    public int asteroidCount = 0;
    public int[] actions = new int[this.numShips];
    public Ship[] ships = new Ship[this.numShips];

    public Asteroids(long seed) {
        super(seed);
    }

    public void createShip(int tag) {
        this.ships[tag] = new Ship(this, new MutableDouble2D(0.0, 0.0), new Double2D(this.width / 2.0, this.height / 2.0), tag);
    }

    public void createAsteroids() {
        ++this.level;
        int x = 0;
        while (x < this.numAsteroids) {
            double angle = this.random.nextDouble() * Math.PI * 2.0;
            Double2D loc = null;
            int i = 0;
            while (i < 1000) {
                loc = this.random.nextBoolean() ? new Double2D(0.0, this.random.nextDouble() * this.height) : new Double2D(this.random.nextDouble() * this.width, 0.0);
                boolean bad = false;
                int j = 0;
                while (j < this.numShips) {
                    if (this.ships[j] != null && this.field.getObjectLocation(this.ships[j]).distance(loc) < 30.0) {
                        bad = true;
                        break;
                    }
                    ++j;
                }
                if (!bad) break;
                ++i;
            }
            new Asteroid(this, 4, new MutableDouble2D(0.3 * Math.cos(angle), 0.3 * Math.sin(angle)), loc);
            ++x;
        }
    }

    @Override
    public void start() {
        super.start();
        this.field = new Continuous2D(this.width, this.width, this.height);
        int x = 0;
        while (x < this.numShips) {
            this.createShip(x);
            ++x;
        }
        this.createAsteroids();
    }

    public static void main(String[] args) {
        Asteroids.doLoop(Asteroids.class, args);
        System.exit(0);
    }
}

