/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.opsworks.model.DataSource;
import com.amazonaws.services.opsworks.model.Source;
import com.amazonaws.services.opsworks.model.SslConfiguration;
import com.amazonaws.services.opsworks.model.UpdateAppRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateAppRequestMarshaller
implements Marshaller<Request<UpdateAppRequest>, UpdateAppRequest> {
    @Override
    public Request<UpdateAppRequest> marshall(UpdateAppRequest updateAppRequest) {
        if (updateAppRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateAppRequest> request = new DefaultRequest<UpdateAppRequest>(updateAppRequest, "AWSOpsWorks");
        String target = "OpsWorks_20130218.UpdateApp";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SslConfiguration sslConfiguration;
            ListWithAutoConstructFlag domainsList;
            Source appSource;
            ListWithAutoConstructFlag dataSourcesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (updateAppRequest.getAppId() != null) {
                jsonWriter.key("AppId").value(updateAppRequest.getAppId());
            }
            if (updateAppRequest.getName() != null) {
                jsonWriter.key("Name").value(updateAppRequest.getName());
            }
            if (updateAppRequest.getDescription() != null) {
                jsonWriter.key("Description").value(updateAppRequest.getDescription());
            }
            if (!((dataSourcesList = (ListWithAutoConstructFlag)updateAppRequest.getDataSources()) == null || dataSourcesList.isAutoConstruct() && dataSourcesList.isEmpty())) {
                jsonWriter.key("DataSources");
                jsonWriter.array();
                for (DataSource dataSourcesListValue : dataSourcesList) {
                    if (dataSourcesListValue == null) continue;
                    jsonWriter.object();
                    if (dataSourcesListValue.getType() != null) {
                        jsonWriter.key("Type").value(dataSourcesListValue.getType());
                    }
                    if (dataSourcesListValue.getArn() != null) {
                        jsonWriter.key("Arn").value(dataSourcesListValue.getArn());
                    }
                    if (dataSourcesListValue.getDatabaseName() != null) {
                        jsonWriter.key("DatabaseName").value(dataSourcesListValue.getDatabaseName());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (updateAppRequest.getType() != null) {
                jsonWriter.key("Type").value(updateAppRequest.getType());
            }
            if ((appSource = updateAppRequest.getAppSource()) != null) {
                jsonWriter.key("AppSource");
                jsonWriter.object();
                if (appSource.getType() != null) {
                    jsonWriter.key("Type").value(appSource.getType());
                }
                if (appSource.getUrl() != null) {
                    jsonWriter.key("Url").value(appSource.getUrl());
                }
                if (appSource.getUsername() != null) {
                    jsonWriter.key("Username").value(appSource.getUsername());
                }
                if (appSource.getPassword() != null) {
                    jsonWriter.key("Password").value(appSource.getPassword());
                }
                if (appSource.getSshKey() != null) {
                    jsonWriter.key("SshKey").value(appSource.getSshKey());
                }
                if (appSource.getRevision() != null) {
                    jsonWriter.key("Revision").value(appSource.getRevision());
                }
                jsonWriter.endObject();
            }
            if (!((domainsList = (ListWithAutoConstructFlag)updateAppRequest.getDomains()) == null || domainsList.isAutoConstruct() && domainsList.isEmpty())) {
                jsonWriter.key("Domains");
                jsonWriter.array();
                for (String domainsListValue : domainsList) {
                    if (domainsListValue == null) continue;
                    jsonWriter.value(domainsListValue);
                }
                jsonWriter.endArray();
            }
            if (updateAppRequest.isEnableSsl() != null) {
                jsonWriter.key("EnableSsl").value(updateAppRequest.isEnableSsl());
            }
            if ((sslConfiguration = updateAppRequest.getSslConfiguration()) != null) {
                jsonWriter.key("SslConfiguration");
                jsonWriter.object();
                if (sslConfiguration.getCertificate() != null) {
                    jsonWriter.key("Certificate").value(sslConfiguration.getCertificate());
                }
                if (sslConfiguration.getPrivateKey() != null) {
                    jsonWriter.key("PrivateKey").value(sslConfiguration.getPrivateKey());
                }
                if (sslConfiguration.getChain() != null) {
                    jsonWriter.key("Chain").value(sslConfiguration.getChain());
                }
                jsonWriter.endObject();
            }
            if (updateAppRequest.getAttributes() != null) {
                jsonWriter.key("Attributes");
                jsonWriter.object();
                for (Map.Entry<String, String> attributesListValue : updateAppRequest.getAttributes().entrySet()) {
                    if (attributesListValue.getValue() == null) continue;
                    jsonWriter.key(attributesListValue.getKey());
                    jsonWriter.value(attributesListValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

