/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutRecordRequestMarshaller
implements Marshaller<Request<PutRecordRequest>, PutRecordRequest> {
    @Override
    public Request<PutRecordRequest> marshall(PutRecordRequest putRecordRequest) {
        if (putRecordRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutRecordRequest> request = new DefaultRequest<PutRecordRequest>(putRecordRequest, "AmazonKinesis");
        String target = "Kinesis_20131202.PutRecord";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (putRecordRequest.getStreamName() != null) {
                jsonWriter.key("StreamName").value(putRecordRequest.getStreamName());
            }
            if (putRecordRequest.getData() != null) {
                jsonWriter.key("Data").value(putRecordRequest.getData());
            }
            if (putRecordRequest.getPartitionKey() != null) {
                jsonWriter.key("PartitionKey").value(putRecordRequest.getPartitionKey());
            }
            if (putRecordRequest.getExplicitHashKey() != null) {
                jsonWriter.key("ExplicitHashKey").value(putRecordRequest.getExplicitHashKey());
            }
            if (putRecordRequest.getSequenceNumberForOrdering() != null) {
                jsonWriter.key("SequenceNumberForOrdering").value(putRecordRequest.getSequenceNumberForOrdering());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

